/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.RegexAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.util.MappedRegexRealmMapper;
import org.wildfly.security.auth.util.SimpleRegexRealmMapper;

class RealmMapperDefinitions {
    static final SimpleAttributeDefinition DELEGATE_REALM_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("delegate-realm-mapper", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.realm-mapper", "org.wildfly.security.realm-mapper", true)).build();
    static final SimpleMapAttributeDefinition REALM_REALM_MAP = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("realm-map", ModelType.STRING, false).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if ((resourceModel = resourceModel.get(attribute.getName())).isDefined()) {
                for (ModelNode property : resourceModel.asList()) {
                    writer.writeEmptyElement("realm-mapping");
                    writer.writeAttribute("from", property.asProperty().getName());
                    writer.writeAttribute("to", property.asProperty().getValue().asString());
                }
            }
        }
    })).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

    RealmMapperDefinitions() {
    }

    static ResourceDefinition getSimpleRegexRealmMapperDefinition() {
        return new SimpleRegexRealmMapperDefinition();
    }

    static ResourceDefinition getMappedRegexRealmMapper() {
        return new MappedRegexRealmMapperDefinition();
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler(String parentName, AttributeDefinition ... attributes) {
            super(parentName, attributes);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(RealmMapper.class);
        }
    }

    private static class MappedRegexRealmMapperAddHandler
    extends BaseAddHandler {
        private MappedRegexRealmMapperAddHandler(AttributeDefinition[] attributes) {
            super(Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY, attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmMapperName = runtimeCapability.getCapabilityServiceName(RealmMapper.class);
            String pattern = RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP.resolveModelAttribute(context, model).asString();
            ModelNode realmMapList = REALM_REALM_MAP.resolveModelAttribute(context, model);
            Set names = realmMapList.keys();
            HashMap realmRealmMap = new HashMap(names.size());
            names.forEach(s -> realmRealmMap.put(s, realmMapList.require(s).asString()));
            String delegateRealmMapper = ElytronExtension.asStringIfDefined(context, DELEGATE_REALM_MAPPER, model);
            InjectedValue delegateRealmMapperInjector = new InjectedValue();
            TrivialService<RealmMapper> realmMapperService = new TrivialService<RealmMapper>(() -> {
                RealmMapper delegate = (RealmMapper)delegateRealmMapperInjector.getOptionalValue();
                Pattern compiledPattern = Pattern.compile(pattern);
                if (delegate == null) {
                    return new MappedRegexRealmMapper(compiledPattern, realmRealmMap);
                }
                return new MappedRegexRealmMapper(compiledPattern, delegate, realmRealmMap);
            });
            ServiceBuilder realmMapperBuilder = serviceTarget.addService(realmMapperName, realmMapperService);
            if (delegateRealmMapper != null) {
                String delegateCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.realm-mapper", (String)delegateRealmMapper);
                ServiceName delegateServiceName = context.getCapabilityServiceName(delegateCapabilityName, RealmMapper.class);
                realmMapperBuilder.addDependency(delegateServiceName, RealmMapper.class, (Injector)delegateRealmMapperInjector);
            }
            ElytronDefinition.commonDependencies(realmMapperBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }

    private static class MappedRegexRealmMapperDefinition
    extends SimpleResourceDefinition {
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP, REALM_REALM_MAP, DELEGATE_REALM_MAPPER};
        private static final AbstractAddStepHandler ADD = new MappedRegexRealmMapperAddHandler(ATTRIBUTES);
        private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY);

        private MappedRegexRealmMapperDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"mapped-regex-realm-mapper"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("mapped-regex-realm-mapper")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY}));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            WriteAttributeHandler write = new WriteAttributeHandler("mapped-regex-realm-mapper", ATTRIBUTES);
            for (AttributeDefinition current : ATTRIBUTES) {
                resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
            }
        }
    }

    private static class SimpleRegexRealmMapperAddHandler
    extends BaseAddHandler {
        private SimpleRegexRealmMapperAddHandler(AttributeDefinition[] attributes) {
            super(Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY, attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmMapperName = runtimeCapability.getCapabilityServiceName(RealmMapper.class);
            String pattern = RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP.resolveModelAttribute(context, model).asString();
            String delegateRealmMapper = ElytronExtension.asStringIfDefined(context, DELEGATE_REALM_MAPPER, model);
            InjectedValue delegateRealmMapperInjector = new InjectedValue();
            TrivialService<RealmMapper> realmMapperService = new TrivialService<RealmMapper>(() -> {
                RealmMapper delegate = (RealmMapper)delegateRealmMapperInjector.getOptionalValue();
                Pattern compiledPattern = Pattern.compile(pattern);
                if (delegate == null) {
                    return new SimpleRegexRealmMapper(compiledPattern);
                }
                return new SimpleRegexRealmMapper(compiledPattern, delegate);
            });
            ServiceBuilder realmMapperBuilder = serviceTarget.addService(realmMapperName, realmMapperService);
            if (delegateRealmMapper != null) {
                String delegateCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.realm-mapper", (String)delegateRealmMapper);
                ServiceName delegateServiceName = context.getCapabilityServiceName(delegateCapabilityName, RealmMapper.class);
                realmMapperBuilder.addDependency(delegateServiceName, RealmMapper.class, (Injector)delegateRealmMapperInjector);
            }
            ElytronDefinition.commonDependencies(realmMapperBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }

    private static class SimpleRegexRealmMapperDefinition
    extends SimpleResourceDefinition {
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP, DELEGATE_REALM_MAPPER};
        private static final AbstractAddStepHandler ADD = new SimpleRegexRealmMapperAddHandler(ATTRIBUTES);
        private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY);

        private SimpleRegexRealmMapperDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"simple-regex-realm-mapper"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("simple-regex-realm-mapper")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY}));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            WriteAttributeHandler write = new WriteAttributeHandler("simple-regex-realm-mapper", ATTRIBUTES);
            for (AttributeDefinition current : ATTRIBUTES) {
                resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
            }
        }
    }
}

