package org.wildfly.extension.elytron._private;

import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceController.State;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.lang.Class;
import java.util.Arrays;
import java.security.NoSuchProviderException;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2016-11-08T17:56:21+0000")
public class ElytronSubsystemMessages_$logger extends DelegatingBasicLogger implements ElytronSubsystemMessages,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronSubsystemMessages_$logger.class.getName();
    public ElytronSubsystemMessages_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void activatingElytronSubsystem(final String elytronVersion, final String subsystemVersion) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, activatingElytronSubsystem$str(), elytronVersion, subsystemVersion);
    }
    private static final String activatingElytronSubsystem = "WFLYELY00001: Activating Elytron Subsystem Elytron Version=%s, Subsystem Version=%s";
    protected String activatingElytronSubsystem$str() {
        return activatingElytronSubsystem;
    }
    private static final String duplicateRealmInjection = "WFLYELY00002: Can not inject the same realm '%s' in a single security domain '%s'.";
    protected String duplicateRealmInjection$str() {
        return duplicateRealmInjection;
    }
    @Override
    public final OperationFailedException duplicateRealmInjection(final String realmName, final String domainName) {
        final OperationFailedException result = new OperationFailedException(String.format(duplicateRealmInjection$str(), realmName, domainName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationAddressMissingKey = "WFLYELY00003: The operation did not contain an address with a value for '%s'.";
    protected String operationAddressMissingKey$str() {
        return operationAddressMissingKey;
    }
    @Override
    public final IllegalArgumentException operationAddressMissingKey(final String key) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(operationAddressMissingKey$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToStartService = "WFLYELY00004: Unable to start the service.";
    protected String unableToStartService$str() {
        return unableToStartService;
    }
    @Override
    public final StartException unableToStartService(final Exception cause) {
        final StartException result = new StartException(String.format(unableToStartService$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToAccessKeyStore = "WFLYELY00005: Unable to access KeyStore to complete the requested operation.";
    protected String unableToAccessKeyStore$str() {
        return unableToAccessKeyStore;
    }
    @Override
    public final OperationFailedException unableToAccessKeyStore(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToAccessKeyStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToPopulateResult = "WFLYELY00006: Unable to populate result.";
    protected String unableToPopulateResult$str() {
        return unableToPopulateResult;
    }
    @Override
    public final OperationFailedException unableToPopulateResult(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToPopulateResult$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredServiceNotUp = "WFLYELY00007: The required service '%s' is not UP, it is currently '%s'.";
    protected String requiredServiceNotUp$str() {
        return requiredServiceNotUp;
    }
    @Override
    public final OperationFailedException requiredServiceNotUp(final ServiceName serviceName, final State state) {
        final OperationFailedException result = new OperationFailedException(String.format(requiredServiceNotUp$str(), serviceName, state));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOperationName = "WFLYELY00008: Invalid operation name '%s', expected one of '%s'";
    protected String invalidOperationName$str() {
        return invalidOperationName;
    }
    @Override
    public final OperationFailedException invalidOperationName(final String actualName, final String... expectedNames) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidOperationName$str(), actualName, Arrays.toString(expectedNames)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCompleteOperation = "WFLYELY00009: Unable to complete operation. '%s'";
    protected String unableToCompleteOperation$str() {
        return unableToCompleteOperation;
    }
    @Override
    public final OperationFailedException unableToCompleteOperation(final Throwable cause, final String causeMessage) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToCompleteOperation$str(), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cantSaveWithoutFile = "WFLYELY00010: Unable to complete operation.";
    protected String cantSaveWithoutFile$str() {
        return cantSaveWithoutFile;
    }
    @Override
    public final OperationFailedException cantSaveWithoutFile() {
        final OperationFailedException result = new OperationFailedException(String.format(cantSaveWithoutFile$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String providerAlreadyRegistered = "WFLYELY00011: A Provider is already registered for '%s'";
    protected String providerAlreadyRegistered$str() {
        return providerAlreadyRegistered;
    }
    @Override
    public final StartException providerAlreadyRegistered(final String name) {
        final StartException result = new StartException(String.format(providerAlreadyRegistered$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuitableProvider = "WFLYELY00012: No suitable provider found for type '%s'";
    protected String noSuitableProvider$str() {
        return noSuitableProvider;
    }
    @Override
    public final StartException noSuitableProvider(final String type) {
        final StartException result = new StartException(String.format(noSuitableProvider$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultRealmNotReferenced = "WFLYELY00013: The default-realm '%s' is not in the list of realms [%s] referenced by this domain.";
    protected String defaultRealmNotReferenced$str() {
        return defaultRealmNotReferenced;
    }
    @Override
    public final OperationFailedException defaultRealmNotReferenced(final String defaultRealm, final String realms) {
        final OperationFailedException result = new OperationFailedException(String.format(defaultRealmNotReferenced$str(), defaultRealm, realms));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadPropertiesFiles = "WFLYELY00014: Unable to load the properties files required to start the properties file backed realm.";
    protected String unableToLoadPropertiesFiles$str() {
        return unableToLoadPropertiesFiles;
    }
    @Override
    public final StartException unableToLoadPropertiesFiles(final Exception cause) {
        final StartException result = new StartException(String.format(unableToLoadPropertiesFiles$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentNotConfigurable = "WFLYELY00015: The custom component implementation '%s' doe not implement 'org.wildfly.extension.elytron.Configurable' however configuration has been supplied.";
    protected String componentNotConfigurable$str() {
        return componentNotConfigurable;
    }
    @Override
    public final StartException componentNotConfigurable(final String className) {
        final StartException result = new StartException(String.format(componentNotConfigurable$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRegularExpression = "WFLYELY00016: The supplied regular expression '%s' is invalid.";
    protected String invalidRegularExpression$str() {
        return invalidRegularExpression;
    }
    @Override
    public final OperationFailedException invalidRegularExpression(final String pattern, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidRegularExpression$str(), pattern), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateManagerFactory = "WFLYELY00018: Unable to create %s for algorithm '%s'.";
    protected String unableToCreateManagerFactory$str() {
        return unableToCreateManagerFactory;
    }
    @Override
    public final StartException unableToCreateManagerFactory(final String type, final String algorithm) {
        final StartException result = new StartException(String.format(unableToCreateManagerFactory$str(), type, algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTypeFound = "WFLYELY00019: No '%s' found in injected value.";
    protected String noTypeFound$str() {
        return noTypeFound;
    }
    @Override
    public final StartException noTypeFound(final String type) {
        final StartException result = new StartException(String.format(noTypeFound$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReLoadPropertiesFiles = "WFLYELY00020: Unable to reload the properties files required to by the properties file backed realm.";
    protected String unableToReLoadPropertiesFiles$str() {
        return unableToReLoadPropertiesFiles;
    }
    @Override
    public final OperationFailedException unableToReLoadPropertiesFiles(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToReLoadPropertiesFiles$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionWhileCreatingPermission = "WFLYELY00021: Exception while creating the permission object for the permission mapping. Please check [class-name], [target-name] (name of permission) and [action] of [%s].";
    protected String exceptionWhileCreatingPermission$str() {
        return exceptionWhileCreatingPermission;
    }
    @Override
    public final StartException exceptionWhileCreatingPermission(final String permissionClassName, final Throwable cause) {
        final StartException result = new StartException(String.format(exceptionWhileCreatingPermission$str(), permissionClassName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreFileNotExists = "WFLYELY00022: KeyStore file '%s' does not exists and required.";
    protected String keyStoreFileNotExists$str() {
        return keyStoreFileNotExists;
    }
    @Override
    public final StartException keyStoreFileNotExists(final String file) {
        final StartException result = new StartException(String.format(keyStoreFileNotExists$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keyStoreFileNotExistsButIgnored(final String file) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, keyStoreFileNotExistsButIgnored$str(), file);
    }
    private static final String keyStoreFileNotExistsButIgnored = "WFLYELY00023: KeyStore file '%s' does not exists. Used blank.";
    protected String keyStoreFileNotExistsButIgnored$str() {
        return keyStoreFileNotExistsButIgnored;
    }
    @Override
    public final void certificateNotValid(final String alias, final Exception cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, certificateNotValid$str(), alias);
    }
    private static final String certificateNotValid = "WFLYELY00024: Certificate [%s] in KeyStore is not valid";
    protected String certificateNotValid$str() {
        return certificateNotValid;
    }
    private static final String credentialStoreEntryTypeNotSupported = "WFLYELY00909: Credential store '%s' does not support given credential store entry type '%s'";
    protected String credentialStoreEntryTypeNotSupported$str() {
        return credentialStoreEntryTypeNotSupported;
    }
    @Override
    public final IllegalArgumentException credentialStoreEntryTypeNotSupported(final String credentialStoreName, final String entryType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(credentialStoreEntryTypeNotSupported$str(), credentialStoreName, entryType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordCredentialIsNotDefined = "WFLYELY00910: Password credential is not defined in '%s'";
    protected String passwordCredentialIsNotDefined$str() {
        return passwordCredentialIsNotDefined;
    }
    @Override
    public final OperationFailedException passwordCredentialIsNotDefined(final String attribute) {
        final OperationFailedException result = new OperationFailedException(String.format(passwordCredentialIsNotDefined$str(), attribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedCredentialType = "WFLYELY00911: Unsupported credential type '%s'";
    protected String unsupportedCredentialType$str() {
        return unsupportedCredentialType;
    }
    @Override
    public final UnsupportedCredentialTypeException unsupportedCredentialType(final String credentialType) {
        final UnsupportedCredentialTypeException result = new UnsupportedCredentialTypeException(String.format(unsupportedCredentialType$str(), credentialType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialStoreIssueEncountered = "WFLYELY00912: Credential store issue encountered";
    protected String credentialStoreIssueEncountered$str() {
        return credentialStoreIssueEncountered;
    }
    @Override
    public final OperationFailedException credentialStoreIssueEncountered(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(credentialStoreIssueEncountered$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialAliasNotSpecifiedInUriReference = "WFLYELY00913: Credential alias not specified in URI reference '%s'";
    protected String credentialAliasNotSpecifiedInUriReference$str() {
        return credentialAliasNotSpecifiedInUriReference;
    }
    @Override
    public final OperationFailedException credentialAliasNotSpecifiedInUriReference(final String uriReference) {
        final OperationFailedException result = new OperationFailedException(String.format(credentialAliasNotSpecifiedInUriReference$str(), uriReference));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String providerLoaderCannotSupplyProvider = "WFLYELY00914: Provider loader '%s' cannot supply Credential Store provider of type '%s'";
    protected String providerLoaderCannotSupplyProvider$str() {
        return providerLoaderCannotSupplyProvider;
    }
    @Override
    public final NoSuchProviderException providerLoaderCannotSupplyProvider(final String providerLoader, final String type) {
        final NoSuchProviderException result = new NoSuchProviderException(String.format(providerLoaderCannotSupplyProvider$str(), providerLoader, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String identityAlreadyExists = "WFLYELY01000: Identity with name [%s] already exists.";
    protected String identityAlreadyExists$str() {
        return identityAlreadyExists;
    }
    @Override
    public final OperationFailedException identityAlreadyExists(final String principalName) {
        final OperationFailedException result = new OperationFailedException(String.format(identityAlreadyExists$str(), principalName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateIdentity = "WFLYELY01001: Could not create identity with name [%s].";
    protected String couldNotCreateIdentity$str() {
        return couldNotCreateIdentity;
    }
    @Override
    public final OperationFailedException couldNotCreateIdentity(final String principalName, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotCreateIdentity$str(), principalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String identityNotFound = "WFLYELY01002: Identity with name [%s] not found.";
    protected String identityNotFound$str() {
        return identityNotFound;
    }
    @Override
    public final String identityNotFound(final String principalName) {
        return String.format(identityNotFound$str(), principalName);
    }
    private static final String couldNotDeleteIdentity = "WFLYELY01003: Could not delete identity with name [%s].";
    protected String couldNotDeleteIdentity$str() {
        return couldNotDeleteIdentity;
    }
    @Override
    public final OperationFailedException couldNotDeleteIdentity(final String principalName, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotDeleteIdentity$str(), principalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String identityNotAuthorized = "WFLYELY01004: Identity with name [%s] not authorized.";
    protected String identityNotAuthorized$str() {
        return identityNotAuthorized;
    }
    @Override
    public final String identityNotAuthorized(final String principalName) {
        return String.format(identityNotAuthorized$str(), principalName);
    }
    private static final String couldNotReadIdentity2 = "WFLYELY01005: Could not read identity [%s] from security domain [%s].";
    protected String couldNotReadIdentity2$str() {
        return couldNotReadIdentity2;
    }
    @Override
    public final OperationFailedException couldNotReadIdentity(final String principalName, final ServiceName domainServiceName, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotReadIdentity2$str(), principalName, domainServiceName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedPasswordType = "WFLYELY01006: Unsupported password type [%s].";
    protected String unsupportedPasswordType$str() {
        return unsupportedPasswordType;
    }
    @Override
    public final RuntimeException unsupportedPasswordType(final Class passwordType) {
        final RuntimeException result = new RuntimeException(String.format(unsupportedPasswordType$str(), passwordType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotReadIdentity1 = "WFLYELY01007: Could not read identity with name [%s].";
    protected String couldNotReadIdentity1$str() {
        return couldNotReadIdentity1;
    }
    @Override
    public final OperationFailedException couldNotReadIdentity(final String principalName, final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotReadIdentity1$str(), principalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainAuthorizationIdentity = "WFLYELY01008: Failed to obtain the authorization identity.";
    protected String couldNotObtainAuthorizationIdentity$str() {
        return couldNotObtainAuthorizationIdentity;
    }
    @Override
    public final OperationFailedException couldNotObtainAuthorizationIdentity(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotObtainAuthorizationIdentity$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotAddAttribute = "WFLYELY01009: Failed to add attribute.";
    protected String couldNotAddAttribute$str() {
        return couldNotAddAttribute;
    }
    @Override
    public final OperationFailedException couldNotAddAttribute(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotAddAttribute$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotRemoveAttribute = "WFLYELY01010: Failed to remove attribute.";
    protected String couldNotRemoveAttribute$str() {
        return couldNotRemoveAttribute;
    }
    @Override
    public final OperationFailedException couldNotRemoveAttribute(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotRemoveAttribute$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreatePassword = "WFLYELY01011: Could not create password.";
    protected String couldNotCreatePassword$str() {
        return couldNotCreatePassword;
    }
    @Override
    public final OperationFailedException couldNotCreatePassword(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(couldNotCreatePassword$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedPasswordType = "WFLYELY01012: Unexpected password type [%s].";
    protected String unexpectedPasswordType$str() {
        return unexpectedPasswordType;
    }
    @Override
    public final OperationFailedException unexpectedPasswordType(final String passwordType) {
        final OperationFailedException result = new OperationFailedException(String.format(unexpectedPasswordType$str(), passwordType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patternRequiresCaptureGroup = "WFLYELY01013: Pattern [%s] requires a capture group";
    protected String patternRequiresCaptureGroup$str() {
        return patternRequiresCaptureGroup;
    }
    @Override
    public final OperationFailedException patternRequiresCaptureGroup(final String pattern) {
        final OperationFailedException result = new OperationFailedException(String.format(patternRequiresCaptureGroup$str(), pattern));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDefinition = "WFLYELY01014: Invalid [%s] definition.";
    protected String invalidDefinition$str() {
        return invalidDefinition;
    }
    @Override
    public final OperationFailedException invalidDefinition(final String property) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidDefinition$str(), property));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
