/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialStoreClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.elytron.CredentialStoreResourceDefinition;
import org.wildfly.extension.elytron.CredentialStoreService;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

class CredentialStoreAliasDefinition
extends SimpleResourceDefinition {
    static final String OTHER = "Other";
    private static final Class<?>[] SUPPORTED_CREDENTIAL_TYPES = new Class[]{PasswordCredential.class};
    static final SimpleAttributeDefinition ENTRY_TYPE;
    static final StandardResourceDescriptionResolver RESOURCE_DESCRIPTION_RESOLVER;
    static final SimpleAttributeDefinition SECRET_VALUE;
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES;
    private static final SimpleOperationDefinition ADD_DEFINITION;
    private static final AddHandler ADD_HANDLER;

    CredentialStoreAliasDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"alias"), (ResourceDescriptionResolver)RESOURCE_DESCRIPTION_RESOLVER).setRemoveHandler((OperationStepHandler)new RemoveHandler()).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_NONE).setRuntime());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)ADD_DEFINITION, (OperationStepHandler)ADD_HANDLER);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SECRET_VALUE, null, (OperationStepHandler)new WriteAttributeHandler());
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ENTRY_TYPE, null, (OperationStepHandler)new WriteAttributeHandler());
    }

    static String alias(ModelNode operation) {
        String aliasName = null;
        PathAddress pa = PathAddress.pathAddress((ModelNode)operation.require("address"));
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"alias".equals(pe.getKey())) continue;
            aliasName = pe.getValue();
            break;
        }
        if (aliasName == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.operationAddressMissingKey("alias");
        }
        return aliasName;
    }

    static PasswordCredential createCredentialFromPassword(char[] password) throws UnsupportedCredentialTypeException {
        try {
            PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
            return new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(password)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnsupportedCredentialTypeException((Throwable)e);
        }
    }

    static {
        List<String> entryTypes = Stream.of(SUPPORTED_CREDENTIAL_TYPES).map(Class::getName).collect(Collectors.toList());
        entryTypes.add(OTHER);
        ENTRY_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("entry-type", ModelType.STRING).setStorageRuntime()).setAllowNull(true)).setAllowedValues(entryTypes.toArray(new String[entryTypes.size()]))).build();
        RESOURCE_DESCRIPTION_RESOLVER = ElytronExtension.getResourceDescriptionResolver("credential-store", "alias");
        SECRET_VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secret-value", ModelType.STRING).setStorageRuntime()).setAllowNull(false)).build();
        CONFIG_ATTRIBUTES = new AttributeDefinition[]{SECRET_VALUE, ENTRY_TYPE};
        ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", (ResourceDescriptionResolver)RESOURCE_DESCRIPTION_RESOLVER).setParameters(new AttributeDefinition[]{SECRET_VALUE, ENTRY_TYPE}).build();
        ADD_HANDLER = new AddHandler();
    }

    private static class WriteAttributeHandler
    extends AbstractWriteAttributeHandler<String> {
        WriteAttributeHandler() {
            super(CONFIG_ATTRIBUTES);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<String> handbackHolder) throws OperationFailedException {
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handback) throws OperationFailedException {
        }
    }

    private static class RemoveHandler
    extends CredentialStoreResourceDefinition.CredentialStoreRuntimeOnlyHandler {
        RemoveHandler() {
            super(true, true);
        }

        @Override
        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, CredentialStoreService credentialStoreService) throws OperationFailedException {
            String alias = CredentialStoreAliasDefinition.alias(operation);
            try {
                CredentialStoreClient credentialStoreClient = credentialStoreService.getValue();
                CredentialStore credentialStore = credentialStoreClient.getCredentialStore();
                credentialStore.remove(alias, PasswordCredential.class);
            }
            catch (CredentialStoreException | UnsupportedCredentialTypeException e) {
                throw new OperationFailedException(e);
            }
        }
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        AddHandler() {
            super(CONFIG_ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            String alias = CredentialStoreAliasDefinition.alias(operation);
            String secretValue = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SECRET_VALUE, resource.getModel());
            String entryType = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ENTRY_TYPE, resource.getModel());
            ServiceName credentialStoreServiceName = CredentialStoreResourceDefinition.CREDENTIAL_STORE_CLIENT_UTIL.serviceName(operation);
            ServiceController serviceContainer = context.getServiceRegistry(false).getRequiredService(credentialStoreServiceName);
            CredentialStoreClient credentialStoreClient = ((CredentialStoreService)serviceContainer.getService()).getValue();
            CredentialStore credentialStore = credentialStoreClient.getCredentialStore();
            try {
                if (entryType != null && !"clear".equals(entryType)) {
                    String credentialStoreName = CredentialStoreResourceDefinition.credentialStoreName(operation);
                    throw ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreEntryTypeNotSupported(credentialStoreName, entryType);
                }
                credentialStore.store(alias, (Credential)CredentialStoreAliasDefinition.createCredentialFromPassword(secretValue.toCharArray()));
            }
            catch (CredentialStoreException | UnsupportedCredentialTypeException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, e.getLocalizedMessage());
            }
        }

        protected Resource createResource(OperationContext context) {
            Resource resource = Resource.Factory.create((boolean)true);
            context.addResource(PathAddress.EMPTY_ADDRESS, resource);
            return resource;
        }
    }
}

