/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Map;
import org.jboss.as.controller.security.CredentialStoreClient;
import org.jboss.as.controller.security.CredentialStoreURIParser;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;

class CredentialStoreService
implements Service<CredentialStoreClient> {
    private CredentialStore credentialStore;
    private final String type;
    private final String provider;
    private final String providerLoaderName;
    private final String relativeTo;
    private final String name;
    private final Map<String, String> credentialStoreAttributes;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final InjectedValue<Provider[]> providers = new InjectedValue();
    private PathManager.Callback.Handle callbackHandle;

    private CredentialStoreService(String name, Map<String, String> credentialStoreAttributes, String type, String provider, String relativeTo, String providerLoaderName) throws CredentialStoreException {
        this.name = name;
        this.type = type != null ? type : "KeyStorePasswordStore";
        this.provider = provider;
        this.relativeTo = relativeTo;
        this.credentialStoreAttributes = credentialStoreAttributes;
        this.providerLoaderName = providerLoaderName;
    }

    static CredentialStoreService createCredentialStoreService(String name, String uri, String type, String provider, String relativeTo, String providerLoaderName) throws CredentialStoreException {
        try {
            CredentialStoreURIParser credentialStoreURIParser = new CredentialStoreURIParser(uri);
            String nameToSet = name != null ? name : credentialStoreURIParser.getName();
            Map credentialStoreAttributes = credentialStoreURIParser.getOptionsMap();
            credentialStoreAttributes.put("store.name", nameToSet);
            String storageFile = credentialStoreURIParser.getStorageFile();
            if (storageFile != null) {
                credentialStoreAttributes.put("store.file", storageFile);
            }
            return new CredentialStoreService(nameToSet, credentialStoreAttributes, type, provider, relativeTo, providerLoaderName);
        }
        catch (URISyntaxException e) {
            throw new CredentialStoreException((Throwable)e);
        }
    }

    public void start(StartContext startContext) throws StartException {
        this.resolveFileLocation();
        try {
            this.credentialStore = this.getCredentialStoreInstance();
            this.credentialStore.initialize(this.credentialStoreAttributes);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CredentialStoreException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService((Exception)e);
        }
    }

    public void stop(StopContext stopContext) {
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
    }

    public CredentialStoreClient getValue() {
        return new CredentialStoreClient(this.credentialStore, this.name, null);
    }

    private void resolveFileLocation() {
        File baseDir;
        if (this.relativeTo != null) {
            PathManager pathManager = (PathManager)this.pathManager.getValue();
            baseDir = new File(pathManager.resolveRelativePathEntry("", this.relativeTo));
            this.callbackHandle = pathManager.registerCallback(this.relativeTo, new PathManager.Callback(){

                public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                    if (!eventContext.isResourceServiceRestartAllowed()) {
                        eventContext.reloadRequired();
                    }
                }

                public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                }
            }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
        } else {
            baseDir = new File(".");
        }
        if (baseDir != null) {
            this.credentialStoreAttributes.put("store.base", baseDir.getAbsolutePath());
        }
    }

    private CredentialStore getCredentialStoreInstance() throws CredentialStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        if (this.provider != null) {
            return CredentialStore.getInstance((String)this.type, (String)this.provider);
        }
        Provider[] injectedProviders = (Provider[])this.providers.getOptionalValue();
        if (injectedProviders != null) {
            for (Provider p : injectedProviders) {
                try {
                    return CredentialStore.getInstance((String)this.type, (Provider)p);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
            }
            throw ElytronSubsystemMessages.ROOT_LOGGER.providerLoaderCannotSupplyProvider(this.providerLoaderName, this.type);
        }
        return CredentialStore.getInstance((String)this.type);
    }

    Injector<Provider[]> getProvidersInjector() {
        return this.providers;
    }

    Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }
}

