/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.realm.ldap.SimpleDirContextFactoryBuilder;

public class DirContextDefinition
extends SimpleResourceDefinition {
    public static final String CONNECTION_POOLING_PROPERTY = "com.sun.jndi.ldap.connect.pool";
    static final SimpleAttributeDefinition URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition AUTHENTICATION_LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-level", ModelType.STRING, true).setDefaultValue(new ModelNode("simple"))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PRINCIPAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CREDENTIAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("credential", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition ENABLE_CONNECTION_POOLING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-connection-pooling", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition REFERRAL_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("referral-mode", ModelType.STRING, true).setDefaultValue(new ModelNode(DirContextFactory.ReferralMode.IGNORE.name()))).setAllowedValues(new String[]{DirContextFactory.ReferralMode.FOLLOW.name(), DirContextFactory.ReferralMode.IGNORE.name(), DirContextFactory.ReferralMode.THROW.name()})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.ssl-context", "org.wildfly.security.dir-context", true)).build();
    static final SimpleAttributeDefinition CONNECTION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-timeout", ModelType.INT, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition READ_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("read-timeout", ModelType.INT, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{URL, AUTHENTICATION_LEVEL, PRINCIPAL, CREDENTIAL, ENABLE_CONNECTION_POOLING, REFERRAL_MODE, SSL_CONTEXT, CONNECTION_TIMEOUT, READ_TIMEOUT};
    private static final AbstractAddStepHandler ADD = new AbstractAddStepHandler(Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY, (AttributeDefinition[])ATTRIBUTES){

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            RuntimeCapability runtimeCapability = Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(ExceptionSupplier.class);
            InjectedValue sslContextInjector = new InjectedValue();
            TrivialService service = new TrivialService(DirContextDefinition.obtainDirContextSupplier(context, model, (InjectedValue<SSLContext>)sslContextInjector));
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, service);
            String sslContextName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SSL_CONTEXT, model);
            if (sslContextName != null) {
                String sslCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.ssl-context", (String)sslContextName);
                ServiceName sslServiceName = context.getCapabilityServiceName(sslCapability, SSLContext.class);
                serviceBuilder.addDependency(sslServiceName, SSLContext.class, (Injector)sslContextInjector);
            }
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    };
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY);

    DirContextDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"dir-context"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("dir-context")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler handler = new WriteAttributeHandler();
        for (SimpleAttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)current, null, (OperationStepHandler)handler);
        }
    }

    private static TrivialService.ValueSupplier<ExceptionSupplier<DirContext, NamingException>> obtainDirContextSupplier(OperationContext context, ModelNode model, InjectedValue<SSLContext> sslContextInjector) throws OperationFailedException {
        String url = URL.resolveModelAttribute(context, model).asString();
        String authenticationLevel = AUTHENTICATION_LEVEL.resolveModelAttribute(context, model).asString();
        String principal = PRINCIPAL.resolveModelAttribute(context, model).asString();
        String credential = CREDENTIAL.resolveModelAttribute(context, model).asString();
        Properties connectionProperties = new Properties();
        ModelNode enableConnectionPoolingNode = ENABLE_CONNECTION_POOLING.resolveModelAttribute(context, model);
        connectionProperties.put(CONNECTION_POOLING_PROPERTY, (Object)enableConnectionPoolingNode.asBoolean());
        ModelNode connectionTimeout = CONNECTION_TIMEOUT.resolveModelAttribute(context, model);
        ModelNode readTimeout = READ_TIMEOUT.resolveModelAttribute(context, model);
        DirContextFactory.ReferralMode referralMode = DirContextFactory.ReferralMode.valueOf((String)REFERRAL_MODE.resolveModelAttribute(context, model).asString().toUpperCase());
        return () -> {
            SimpleDirContextFactoryBuilder builder = SimpleDirContextFactoryBuilder.builder().setProviderUrl(url).setSecurityAuthentication(authenticationLevel).setSecurityPrincipal(principal).setSecurityCredential(credential).setConnectionProperties(connectionProperties);
            SSLContext sslContext = (SSLContext)sslContextInjector.getOptionalValue();
            if (sslContext != null) {
                builder.setSocketFactory((SocketFactory)sslContext.getSocketFactory());
            }
            if (connectionTimeout.isDefined()) {
                builder.setConnectTimeout(connectionTimeout.asInt());
            }
            if (readTimeout.isDefined()) {
                builder.setReadTimeout(readTimeout.asInt());
            }
            DirContextFactory dirContextFactory = builder.build();
            return () -> dirContextFactory.obtainDirContext(referralMode);
        };
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("dir-context", (AttributeDefinition[])ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            String name = parentAddress.getLastElement().getValue();
            return Capabilities.DIR_CONTEXT_RUNTIME_CAPABILITY.fromBaseCapability(name).getCapabilityServiceName();
        }
    }
}

