/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.Assert;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;

class DomainService
implements Service<SecurityDomain> {
    private volatile SecurityDomain securityDomain;
    private final String name;
    private final String defaultRealm;
    private final List<String> trustedSecurityDomainsList;
    private String preRealmNameRewriter;
    private String postRealmNameRewriter;
    private String roleMapper;
    private final Map<String, RealmDependency> realms = new HashMap<String, RealmDependency>();
    private final Map<String, InjectedValue<NameRewriter>> nameRewriters = new HashMap<String, InjectedValue<NameRewriter>>();
    private final Map<String, InjectedValue<RoleMapper>> roleMappers = new HashMap<String, InjectedValue<RoleMapper>>();
    private final Map<String, InjectedValue<RoleDecoder>> roleDecoders = new HashMap<String, InjectedValue<RoleDecoder>>();
    private final InjectedValue<PrincipalDecoder> principalDecoderInjector = new InjectedValue();
    private final InjectedValue<RealmMapper> realmMapperInjector = new InjectedValue();
    private final InjectedValue<PermissionMapper> permissionMapperInjector = new InjectedValue();
    private final HashSet<SecurityDomain> trustedSecurityDomains = new HashSet();

    DomainService(String name, String defaultRealm, List<String> trustedSecurityDomainsList) {
        this.name = name;
        this.defaultRealm = defaultRealm;
        this.trustedSecurityDomainsList = trustedSecurityDomainsList;
    }

    RealmDependency createRealmDependency(String realmName) throws OperationFailedException {
        if (this.realms.containsKey(realmName)) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.duplicateRealmInjection(realmName, this.name);
        }
        RealmDependency realmDependency = new RealmDependency();
        this.realms.put(realmName, realmDependency);
        return realmDependency;
    }

    private Injector<NameRewriter> createNameRewriterInjector(String nameRewriterName) {
        if (this.nameRewriters.containsKey(nameRewriterName)) {
            return null;
        }
        InjectedValue nameRewriterInjector = new InjectedValue();
        this.nameRewriters.put(nameRewriterName, (InjectedValue<NameRewriter>)nameRewriterInjector);
        return nameRewriterInjector;
    }

    private Injector<RoleMapper> createRoleMapperInjector(String roleMapperName) {
        if (this.roleMappers.containsKey(roleMapperName)) {
            return null;
        }
        InjectedValue roleMapperInjector = new InjectedValue();
        this.roleMappers.put(roleMapperName, (InjectedValue<RoleMapper>)roleMapperInjector);
        return roleMapperInjector;
    }

    private Injector<RoleDecoder> createRoleDecoderInjector(String roleDecoderName) {
        if (this.roleDecoders.containsKey(roleDecoderName)) {
            return null;
        }
        InjectedValue roleDecoderInjector = new InjectedValue();
        this.roleDecoders.put(roleDecoderName, (InjectedValue<RoleDecoder>)roleDecoderInjector);
        return roleDecoderInjector;
    }

    Injector<PrincipalDecoder> getPrincipalDecoderInjector() {
        return this.principalDecoderInjector;
    }

    Injector<RealmMapper> getRealmMapperInjector() {
        return this.realmMapperInjector;
    }

    Injector<PermissionMapper> getPermissionMapperInjector() {
        return this.permissionMapperInjector;
    }

    Injector<NameRewriter> createPreRealmNameRewriterInjector(String name) {
        this.preRealmNameRewriter = name;
        return this.createNameRewriterInjector(name);
    }

    Injector<NameRewriter> createPostRealmNameRewriterInjector(String name) {
        this.postRealmNameRewriter = name;
        return this.createNameRewriterInjector(name);
    }

    Injector<RoleMapper> createDomainRoleMapperInjector(String name) {
        this.roleMapper = name;
        return this.createRoleMapperInjector(name);
    }

    public void start(StartContext context) throws StartException {
        PermissionMapper permissionMapper;
        RealmMapper realmMapper;
        PrincipalDecoder principalDecoder;
        SecurityDomain.Builder builder = SecurityDomain.builder();
        if (this.preRealmNameRewriter != null) {
            builder.setPreRealmRewriter((NameRewriter)this.nameRewriters.get(this.preRealmNameRewriter).getValue());
        }
        if (this.postRealmNameRewriter != null) {
            builder.setPostRealmRewriter((NameRewriter)this.nameRewriters.get(this.postRealmNameRewriter).getValue());
        }
        if ((principalDecoder = (PrincipalDecoder)this.principalDecoderInjector.getOptionalValue()) != null) {
            builder.setPrincipalDecoder(PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{principalDecoder, PrincipalDecoder.DEFAULT}));
        }
        if ((realmMapper = (RealmMapper)this.realmMapperInjector.getOptionalValue()) != null) {
            builder.setRealmMapper(realmMapper);
        }
        if ((permissionMapper = (PermissionMapper)this.permissionMapperInjector.getOptionalValue()) != null) {
            builder.setPermissionMapper(permissionMapper);
        }
        if (this.roleMapper != null) {
            builder.setRoleMapper((RoleMapper)this.roleMappers.get(this.roleMapper).getValue());
        }
        builder.setDefaultRealmName(this.defaultRealm);
        for (Map.Entry<String, RealmDependency> entry : this.realms.entrySet()) {
            RoleDecoder roleDecoder;
            String realmName = entry.getKey();
            RealmDependency realmDependency = entry.getValue();
            SecurityDomain.RealmBuilder realmBuilder = builder.addRealm(realmName, (SecurityRealm)realmDependency.securityRealmInjector.getValue());
            if (realmDependency.nameRewriter != null) {
                realmBuilder.setNameRewriter((NameRewriter)this.nameRewriters.get(realmDependency.nameRewriter).getValue());
            }
            if (realmDependency.roleDecoder != null && (roleDecoder = (RoleDecoder)this.roleDecoders.get(realmDependency.roleDecoder).getOptionalValue()) != null) {
                realmBuilder.setRoleDecoder(roleDecoder);
            }
            if (realmDependency.roleMapper != null) {
                realmBuilder.setRoleMapper((RoleMapper)this.roleMappers.get(realmDependency.roleMapper).getValue());
            }
            realmBuilder.build();
        }
        builder.setTrustedSecurityDomainPredicate(this.trustedSecurityDomains::contains);
        this.securityDomain = builder.build();
        ServiceTarget serviceTarget = context.getChildTarget();
        TrustedSecurityDomainsService trustedSecurityDomainsService = new TrustedSecurityDomainsService(this.trustedSecurityDomains);
        ServiceName trustedSecurityDomainsServiceName = Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY.getCapabilityServiceName(this.name).append(new String[]{"trusted-security-domains"});
        ServiceBuilder serviceBuilder = serviceTarget.addService(trustedSecurityDomainsServiceName, (Service)trustedSecurityDomainsService).setInitialMode(ServiceController.Mode.ACTIVE);
        for (String trustedSecurityDomain : this.trustedSecurityDomainsList) {
            ServiceName domainServiceName = Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY.getCapabilityServiceName(trustedSecurityDomain);
            serviceBuilder.addDependency(domainServiceName, SecurityDomain.class, trustedSecurityDomainsService.createTrustedSecurityDomainInjector());
        }
        serviceBuilder.install();
    }

    public void stop(StopContext context) {
        this.securityDomain = null;
    }

    public SecurityDomain getValue() throws IllegalStateException, IllegalArgumentException {
        return this.securityDomain;
    }

    private static class TrustedSecurityDomainsService
    implements Service<SecurityDomain> {
        private final List<InjectedValue<SecurityDomain>> trustedSecurityDomainInjectors = new ArrayList<InjectedValue<SecurityDomain>>();
        private HashSet<SecurityDomain> trustedSecurityDomains;

        private TrustedSecurityDomainsService(HashSet<SecurityDomain> trustedSecurityDomains) {
            Assert.checkNotNullParam((String)"trustedSecurityDomains", trustedSecurityDomains);
            this.trustedSecurityDomains = trustedSecurityDomains;
        }

        public void start(StartContext context) throws StartException {
            this.trustedSecurityDomains.addAll(this.trustedSecurityDomainInjectors.stream().map(InjectedValue::getValue).collect(Collectors.toCollection(HashSet::new)));
        }

        public void stop(StopContext context) {
            this.trustedSecurityDomains = null;
        }

        public SecurityDomain getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }

        Injector<SecurityDomain> createTrustedSecurityDomainInjector() {
            InjectedValue injectedValue = new InjectedValue();
            this.trustedSecurityDomainInjectors.add((InjectedValue<SecurityDomain>)injectedValue);
            return injectedValue;
        }
    }

    class RealmDependency {
        private InjectedValue<SecurityRealm> securityRealmInjector = new InjectedValue();
        private String nameRewriter;
        private String roleMapper;
        private String roleDecoder;

        RealmDependency() {
        }

        Injector<SecurityRealm> getSecurityRealmInjector() {
            return this.securityRealmInjector;
        }

        Injector<NameRewriter> getNameRewriterInjector(String name) {
            this.nameRewriter = name;
            return DomainService.this.createNameRewriterInjector(name);
        }

        Injector<RoleDecoder> getRoleDecoderInjector(String name) {
            this.roleDecoder = name;
            return DomainService.this.createRoleDecoderInjector(name);
        }

        Injector<RoleMapper> getRoleMapperInjector(String name) {
            this.roleMapper = name;
            return DomainService.this.createRoleMapperInjector(name);
        }
    }
}

