/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.security.CredentialStoreClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.KeyStoreDefinition;
import org.wildfly.extension.elytron.SSLContextResource;
import org.wildfly.extension.elytron.SSLSessionDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.Protocol;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLContextBuilder;

class SSLDefinitions {
    static final ServiceUtil<SSLContext> SERVER_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY, "server-ssl-context", SSLContext.class);
    static final ServiceUtil<SSLContext> CLIENT_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY, "client-ssl-context", SSLContext.class);
    static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROVIDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROVIDER_LOADER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-loader", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEYSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.ssl-context", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CIPHER_SUITE_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cipher-suite-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final String[] ALLOWED_PROTOCOLS = new String[]{"SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
    static final StringListAttributeDefinition PROTOCOLS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("protocols").setAllowExpression(true)).setMinSize(1)).setAllowNull(true)).setAllowedValues(ALLOWED_PROTOCOLS)).setValidator((ParameterValidator)new StringValuesValidator(ALLOWED_PROTOCOLS))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition WANT_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("want-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition NEED_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("need-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition AUTHENTICATION_OPTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-optional", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition USE_CIPHER_SUITES_ORDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-cipher-suites-order", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MAXIMUM_SESSION_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-session-cache-size", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SESSION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-timeout", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEY_MANAGERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-managers", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.key-managers", "org.wildfly.security.ssl-context", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition TRUST_MANAGERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trust-managers", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.trust-managers", "org.wildfly.security.ssl-context", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static SimpleAttributeDefinition ACTIVE_SESSION_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("active-session-count", ModelType.INT).setStorageRuntime()).build();

    SSLDefinitions() {
    }

    static ResourceDefinition getKeyManagerDefinition() {
        final SimpleAttributeDefinition providerLoaderDefinition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDER_LOADER).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.key-managers", true)).build();
        final SimpleAttributeDefinition keystoreDefinition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEYSTORE).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.key-managers", true)).build();
        ObjectTypeAttributeDefinition credentialReference = CredentialReference.getAttributeDefinition();
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providerLoaderDefinition, PROVIDER, keystoreDefinition, credentialReference};
        TrivialAddHandler<KeyManager[]> add = new TrivialAddHandler<KeyManager[]>(KeyManager[].class, attributes, new RuntimeCapability[]{Capabilities.KEY_MANAGERS_RUNTIME_CAPABILITY, Capabilities.CREDENTIAL_STORE_CLIENT_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<KeyManager[]> getValueSupplier(ServiceBuilder<KeyManager[]> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithm = ALGORITHM.resolveModelAttribute(context, model).asString();
                String provider = PROVIDER.resolveModelAttribute(context, model).isDefined() ? PROVIDER.resolveModelAttribute(context, model).asString() : null;
                String providerLoader = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)providerLoaderDefinition, model);
                InjectedValue providersInjector = new InjectedValue();
                if (providerLoader != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providerLoader), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStoreName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)keystoreDefinition, model);
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStoreName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                String credentialStoreName = CredentialReference.credentialReferencePartAsStringIfDefined((OperationContext)context, (ObjectTypeAttributeDefinition)KeyStoreDefinition.CREDENTIAL_REFERENCE, (ModelNode)model, (String)"store");
                String credentialAlias = CredentialReference.credentialReferencePartAsStringIfDefined((OperationContext)context, (ObjectTypeAttributeDefinition)KeyStoreDefinition.CREDENTIAL_REFERENCE, (ModelNode)model, (String)"alias");
                String credentialType = CredentialReference.credentialReferencePartAsStringIfDefined((OperationContext)context, (ObjectTypeAttributeDefinition)KeyStoreDefinition.CREDENTIAL_REFERENCE, (ModelNode)model, (String)"type");
                String secret = CredentialReference.credentialReferencePartAsStringIfDefined((OperationContext)context, (ObjectTypeAttributeDefinition)KeyStoreDefinition.CREDENTIAL_REFERENCE, (ModelNode)model, (String)"clear-text");
                CredentialReference credentialReference = credentialStoreName != null && !credentialStoreName.isEmpty() ? CredentialReference.createCredentialReference((String)credentialStoreName, (String)credentialAlias, (String)credentialType) : CredentialReference.createCredentialReference((char[])(secret != null ? secret.toCharArray() : null));
                InjectedValue credentialStoreClientInjector = new InjectedValue();
                if (credentialReference.getAlias() != null) {
                    String credentialStoreClientCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.credential-store-client", (String)credentialReference.getCredentialStoreName());
                    ServiceName credentialStoreClientServiceName = context.getCapabilityServiceName(credentialStoreClientCapabilityName, CredentialStoreClient.class);
                    KeyStoreDefinition.CREDENTIAL_STORE_CLIENT_SERVICE_UTIL.addInjection(serviceBuilder, (Injector<CredentialStoreClient>)credentialStoreClientInjector, credentialStoreClientServiceName);
                }
                return () -> {
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    KeyManagerFactory keyManagerFactory = null;
                    if (providers != null) {
                        for (Provider provider2 : providers) {
                            if (provider != null && !provider.equals(provider2.getName())) continue;
                            try {
                                keyManagerFactory = KeyManagerFactory.getInstance(algorithm, provider2);
                                break;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                // empty catch block
                            }
                        }
                        if (keyManagerFactory == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(KeyManagerFactory.class.getSimpleName(), algorithm);
                        }
                    } else {
                        try {
                            keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new StartException((Throwable)e);
                        }
                    }
                    try {
                        char[] password;
                        CredentialReference.reinjectCredentialStoreClient((InjectedValue)credentialStoreClientInjector, (CredentialReference)credentialReference);
                        CredentialStoreClient credentialStoreClient = (CredentialStoreClient)credentialStoreClientInjector.getOptionalValue();
                        KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                        char[] cArray = password = credentialStoreClient != null ? credentialStoreClient.getSecret() : credentialReference.getSecret();
                        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("KeyManager supplying:  providers = %s  provider = %s  algorithm = %s  keyManagerFactory = %s  keyStoreName = %s  keyStore = %s  password (of item) = %b", new Object[]{Arrays.toString(providers), provider, algorithm, keyManagerFactory, keyStoreName, keyStore, password != null});
                        }
                        keyManagerFactory.init(keyStore, password);
                    }
                    catch (ClassNotFoundException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                        throw new StartException((Throwable)e);
                    }
                    return keyManagerFactory.getKeyManagers();
                };
            }
        };
        return new TrivialResourceDefinition("key-managers", add, attributes, Capabilities.KEY_MANAGERS_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getTrustManagerDefinition() {
        final SimpleAttributeDefinition providerLoaderDefinition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDER_LOADER).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.trust-managers", true)).build();
        final SimpleAttributeDefinition keystoreDefinition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEYSTORE).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.trust-managers", true)).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providerLoaderDefinition, PROVIDER, keystoreDefinition};
        TrivialAddHandler<TrustManager[]> add = new TrivialAddHandler<TrustManager[]>(TrustManager[].class, attributes, new RuntimeCapability[]{Capabilities.TRUST_MANAGERS_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<TrustManager[]> getValueSupplier(ServiceBuilder<TrustManager[]> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithm = ALGORITHM.resolveModelAttribute(context, model).asString();
                String provider = PROVIDER.resolveModelAttribute(context, model).isDefined() ? PROVIDER.resolveModelAttribute(context, model).asString() : null;
                String providerLoader = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)providerLoaderDefinition, model);
                InjectedValue providersInjector = new InjectedValue();
                if (providerLoader != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providerLoader), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStoreName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)keystoreDefinition, model);
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStoreName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                return () -> {
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    TrustManagerFactory trustManagerFactory = null;
                    if (providers != null) {
                        for (Provider provider2 : providers) {
                            if (provider != null && !provider.equals(provider2.getName())) continue;
                            try {
                                trustManagerFactory = TrustManagerFactory.getInstance(algorithm, provider2);
                                break;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                // empty catch block
                            }
                        }
                        if (trustManagerFactory == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(TrustManagerFactory.class.getSimpleName(), algorithm);
                        }
                    } else {
                        try {
                            trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new StartException((Throwable)e);
                        }
                    }
                    KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                    if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("KeyManager supplying:  providers = %s  provider = %s  algorithm = %s  trustManagerFactory = %s  keyStoreName = %s  keyStore = %s", new Object[]{Arrays.toString(providers), provider, algorithm, trustManagerFactory, keyStoreName, keyStore});
                    }
                    try {
                        trustManagerFactory.init((KeyStore)keyStoreInjector.getOptionalValue());
                    }
                    catch (KeyStoreException e) {
                        throw new StartException((Throwable)e);
                    }
                    return trustManagerFactory.getTrustManagers();
                };
            }
        };
        return new TrivialResourceDefinition("trust-managers", add, attributes, Capabilities.TRUST_MANAGERS_RUNTIME_CAPABILITY, Capabilities.CREDENTIAL_STORE_CLIENT_RUNTIME_CAPABILITY);
    }

    private static <T> InjectedValue<T> addDependency(String baseName, SimpleAttributeDefinition attribute, Class<T> type, ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
        String dynamicNameElement = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)attribute, model);
        InjectedValue injectedValue = new InjectedValue();
        if (dynamicNameElement != null) {
            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)baseName, (String)dynamicNameElement), type), type, (Injector)injectedValue);
        }
        return injectedValue;
    }

    static ResourceDefinition getServerSSLContextDefinition() {
        final SimpleAttributeDefinition providerLoaderDefinition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDER_LOADER).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.ssl-context", true)).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{SECURITY_DOMAIN, CIPHER_SUITE_FILTER, PROTOCOLS, WANT_CLIENT_AUTH, NEED_CLIENT_AUTH, AUTHENTICATION_OPTIONAL, USE_CIPHER_SUITES_ORDER, MAXIMUM_SESSION_CACHE_SIZE, SESSION_TIMEOUT, KEY_MANAGERS, TRUST_MANAGERS, providerLoaderDefinition};
        return new SSLContextDefinition("server-ssl-context", true, (AbstractAddStepHandler)new TrivialAddHandler<SSLContext>(SSLContext.class, attributes, new RuntimeCapability[]{Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue securityDomainInjector = SSLDefinitions.addDependency("org.wildfly.security.security-domain", SECURITY_DOMAIN, SecurityDomain.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue keyManagersInjector = SSLDefinitions.addDependency("org.wildfly.security.key-managers", KEY_MANAGERS, KeyManager[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue trustManagersInjector = SSLDefinitions.addDependency("org.wildfly.security.trust-managers", TRUST_MANAGERS, TrustManager[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue providersInjector = SSLDefinitions.addDependency("org.wildfly.security.providers", providerLoaderDefinition, Provider[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                List protocols = PROTOCOLS.unwrap((ExpressionResolver)context, model);
                String cipherSuiteFilter = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CIPHER_SUITE_FILTER, model);
                boolean wantClientAuth = WANT_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean needClientAuth = NEED_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean authenticationOptional = AUTHENTICATION_OPTIONAL.resolveModelAttribute(context, model).asBoolean();
                boolean useCipherSuitesOrder = USE_CIPHER_SUITES_ORDER.resolveModelAttribute(context, model).asBoolean();
                int maximumSessionCacheSize = MAXIMUM_SESSION_CACHE_SIZE.resolveModelAttribute(context, model).asInt();
                int sessionTimeout = SESSION_TIMEOUT.resolveModelAttribute(context, model).asInt();
                return () -> {
                    SecurityDomain securityDomain = (SecurityDomain)securityDomainInjector.getOptionalValue();
                    X509ExtendedKeyManager keyManager = SSLDefinitions.getX509KeyManager((KeyManager[])keyManagersInjector.getOptionalValue());
                    X509ExtendedTrustManager trustManager = SSLDefinitions.getX509TrustManager((TrustManager[])trustManagersInjector.getOptionalValue());
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    SSLContextBuilder builder = new SSLContextBuilder();
                    if (securityDomain != null) {
                        builder.setSecurityDomain(securityDomain);
                    }
                    if (keyManager != null) {
                        builder.setKeyManager(keyManager);
                    }
                    if (trustManager != null) {
                        builder.setTrustManager((X509TrustManager)trustManager);
                    }
                    if (providers != null) {
                        builder.setProviderSupplier(() -> 3.lambda$null$0((Provider[])providers));
                    }
                    if (cipherSuiteFilter != null) {
                        builder.setCipherSuiteSelector(CipherSuiteSelector.fromString((String)cipherSuiteFilter));
                    }
                    if (!protocols.isEmpty()) {
                        builder.setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(protocols.stream().map(Protocol::forName).collect(Collectors.toList()))));
                    }
                    builder.setWantClientAuth(wantClientAuth).setNeedClientAuth(needClientAuth).setAuthenticationOptional(authenticationOptional).setUseCipherSuitesOrder(useCipherSuitesOrder).setSessionCacheSize(maximumSessionCacheSize).setSessionTimeout(sessionTimeout);
                    if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("ServerSSLContext supplying:  securityDomain = %s  keyManager = %s  trustManager = %s  providers = %s  cipherSuiteFilter = %s  protocols = %s  wantClientAuth = %s  needClientAuth = %s  authenticationOptional = %s  maximumSessionCacheSize = %s  sessionTimeout = %s", new Object[]{securityDomain, keyManager, trustManager, Arrays.toString(providers), cipherSuiteFilter, Arrays.toString(protocols.toArray()), wantClientAuth, needClientAuth, authenticationOptional, maximumSessionCacheSize, sessionTimeout});
                    }
                    try {
                        return (SSLContext)builder.build().create();
                    }
                    catch (GeneralSecurityException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }

            protected Resource createResource(OperationContext context) {
                SSLContextResource resource = new SSLContextResource(Resource.Factory.create(), true);
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
                return resource;
            }

            @Override
            protected void installedForResource(ServiceController<SSLContext> serviceController, Resource resource) {
                ((SSLContextResource)resource).setSSLContextServiceController(serviceController);
            }

            private static /* synthetic */ Provider[] lambda$null$0(Provider[] providers) {
                return providers;
            }
        }, attributes);
    }

    static ResourceDefinition getClientSSLContextDefinition() {
        final SimpleAttributeDefinition providerLoaderDefinition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDER_LOADER).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.ssl-context", true)).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{CIPHER_SUITE_FILTER, PROTOCOLS, USE_CIPHER_SUITES_ORDER, MAXIMUM_SESSION_CACHE_SIZE, SESSION_TIMEOUT, KEY_MANAGERS, TRUST_MANAGERS, providerLoaderDefinition};
        return new SSLContextDefinition("client-ssl-context", false, (AbstractAddStepHandler)new TrivialAddHandler<SSLContext>(SSLContext.class, attributes, new RuntimeCapability[]{Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue keyManagersInjector = SSLDefinitions.addDependency("org.wildfly.security.key-managers", KEY_MANAGERS, KeyManager[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue trustManagersInjector = SSLDefinitions.addDependency("org.wildfly.security.trust-managers", TRUST_MANAGERS, TrustManager[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue providersInjector = SSLDefinitions.addDependency("org.wildfly.security.providers", providerLoaderDefinition, Provider[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                List protocols = PROTOCOLS.unwrap((ExpressionResolver)context, model);
                String cipherSuiteFilter = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CIPHER_SUITE_FILTER, model);
                boolean useCipherSuitesOrder = USE_CIPHER_SUITES_ORDER.resolveModelAttribute(context, model).asBoolean();
                int maximumSessionCacheSize = MAXIMUM_SESSION_CACHE_SIZE.resolveModelAttribute(context, model).asInt();
                int sessionTimeout = SESSION_TIMEOUT.resolveModelAttribute(context, model).asInt();
                return () -> {
                    X509ExtendedKeyManager keyManager = SSLDefinitions.getX509KeyManager((KeyManager[])keyManagersInjector.getOptionalValue());
                    X509ExtendedTrustManager trustManager = SSLDefinitions.getX509TrustManager((TrustManager[])trustManagersInjector.getOptionalValue());
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    SSLContextBuilder builder = new SSLContextBuilder();
                    if (keyManager != null) {
                        builder.setKeyManager(keyManager);
                    }
                    if (trustManager != null) {
                        builder.setTrustManager((X509TrustManager)trustManager);
                    }
                    if (providers != null) {
                        builder.setProviderSupplier(() -> 4.lambda$null$0((Provider[])providers));
                    }
                    if (cipherSuiteFilter != null) {
                        builder.setCipherSuiteSelector(CipherSuiteSelector.fromString((String)cipherSuiteFilter));
                    }
                    if (!protocols.isEmpty()) {
                        builder.setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(protocols.stream().map(Protocol::forName).collect(Collectors.toList()))));
                    }
                    builder.setClientMode(true).setUseCipherSuitesOrder(useCipherSuitesOrder).setSessionCacheSize(maximumSessionCacheSize).setSessionTimeout(sessionTimeout);
                    if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("ClientSSLContext supplying:  keyManager = %s  trustManager = %s  providers = %s  cipherSuiteFilter = %s  protocols = %s  maximumSessionCacheSize = %s  sessionTimeout = %s", new Object[]{keyManager, trustManager, Arrays.toString(providers), cipherSuiteFilter, Arrays.toString(protocols.toArray()), maximumSessionCacheSize, sessionTimeout});
                    }
                    try {
                        return (SSLContext)builder.build().create();
                    }
                    catch (GeneralSecurityException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }

            protected Resource createResource(OperationContext context) {
                SSLContextResource resource = new SSLContextResource(Resource.Factory.create(), false);
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
                return resource;
            }

            @Override
            protected void installedForResource(ServiceController<SSLContext> serviceController, Resource resource) {
                ((SSLContextResource)resource).setSSLContextServiceController(serviceController);
            }

            private static /* synthetic */ Provider[] lambda$null$0(Provider[] providers) {
                return providers;
            }
        }, attributes);
    }

    private static X509ExtendedKeyManager getX509KeyManager(KeyManager[] keyManagers) throws StartException {
        if (keyManagers == null) {
            return null;
        }
        for (KeyManager current : keyManagers) {
            if (!(current instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)current;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedKeyManager.class.getSimpleName());
    }

    private static X509ExtendedTrustManager getX509TrustManager(TrustManager[] trustManagers) throws StartException {
        if (trustManagers == null) {
            return null;
        }
        for (TrustManager current : trustManagers) {
            if (!(current instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)current;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedTrustManager.class.getSimpleName());
    }

    static abstract class SSLContextRuntimeHandler
    extends AbstractRuntimeOnlyHandler {
        SSLContextRuntimeHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName serviceName = this.getSSLContextServiceUtil().serviceName(operation);
            ServiceController<SSLContext> serviceController = ElytronExtension.getRequiredService(context.getServiceRegistry(false), serviceName, SSLContext.class);
            ServiceController.State serviceState = serviceController.getState();
            if (serviceState != ServiceController.State.UP) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
            }
            this.performRuntime(context.getResult(), operation, (SSLContext)serviceController.getService().getValue());
        }

        protected abstract void performRuntime(ModelNode var1, ModelNode var2, SSLContext var3) throws OperationFailedException;

        protected abstract ServiceUtil<SSLContext> getSSLContextServiceUtil();
    }

    private static class SSLContextDefinition
    extends TrivialResourceDefinition {
        final boolean server;

        private SSLContextDefinition(String pathKey, boolean server, AbstractAddStepHandler addHandler, AttributeDefinition[] attributes) {
            super(pathKey, addHandler, attributes, Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY);
            this.server = server;
        }

        @Override
        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            super.registerAttributes(resourceRegistration);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ACTIVE_SESSION_COUNT, (OperationStepHandler)new SSLContextRuntimeHandler(){

                @Override
                protected void performRuntime(ModelNode result, ModelNode operation, SSLContext sslContext) throws OperationFailedException {
                    SSLSessionContext sessionContext = server ? sslContext.getServerSessionContext() : sslContext.getClientSessionContext();
                    result.set(Collections.list(sessionContext.getIds()).stream().mapToInt(b -> 1).sum());
                }

                @Override
                protected ServiceUtil<SSLContext> getSSLContextServiceUtil() {
                    return server ? SERVER_SERVICE_UTIL : CLIENT_SERVICE_UTIL;
                }
            });
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            super.registerChildren(resourceRegistration);
            resourceRegistration.registerSubModel((ResourceDefinition)new SSLSessionDefinition(this.server));
        }
    }

    static class StringValuesValidator
    extends ModelTypeValidator
    implements AllowedValuesValidator {
        private List<ModelNode> allowedValues = new ArrayList<ModelNode>();

        StringValuesValidator(String ... values) {
            super(ModelType.STRING);
            for (String value : values) {
                this.allowedValues.add(new ModelNode().set(value));
            }
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined() && !this.allowedValues.contains(value)) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidValue(value.asString(), parameterName, this.allowedValues));
            }
        }

        public List<ModelNode> getAllowedValues() {
            return this.allowedValues;
        }
    }
}

