/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;

public class RealmDefinitions {
    static final AttributeDefinition IDENTITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("identity", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final AttributeDefinition ATTRIBUTE_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("attribute-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StringListAttributeDefinition ATTRIBUTE_VALUES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("attribute-values").setMinSize(0)).setAllowNull(true)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static AttributeDefinition[] IDENTITY_REALM_ATTRIBUTES = new AttributeDefinition[]{IDENTITY, ATTRIBUTE_NAME, ATTRIBUTE_VALUES};

    static ResourceDefinition getIdentityRealmDefinition() {
        TrivialAddHandler<SecurityRealm> add = new TrivialAddHandler<SecurityRealm>(SecurityRealm.class, IDENTITY_REALM_ATTRIBUTES, new RuntimeCapability[]{Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SecurityRealm> getValueSupplier(ServiceBuilder<SecurityRealm> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String identity = IDENTITY.resolveModelAttribute(context, model).asString();
                String attributeName = ElytronExtension.asStringIfDefined(context, ATTRIBUTE_NAME, model);
                List attributeValues = ATTRIBUTE_VALUES.unwrap((ExpressionResolver)context, model);
                return () -> {
                    Map<Object, Object> attributesMap = attributeName != null ? Collections.singletonMap(attributeName, Collections.unmodifiableList(attributeValues)) : Collections.emptyMap();
                    Map<String, SimpleRealmEntry> realmMap = Collections.singletonMap(identity, new SimpleRealmEntry(Collections.emptyList(), (Attributes)new MapAttributes(attributesMap)));
                    SimpleMapBackedSecurityRealm securityRealm = new SimpleMapBackedSecurityRealm();
                    securityRealm.setPasswordMap(realmMap);
                    return securityRealm;
                };
            }
        };
        return new TrivialResourceDefinition("identity-realm", add, IDENTITY_REALM_ATTRIBUTES, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
    }
}

