/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.SingleCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.provider.AggregateSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;

class AggregateRealmDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "aggregate-realm", SecurityRealm.class);
    static final SimpleAttributeDefinition AUTHENTICATION_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-realm", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.security-realm", "org.wildfly.security.security-realm", true)).build();
    static final SimpleAttributeDefinition AUTHORIZATION_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authorization-realm", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.security-realm", "org.wildfly.security.security-realm", true)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{AUTHENTICATION_REALM, AUTHORIZATION_REALM};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new SingleCapabilityServiceRemoveHandler<SecurityRealm>(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, SecurityRealm.class);

    AggregateRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"aggregate-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("aggregate-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler write = new WriteAttributeHandler();
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("jaas-realm", ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(SecurityRealm.class);
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            String authenticationRealm = AUTHENTICATION_REALM.resolveModelAttribute(context, model).asString();
            String authorizationRealm = AUTHORIZATION_REALM.resolveModelAttribute(context, model).asString();
            InjectedValue authenticationRealmValue = new InjectedValue();
            InjectedValue authorizationRealmValue = new InjectedValue();
            TrivialService<SecurityRealm> aggregateRealmService = new TrivialService<SecurityRealm>(() -> new AggregateSecurityRealm((SecurityRealm)authenticationRealmValue.getValue(), (SecurityRealm)authorizationRealmValue.getValue()));
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, aggregateRealmService);
            this.addRealmDependency(context, (ServiceBuilder<SecurityRealm>)serviceBuilder, authenticationRealm, (Injector<SecurityRealm>)authenticationRealmValue);
            this.addRealmDependency(context, (ServiceBuilder<SecurityRealm>)serviceBuilder, authorizationRealm, (Injector<SecurityRealm>)authorizationRealmValue);
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private void addRealmDependency(OperationContext context, ServiceBuilder<SecurityRealm> serviceBuilder, String realmName, Injector<SecurityRealm> securityRealmInjector) {
            String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-realm", (String)realmName);
            ServiceName realmServiceName = context.getCapabilityServiceName(runtimeCapability, SecurityRealm.class);
            REALM_SERVICE_UTIL.addInjection(serviceBuilder, securityRealmInjector, realmServiceName);
        }
    }
}

