/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.auth.provider.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityRealm;

public class FileSystemRealmService
implements Service<SecurityRealm> {
    private volatile SecurityRealm securityRealm;
    private final int levels;
    private final String rootPath;
    private final String relativeTo;
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final InjectedValue<NameRewriter> nameRewriterInjector = new InjectedValue();

    public FileSystemRealmService(int levels, String rootPath, String relativeTo) {
        this.levels = levels;
        this.rootPath = rootPath;
        this.relativeTo = relativeTo;
    }

    public void start(StartContext context) throws StartException {
        PathManager pathManager = (PathManager)this.getPathManagerInjector().getValue();
        String resolvedRootPath = pathManager.resolveRelativePathEntry(this.rootPath, this.relativeTo);
        Path rootPath = Paths.get(resolvedRootPath, new String[0]);
        NameRewriter nameRewriter = (NameRewriter)this.nameRewriterInjector.getOptionalValue();
        this.securityRealm = nameRewriter != null ? new FileSystemSecurityRealm(rootPath, nameRewriter, this.levels) : new FileSystemSecurityRealm(rootPath, this.levels);
    }

    public void stop(StopContext context) {
        this.securityRealm = null;
    }

    public SecurityRealm getValue() throws IllegalStateException, IllegalArgumentException {
        return this.securityRealm;
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    public InjectedValue<NameRewriter> getNameRewriterInjector() {
        return this.nameRewriterInjector;
    }
}

