/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.ProviderUtil;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.keystore.AtomicLoadKeyStore;
import org.wildfly.security.keystore.ModifyTrackingKeyStore;
import org.wildfly.security.keystore.UnmodifiableKeyStore;

class KeyStoreService
implements Service<KeyStore> {
    private final String provider;
    private final String type;
    private final char[] password;
    private final String path;
    private final String relativeTo;
    private final boolean required;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final InjectedValue<Provider[]> providers = new InjectedValue();
    private File resolvedPath;
    private PathManager.Callback.Handle callbackHandle;
    private volatile long synched;
    private volatile AtomicLoadKeyStore keyStore = null;
    private volatile ModifyTrackingKeyStore trackingKeyStore = null;
    private volatile KeyStore unmodifiableKeyStore = null;

    private KeyStoreService(String provider, String type, char[] password, String relativeTo, String path, boolean required) {
        this.provider = provider;
        this.type = type;
        this.password = password != null ? (char[])password.clone() : null;
        this.relativeTo = relativeTo;
        this.path = path;
        this.required = required;
    }

    static KeyStoreService createFileLessKeyStoreService(String provider, String type, char[] password) {
        return new KeyStoreService(provider, type, password, null, null, false);
    }

    static KeyStoreService createFileBasedKeyStoreService(String provider, String type, char[] password, String relativeTo, String path, boolean required) {
        return new KeyStoreService(provider, type, password, relativeTo, path, required);
    }

    public void start(StartContext startContext) throws StartException {
        try {
            AtomicLoadKeyStore keyStore = AtomicLoadKeyStore.newInstance((String)this.type, (Provider)this.resolveProvider());
            if (this.path != null) {
                this.resolveFileLocation();
            }
            this.synched = System.currentTimeMillis();
            try (FileInputStream is = this.resolvedPath != null ? new FileInputStream(this.resolvedPath) : null;){
                keyStore.load((InputStream)is, this.password);
            }
            this.keyStore = keyStore;
            this.trackingKeyStore = ModifyTrackingKeyStore.modifyTrackingKeyStore((KeyStore)keyStore);
            this.unmodifiableKeyStore = UnmodifiableKeyStore.unmodifiableKeyStore((KeyStore)keyStore);
        }
        catch (IOException | GeneralSecurityException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    private Provider resolveProvider() throws StartException {
        Provider[] candidates = (Provider[])this.providers.getOptionalValue();
        Provider identified = ProviderUtil.identifyProvider(candidates == null ? Security.getProviders() : candidates, this.provider, KeyStore.class, this.type);
        if (identified == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.noSuitableProvider(this.type);
        }
        return identified;
    }

    private void resolveFileLocation() {
        if (this.relativeTo != null) {
            PathManager pathManager = (PathManager)this.pathManager.getValue();
            this.resolvedPath = new File(pathManager.resolveRelativePathEntry(this.path, this.relativeTo));
            this.callbackHandle = pathManager.registerCallback(this.relativeTo, new PathManager.Callback(){

                public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                    if (!eventContext.isResourceServiceRestartAllowed()) {
                        eventContext.reloadRequired();
                    }
                }

                public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                }
            }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
        } else {
            this.resolvedPath = new File(this.path);
        }
    }

    private AtomicLoadKeyStore.LoadKey load(AtomicLoadKeyStore keyStore) throws GeneralSecurityException, IOException {
        try (FileInputStream is = this.resolvedPath != null ? new FileInputStream(this.resolvedPath) : null;){
            AtomicLoadKeyStore.LoadKey loadKey = keyStore.revertibleLoad((InputStream)is, this.password);
            return loadKey;
        }
    }

    public void stop(StopContext stopContext) {
        this.keyStore = null;
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
    }

    public KeyStore getValue() throws IllegalStateException, IllegalArgumentException {
        return this.unmodifiableKeyStore;
    }

    KeyStore getModifiableValue() {
        return this.trackingKeyStore;
    }

    Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }

    Injector<Provider[]> getProvidersInjector() {
        return this.providers;
    }

    long timeSynched() {
        return this.synched;
    }

    LoadKey load() throws OperationFailedException {
        try {
            AtomicLoadKeyStore.LoadKey loadKey = this.load(this.keyStore);
            long originalSynced = this.synched;
            this.synched = System.currentTimeMillis();
            boolean originalModified = this.trackingKeyStore.isModified();
            this.trackingKeyStore.setModified(false);
            return new LoadKey(loadKey, originalSynced, originalModified);
        }
        catch (IOException | GeneralSecurityException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e);
        }
    }

    void revertLoad(LoadKey loadKey) {
        this.keyStore.revert(loadKey.loadKey);
        this.synched = loadKey.modifiedTime;
        this.trackingKeyStore.setModified(loadKey.modified);
    }

    void save() throws OperationFailedException {
        if (this.resolvedPath == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.cantSaveWithoutFile();
        }
        try (FileOutputStream fos = new FileOutputStream(this.resolvedPath);){
            this.keyStore.store((OutputStream)fos, this.password);
            this.synched = System.currentTimeMillis();
            this.trackingKeyStore.setModified(false);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e);
        }
    }

    boolean isModified() {
        return this.trackingKeyStore.isModified();
    }

    class LoadKey {
        private final AtomicLoadKeyStore.LoadKey loadKey;
        private final long modifiedTime;
        private final boolean modified;

        LoadKey(AtomicLoadKeyStore.LoadKey loadKey, long modifiedTime, boolean modified) {
            this.loadKey = loadKey;
            this.modifiedTime = modifiedTime;
            this.modified = modified;
        }
    }
}

