/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Properties;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.SingleCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.provider.ldap.SimpleDirContextFactoryBuilder;
import org.wildfly.security.auth.server.SecurityRealm;

class LdapRealmDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "ldap-realm", SecurityRealm.class);
    private static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{DirContextObjectDefinition.OBJECT_DEFINITION, PrincipalMappingObjectDefinition.OBJECT_DEFINITION};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new SingleCapabilityServiceRemoveHandler<SecurityRealm>(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, SecurityRealm.class);
    private static final OperationStepHandler WRITE = new WriteAttributeHandler();

    LdapRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"ldap-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("ldap-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (SimpleAttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)current, null, WRITE);
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("ldap-realm", (AttributeDefinition[])ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(SecurityRealm.class);
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        public static final String CONNECTION_POOLING_PROPERTY = "com.sun.jndi.ldap.connect.pool";

        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, (AttributeDefinition[])ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            LdapSecurityRealmBuilder builder = LdapSecurityRealmBuilder.builder();
            this.configurePrincipalMapping(context, model, builder);
            this.configureDirContext(context, model, builder);
            TrivialService<SecurityRealm> ldapRealmService = new TrivialService<SecurityRealm>(() -> ((LdapSecurityRealmBuilder)builder).build());
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, ldapRealmService);
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private void configureDirContext(OperationContext context, ModelNode model, LdapSecurityRealmBuilder builder) throws OperationFailedException {
            ModelNode dirContextNode = DirContextObjectDefinition.OBJECT_DEFINITION.resolveModelAttribute(context, model);
            Properties connectionProperties = new Properties();
            ModelNode enableConnectionPoolingNode = DirContextObjectDefinition.ENABLE_CONNECTION_POOLING.resolveModelAttribute(context, dirContextNode);
            connectionProperties.put(CONNECTION_POOLING_PROPERTY, (Object)enableConnectionPoolingNode.asBoolean());
            DirContextFactory dirContextFactory = SimpleDirContextFactoryBuilder.builder().setProviderUrl(DirContextObjectDefinition.URL.resolveModelAttribute(context, dirContextNode).asString()).setSecurityAuthentication(DirContextObjectDefinition.AUTHENTICATION_LEVEL.resolveModelAttribute(context, dirContextNode).asString()).setSecurityPrincipal(DirContextObjectDefinition.PRINCIPAL.resolveModelAttribute(context, dirContextNode).asString()).setSecurityCredential(DirContextObjectDefinition.CREDENTIAL.resolveModelAttribute(context, dirContextNode).asString()).setConnectionProperties(connectionProperties).build();
            builder.setDirContextFactory(dirContextFactory);
        }

        private void configurePrincipalMapping(OperationContext context, ModelNode model, LdapSecurityRealmBuilder builder) throws OperationFailedException {
            ModelNode attributeMappingNode;
            ModelNode useRecursiveSearchNode;
            ModelNode principalMappingNode = PrincipalMappingObjectDefinition.OBJECT_DEFINITION.resolveModelAttribute(context, model);
            LdapSecurityRealmBuilder.PrincipalMappingBuilder principalMappingBuilder = LdapSecurityRealmBuilder.PrincipalMappingBuilder.builder();
            ModelNode nameAttributeNode = PrincipalMappingObjectDefinition.RDN_IDENTIFIER.resolveModelAttribute(context, principalMappingNode);
            principalMappingBuilder.setRdnIdentifier(nameAttributeNode.asString());
            ModelNode searchDnNode = PrincipalMappingObjectDefinition.SEARCH_BASE_DN.resolveModelAttribute(context, principalMappingNode);
            if (searchDnNode.isDefined()) {
                principalMappingBuilder.setSearchDn(searchDnNode.asString());
            }
            if ((useRecursiveSearchNode = PrincipalMappingObjectDefinition.USE_RECURSIVE_SEARCH.resolveModelAttribute(context, principalMappingNode)).asBoolean()) {
                principalMappingBuilder.searchRecursive();
            }
            if ((attributeMappingNode = PrincipalMappingObjectDefinition.ATTRIBUTE_MAPPINGS.resolveModelAttribute(context, principalMappingNode)).isDefined()) {
                for (ModelNode attributeNode : attributeMappingNode.asList()) {
                    ModelNode asRdnNode;
                    ModelNode fromNode = AttributeMappingObjectDefinition.FROM.resolveModelAttribute(context, attributeNode);
                    ModelNode filterNode = AttributeMappingObjectDefinition.FILTER.resolveModelAttribute(context, attributeNode);
                    ModelNode filterBaseDnNode = AttributeMappingObjectDefinition.FILTER_BASE_DN.resolveModelAttribute(context, attributeNode);
                    LdapSecurityRealmBuilder.PrincipalMappingBuilder.Attribute attribute = filterBaseDnNode.isDefined() ? LdapSecurityRealmBuilder.PrincipalMappingBuilder.Attribute.fromFilter((String)filterBaseDnNode.asString(), (String)filterNode.asString(), (String)fromNode.asString()) : (filterNode.isDefined() ? LdapSecurityRealmBuilder.PrincipalMappingBuilder.Attribute.fromFilter((String)filterNode.asString(), (String)fromNode.asString()) : LdapSecurityRealmBuilder.PrincipalMappingBuilder.Attribute.from((String)fromNode.asString()));
                    ModelNode toNode = AttributeMappingObjectDefinition.TO.resolveModelAttribute(context, attributeNode);
                    if (toNode.isDefined()) {
                        attribute.to(toNode.asString());
                    }
                    if ((asRdnNode = AttributeMappingObjectDefinition.AS_RDN.resolveModelAttribute(context, attributeNode)).isDefined()) {
                        attribute.asRdn(asRdnNode.asString());
                    }
                    principalMappingBuilder.map(new LdapSecurityRealmBuilder.PrincipalMappingBuilder.Attribute[]{attribute});
                }
            }
            builder.setPrincipalMapping(principalMappingBuilder.build());
        }
    }

    static class DirContextObjectDefinition {
        static final SimpleAttributeDefinition URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition AUTHENTICATION_LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-level", ModelType.STRING, false).setDefaultValue(new ModelNode("simple"))).setAllowedValues(new String[]{"none", "simple", "strong"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PRINCIPAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition CREDENTIAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("credential", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ENABLE_CONNECTION_POOLING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-connection-pooling", ModelType.BOOLEAN, false).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{URL, AUTHENTICATION_LEVEL, PRINCIPAL, CREDENTIAL, ENABLE_CONNECTION_POOLING};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("dir-context", (AttributeDefinition[])ATTRIBUTES).setAllowNull(false).build();

        DirContextObjectDefinition() {
        }
    }

    static class PrincipalMappingObjectDefinition {
        static final SimpleAttributeDefinition RDN_IDENTIFIER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rdn-identifier", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition USE_RECURSIVE_SEARCH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-recursive-search", ModelType.BOOLEAN, false).setRequires(new String[]{"search-base-dn"})).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SEARCH_BASE_DN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-base-dn", ModelType.STRING, true).setRequires(new String[]{"rdn-identifier"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectListAttributeDefinition ATTRIBUTE_MAPPINGS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("attribute-mapping", AttributeMappingObjectDefinition.OBJECT_DEFINITION).setAllowNull(true).setAttributeGroup("attribute")).setAllowDuplicates(true)).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RDN_IDENTIFIER, USE_RECURSIVE_SEARCH, SEARCH_BASE_DN, ATTRIBUTE_MAPPINGS};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("principal-mapping", ATTRIBUTES).setAllowNull(false).build();

        PrincipalMappingObjectDefinition() {
        }
    }

    static class AttributeMappingObjectDefinition {
        static final SimpleAttributeDefinition FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("from", ModelType.STRING, false).setAlternatives(new String[]{"filter"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("to", ModelType.STRING, true).setRequires(new String[]{"from"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter", ModelType.STRING, true).setRequires(new String[]{"to"})).setAlternatives(new String[]{"from"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition FILTER_BASE_DN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-base-dn", ModelType.STRING, true).setRequires(new String[]{"filter"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition AS_RDN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("as-rdn", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{FROM, TO, FILTER, FILTER_BASE_DN, AS_RDN};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("attribute", (AttributeDefinition[])ATTRIBUTES).setAllowNull(true).build();

        AttributeMappingObjectDefinition() {
        }
    }
}

