/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.PropertiesRealmService;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.SingleCapabilityServiceRemoveHandler;
import org.wildfly.security.auth.server.SecurityRealm;

public class PropertiesRealmDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "properties-realm", SecurityRealm.class);
    static final ObjectTypeAttributeDefinition USERS_PROPERTIES = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("users-properties", new AttributeDefinition[]{FileAttributeDefinitions.PATH, FileAttributeDefinitions.RELATIVE_TO}).setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final ObjectTypeAttributeDefinition GROUPS_PROPERTIES = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("groups-properties", new AttributeDefinition[]{FileAttributeDefinitions.PATH, FileAttributeDefinitions.RELATIVE_TO}).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PLAIN_TEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("plain-text", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{USERS_PROPERTIES, GROUPS_PROPERTIES, PLAIN_TEXT};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new SingleCapabilityServiceRemoveHandler<SecurityRealm>(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, SecurityRealm.class);

    PropertiesRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"properties-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("properties-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler write = new WriteAttributeHandler();
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("properties-realm", ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(SecurityRealm.class);
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String groupsRelativeTo;
            String groupsPath;
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            boolean plainText = PLAIN_TEXT.resolveModelAttribute(context, model).asBoolean();
            ModelNode usersProperties = USERS_PROPERTIES.resolveModelAttribute(context, model);
            String usersPath = ElytronExtension.asStringIfDefined(context, FileAttributeDefinitions.PATH, usersProperties);
            String usersRelativeTo = ElytronExtension.asStringIfDefined(context, FileAttributeDefinitions.RELATIVE_TO, usersProperties);
            ModelNode groupsProperties = GROUPS_PROPERTIES.resolveModelAttribute(context, model);
            if (groupsProperties.isDefined()) {
                groupsPath = ElytronExtension.asStringIfDefined(context, FileAttributeDefinitions.PATH, groupsProperties);
                groupsRelativeTo = ElytronExtension.asStringIfDefined(context, FileAttributeDefinitions.RELATIVE_TO, groupsProperties);
            } else {
                groupsPath = null;
                groupsRelativeTo = null;
            }
            PropertiesRealmService propertiesRealmService = new PropertiesRealmService(usersPath, usersRelativeTo, groupsPath, groupsRelativeTo, plainText);
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, (Service)propertiesRealmService);
            if (usersRelativeTo != null || groupsRelativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, propertiesRealmService.getPathManagerInjector());
                if (usersRelativeTo != null) {
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(usersRelativeTo));
                }
                if (groupsRelativeTo != null) {
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(groupsRelativeTo));
                }
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

