/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.function.Predicate;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron.ProviderUtil;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.AtomicLoadKeyStore;
import org.wildfly.security.keystore.FilteringKeyStore;
import org.wildfly.security.keystore.ModifyTrackingKeyStore;
import org.wildfly.security.keystore.UnmodifiableKeyStore;
import org.wildfly.security.password.interfaces.ClearPassword;

class KeyStoreService
implements ModifiableKeyStoreService {
    private final String provider;
    private final String type;
    private final String path;
    private final String relativeTo;
    private final boolean required;
    private final String aliasFilter;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final InjectedValue<Provider[]> providers = new InjectedValue();
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> credentialSourceSupplier = new InjectedValue();
    private FileAttributeDefinitions.PathResolver pathResolver;
    private File resolvedPath;
    private volatile long synched;
    private volatile AtomicLoadKeyStore keyStore = null;
    private volatile ModifyTrackingKeyStore trackingKeyStore = null;
    private volatile KeyStore unmodifiableKeyStore = null;

    private KeyStoreService(String provider, String type, String relativeTo, String path, boolean required, String aliasFilter) {
        this.provider = provider;
        this.type = type;
        this.relativeTo = relativeTo;
        this.path = path;
        this.required = required;
        this.aliasFilter = aliasFilter;
    }

    static KeyStoreService createFileLessKeyStoreService(String provider, String type, String aliasFilter) {
        return new KeyStoreService(provider, type, null, null, false, aliasFilter);
    }

    static KeyStoreService createFileBasedKeyStoreService(String provider, String type, String relativeTo, String path, boolean required, String aliasFilter) {
        return new KeyStoreService(provider, type, relativeTo, path, required, aliasFilter);
    }

    public void start(StartContext startContext) throws StartException {
        try {
            Provider provider = this.resolveProvider();
            AtomicLoadKeyStore keyStore = AtomicLoadKeyStore.newInstance((String)this.type, (Provider)provider);
            if (this.path != null) {
                this.pathResolver = FileAttributeDefinitions.pathResolver();
                this.pathResolver.path(this.path);
                if (this.relativeTo != null) {
                    this.pathResolver.relativeTo(this.relativeTo, (PathManager)this.pathManager.getValue());
                }
                this.resolvedPath = this.pathResolver.resolve();
            }
            this.synched = System.currentTimeMillis();
            if (this.resolvedPath != null && !this.resolvedPath.exists()) {
                if (this.required) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.keyStoreFileNotExists(this.resolvedPath.getAbsolutePath());
                }
                ElytronSubsystemMessages.ROOT_LOGGER.keyStoreFileNotExistsButIgnored(this.resolvedPath.getAbsolutePath());
                this.resolvedPath = null;
            }
            try (FileInputStream is = this.resolvedPath != null ? new FileInputStream(this.resolvedPath) : null;){
                char[] password = this.resolvePassword();
                ElytronSubsystemMessages.ROOT_LOGGER.tracef("starting:  type = %s  provider = %s  path = %s  resolvedPath = %s  password = %b  aliasFilter = %s", new Object[]{this.type, provider, this.path, this.resolvedPath, password != null, this.aliasFilter});
                keyStore.load((InputStream)is, password);
                this.checkCertificatesValidity((KeyStore)keyStore);
            }
            this.keyStore = keyStore;
            AtomicLoadKeyStore intermediate = this.aliasFilter != null ? FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)this.aliasFilter)) : keyStore;
            this.trackingKeyStore = ModifyTrackingKeyStore.modifyTrackingKeyStore((KeyStore)intermediate);
            this.unmodifiableKeyStore = UnmodifiableKeyStore.unmodifiableKeyStore((KeyStore)intermediate);
        }
        catch (Exception e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    private Provider resolveProvider() throws StartException {
        Provider[] candidates = (Provider[])this.providers.getOptionalValue();
        Provider identified = ProviderUtil.identifyProvider(candidates == null ? Security.getProviders() : candidates, this.provider, KeyStore.class, this.type);
        if (identified == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.noSuitableProvider(this.type);
        }
        return identified;
    }

    private AtomicLoadKeyStore.LoadKey load(AtomicLoadKeyStore keyStore) throws Exception {
        try (FileInputStream is = this.resolvedPath != null ? new FileInputStream(this.resolvedPath) : null;){
            AtomicLoadKeyStore.LoadKey loadKey = keyStore.revertibleLoad((InputStream)is, this.resolvePassword());
            this.checkCertificatesValidity((KeyStore)keyStore);
            AtomicLoadKeyStore.LoadKey loadKey2 = loadKey;
            return loadKey2;
        }
    }

    private void checkCertificatesValidity(KeyStore keyStore) throws KeyStoreException {
        if (ElytronSubsystemMessages.ROOT_LOGGER.isEnabled(Logger.Level.WARN)) {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = keyStore.getCertificate(alias);
                if (certificate == null || !(certificate instanceof X509Certificate)) continue;
                try {
                    ((X509Certificate)certificate).checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    ElytronSubsystemMessages.ROOT_LOGGER.certificateNotValid(alias, e);
                }
            }
        }
    }

    public void stop(StopContext stopContext) {
        ElytronSubsystemMessages.ROOT_LOGGER.tracef("stopping:  keyStore = %s  unmodifiableKeyStore = %s  trackingKeyStore = %s  pathResolver = %s", new Object[]{this.keyStore, this.unmodifiableKeyStore, this.trackingKeyStore, this.pathResolver});
        this.keyStore = null;
        this.unmodifiableKeyStore = null;
        this.trackingKeyStore = null;
        if (this.pathResolver != null) {
            this.pathResolver.clear();
            this.pathResolver = null;
        }
    }

    public KeyStore getValue() throws IllegalStateException, IllegalArgumentException {
        return this.unmodifiableKeyStore;
    }

    @Override
    public KeyStore getModifiableValue() {
        return this.trackingKeyStore;
    }

    Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }

    Injector<Provider[]> getProvidersInjector() {
        return this.providers;
    }

    Injector<ExceptionSupplier<CredentialSource, Exception>> getCredentialSourceSupplierInjector() {
        return this.credentialSourceSupplier;
    }

    long timeSynched() {
        return this.synched;
    }

    LoadKey load() throws OperationFailedException {
        try {
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("reloading KeyStore from file [%s]", this.resolvedPath);
            AtomicLoadKeyStore.LoadKey loadKey = this.load(this.keyStore);
            long originalSynced = this.synched;
            this.synched = System.currentTimeMillis();
            boolean originalModified = this.trackingKeyStore.isModified();
            this.trackingKeyStore.setModified(false);
            return new LoadKey(loadKey, originalSynced, originalModified);
        }
        catch (Exception e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, e.getLocalizedMessage());
        }
    }

    void revertLoad(LoadKey loadKey) {
        ElytronSubsystemMessages.ROOT_LOGGER.trace("reverting load of KeyStore");
        this.keyStore.revert(loadKey.loadKey);
        this.synched = loadKey.modifiedTime;
        this.trackingKeyStore.setModified(loadKey.modified);
    }

    void save() throws OperationFailedException {
        if (this.resolvedPath == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.cantSaveWithoutFile();
        }
        ElytronSubsystemMessages.ROOT_LOGGER.tracef("saving KeyStore to the file [%s]", this.resolvedPath);
        try (FileOutputStream fos = new FileOutputStream(this.resolvedPath);){
            this.keyStore.store((OutputStream)fos, this.resolvePassword());
            this.synched = System.currentTimeMillis();
            this.trackingKeyStore.setModified(false);
        }
        catch (Exception e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, e.getLocalizedMessage());
        }
    }

    boolean isModified() {
        return this.trackingKeyStore.isModified();
    }

    private char[] resolvePassword() throws Exception {
        CredentialSource cs;
        ExceptionSupplier sourceSupplier = (ExceptionSupplier)this.credentialSourceSupplier.getValue();
        CredentialSource credentialSource = cs = sourceSupplier != null ? (CredentialSource)sourceSupplier.get() : null;
        if (cs != null) {
            return ((ClearPassword)((PasswordCredential)cs.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword();
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.keyStorePasswordCannotBeResolved(this.resolvedPath.getPath());
    }

    static class LoadKey {
        private final AtomicLoadKeyStore.LoadKey loadKey;
        private final long modifiedTime;
        private final boolean modified;

        LoadKey(AtomicLoadKeyStore.LoadKey loadKey, long modifiedTime, boolean modified) {
            this.loadKey = loadKey;
            this.modifiedTime = modifiedTime;
            this.modified = modified;
        }
    }
}

