/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SingleCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.x500.X500AttributePrincipalDecoder;

class PrincipalDecoderDefinitions {
    static final SimpleAttributeDefinition OID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("oid", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition JOINER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("joiner", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setDefaultValue(new ModelNode("."))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MAXIMUM_SEGMENTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-segments", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Integer.MAX_VALUE))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static final AggregateComponentDefinition<PrincipalDecoder> AGGREGATE_PRINCIPAL_DECODER = AggregateComponentDefinition.create(PrincipalDecoder.class, "aggregate-principal-decoder", "principal-decoders", Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY, PrincipalDecoder::aggregate);

    PrincipalDecoderDefinitions() {
    }

    static AggregateComponentDefinition<PrincipalDecoder> getAggregatePrincipalDecoderDefinition() {
        return AGGREGATE_PRINCIPAL_DECODER;
    }

    static ResourceDefinition getX500AttributePrincipalDecoder() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{OID, JOINER, MAXIMUM_SEGMENTS};
        PrincipalDecoderAddHander add = new PrincipalDecoderAddHander(attributes){

            @Override
            protected TrivialService.ValueSupplier<PrincipalDecoder> getValueSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
                String oid = OID.resolveModelAttribute(context, model).asString();
                String joiner = JOINER.resolveModelAttribute(context, model).asString();
                int maximumSegments = MAXIMUM_SEGMENTS.resolveModelAttribute(context, model).asInt();
                return () -> new X500AttributePrincipalDecoder(oid, joiner, maximumSegments);
            }
        };
        return new PrincipalDecoderResourceDefinition("x500-attribute-principal-decoder", add, attributes);
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler(String parentName, AttributeDefinition ... attributes) {
            super(parentName, attributes);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(PrincipalDecoder.class);
        }
    }

    private static class PrincipalDecoderAddHander
    extends BaseAddHandler {
        private PrincipalDecoderAddHander(AttributeDefinition ... attributes) {
            super(Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY, attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            RuntimeCapability runtimeCapability = Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName roleMapperName = runtimeCapability.getCapabilityServiceName(PrincipalDecoder.class);
            ElytronDefinition.commonDependencies(this.installService(context, roleMapperName, model)).setInitialMode(ServiceController.Mode.LAZY).install();
        }

        protected ServiceBuilder<PrincipalDecoder> installService(OperationContext context, ServiceName principalDecoderName, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            TrivialService<PrincipalDecoder> roleMapperService = new TrivialService<PrincipalDecoder>(this.getValueSupplier(context, model));
            return serviceTarget.addService(principalDecoderName, roleMapperService);
        }

        protected TrivialService.ValueSupplier<PrincipalDecoder> getValueSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
            return () -> null;
        }
    }

    private static class PrincipalDecoderResourceDefinition
    extends SimpleResourceDefinition {
        private final String pathKey;
        private final AttributeDefinition[] attributes;

        PrincipalDecoderResourceDefinition(String pathKey, AbstractAddStepHandler add, AttributeDefinition ... attributes) {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddHandler((OperationStepHandler)add).setRemoveHandler(new SingleCapabilityServiceRemoveHandler<PrincipalDecoder>(add, Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY, PrincipalDecoder.class)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
            this.pathKey = pathKey;
            this.attributes = attributes;
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            if (this.attributes != null && this.attributes.length > 0) {
                WriteAttributeHandler write = new WriteAttributeHandler(this.pathKey, this.attributes);
                for (AttributeDefinition current : this.attributes) {
                    resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
                }
            }
        }

        public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
            resourceRegistration.registerCapability(Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY);
        }
    }
}

