/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.AggregateComponentService;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SingleCapabilityServiceRemoveHandler;

class AggregateComponentDefinition<T>
extends SimpleResourceDefinition {
    private final ListAttributeDefinition aggregateReferences;
    private final OperationStepHandler attributeWriteHandler;
    private final RuntimeCapability<?> runtimeCapability;

    private AggregateComponentDefinition(Class<T> classType, String pathKey, OperationStepHandler addHandler, OperationStepHandler removeHandler, ListAttributeDefinition aggregateReferences, OperationStepHandler attributeWriteHandler, RuntimeCapability<?> runtimeCapability) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddHandler(addHandler).setRemoveHandler(removeHandler).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
        this.aggregateReferences = aggregateReferences;
        this.attributeWriteHandler = attributeWriteHandler;
        this.runtimeCapability = runtimeCapability;
    }

    ListAttributeDefinition getReferencesAttribute() {
        return this.aggregateReferences;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)this.aggregateReferences, null, this.attributeWriteHandler);
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(this.runtimeCapability);
    }

    static <T> AggregateComponentDefinition<T> create(Class<T> aggregationType, String componentName, String referencesName, RuntimeCapability<?> runtimeCapability, Function<T[], T> aggregator) {
        String capabilityName = runtimeCapability.getName();
        StringListAttributeDefinition aggregateReferences = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(referencesName).setMinSize(2)).setAllowExpression(true)).setAllowNull(false)).setCapabilityReference(capabilityName, capabilityName, true)).build();
        AggregateComponentAddHandler add = new AggregateComponentAddHandler(aggregationType, aggregator, aggregateReferences, runtimeCapability);
        SingleCapabilityServiceRemoveHandler<T> remove = new SingleCapabilityServiceRemoveHandler<T>(add, runtimeCapability, aggregationType);
        WriteAttributeHandler<T> write = new WriteAttributeHandler<T>(aggregationType, runtimeCapability, componentName, (AttributeDefinition)aggregateReferences);
        return new AggregateComponentDefinition<T>(aggregationType, componentName, (OperationStepHandler)add, (OperationStepHandler)remove, (ListAttributeDefinition)aggregateReferences, (OperationStepHandler)write, runtimeCapability);
    }

    private static class WriteAttributeHandler<T>
    extends RestartParentWriteAttributeHandler {
        private final Class<T> serviceType;
        private final RuntimeCapability<?> runtimeCapability;

        WriteAttributeHandler(Class<T> serviceType, RuntimeCapability<?> runtimeCapability, String pathKey, AttributeDefinition attribute) {
            super(pathKey, new AttributeDefinition[]{attribute});
            this.serviceType = serviceType;
            this.runtimeCapability = runtimeCapability;
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return this.runtimeCapability.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(this.serviceType);
        }
    }

    private static class AggregateComponentAddHandler<T>
    extends BaseAddHandler {
        private final Class<T> aggregationType;
        private final Function<T[], T> aggregator;
        private final StringListAttributeDefinition aggregateReferences;
        private final RuntimeCapability<?> runtimeCapability;

        private AggregateComponentAddHandler(Class<T> aggregationType, Function<T[], T> aggregator, StringListAttributeDefinition aggregateReferences, RuntimeCapability<?> runtimeCapability) {
            super(runtimeCapability, new AttributeDefinition[]{aggregateReferences});
            this.aggregationType = aggregationType;
            this.aggregator = aggregator;
            this.aggregateReferences = aggregateReferences;
            this.runtimeCapability = runtimeCapability;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability instanceRuntimeCapability = this.runtimeCapability.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName componentName = instanceRuntimeCapability.getCapabilityServiceName(this.aggregationType);
            AggregateComponentService<T> aggregateComponentService = new AggregateComponentService<T>(this.aggregationType, this.aggregator);
            ServiceBuilder serviceBuilder = serviceTarget.addService(componentName, aggregateComponentService);
            List aggregates = this.aggregateReferences.unwrap((ExpressionResolver)context, model);
            String baseCapabilityName = this.runtimeCapability.getName();
            for (String current : aggregates) {
                String runtimeCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)baseCapabilityName, (String)current);
                ServiceName realmServiceName = context.getCapabilityServiceName(runtimeCapabilityName, this.aggregationType);
                serviceBuilder.addDependency(realmServiceName, this.aggregationType, aggregateComponentService.newInjector());
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }
}

