/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

class FileAttributeDefinitions {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setAttributeGroup("file")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setAttributeGroup("file")).setRequires(new String[]{"path"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

    FileAttributeDefinitions() {
    }

    static ServiceName pathName(String relativeTo) {
        return ServiceName.JBOSS.append(new String[]{"server", "path", relativeTo});
    }

    static PathResolver pathResolver() {
        return new PathResolver();
    }

    static class PathResolver {
        private String path;
        private String relativeTo;
        private PathManager pathManager;
        private PathManager.Callback.Handle callbackHandle;

        PathResolver() {
        }

        PathResolver path(String path) {
            this.path = path;
            return this;
        }

        PathResolver relativeTo(String relativeTo, PathManager pathManager) {
            this.relativeTo = relativeTo;
            this.pathManager = pathManager;
            return this;
        }

        File resolve() {
            if (this.relativeTo != null) {
                File resolvedPath = new File(this.pathManager.resolveRelativePathEntry(this.path, this.relativeTo));
                this.callbackHandle = this.pathManager.registerCallback(this.relativeTo, new PathManager.Callback(){

                    public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                        if (!eventContext.isResourceServiceRestartAllowed()) {
                            eventContext.reloadRequired();
                        }
                    }

                    public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                    }
                }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
                return resolvedPath;
            }
            return new File(this.path);
        }

        void clear() {
            if (this.callbackHandle != null) {
                this.callbackHandle.remove();
                this.callbackHandle = null;
            }
        }
    }
}

