/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.BCryptPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

class IdentityResourceDefinition
extends SimpleResourceDefinition {
    private static final OperationStepHandler ADD = new IdentityAddHandler();
    private static final OperationStepHandler REMOVE = new IdentityRemoveHandler();

    IdentityResourceDefinition(ResourceDefinition parentResource) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"identity"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(parentResource.getPathElement().getKey(), "identity")).setAddHandler(ADD).setRemoveHandler(REMOVE));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ReadIdentityHandler.register(resourceRegistration, this.getResourceDescriptionResolver());
        this.registerAttributeOperations(resourceRegistration);
        this.registerCredentialOperations(resourceRegistration);
    }

    private void registerCredentialOperations(ManagementResourceRegistration resourceRegistration) {
        PasswordSetHandler.register(resourceRegistration, this.getResourceDescriptionResolver());
    }

    private void registerAttributeOperations(ManagementResourceRegistration resourceRegistration) {
        AttributeAddHandler.register(resourceRegistration, this.getResourceDescriptionResolver());
        AttributeRemoveHandler.register(resourceRegistration, this.getResourceDescriptionResolver());
    }

    private static ModifiableSecurityRealm getModifiableSecurityRealm(OperationContext context) throws OperationFailedException {
        PathAddress currentAddress;
        RuntimeCapability runtimeCapability;
        ServiceName realmName;
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController<SecurityRealm> serviceController = ElytronExtension.getRequiredService(serviceRegistry, realmName = (runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability((currentAddress = context.getCurrentAddress()).subAddress(0, currentAddress.size() - 1).getLastElement().getValue())).getCapabilityServiceName(SecurityRealm.class), SecurityRealm.class);
        SecurityRealm realm = (SecurityRealm)serviceController.getValue();
        if (!ModifiableSecurityRealm.class.isInstance(realm)) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.realmNotModifiable(realmName);
        }
        return (ModifiableSecurityRealm)realm;
    }

    private static ModifiableRealmIdentity getRealmIdentity(OperationContext context) throws OperationFailedException {
        ModifiableSecurityRealm modifiableRealm = IdentityResourceDefinition.getModifiableSecurityRealm(context);
        PathAddress currentAddress = context.getCurrentAddress();
        String principalName = currentAddress.getLastElement().getValue();
        try {
            ModifiableRealmIdentity realmIdentity = modifiableRealm.getRealmIdentityForUpdate(principalName, null, null);
            if (!realmIdentity.exists()) {
                throw new OperationFailedException(ElytronSubsystemMessages.ROOT_LOGGER.identityNotFound(principalName));
            }
            return realmIdentity;
        }
        catch (RealmUnavailableException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotReadIdentity(principalName, (Exception)((Object)e));
        }
    }

    private static List<Object> getCredentials(ModifiableRealmIdentity realmIdentity) throws RealmUnavailableException {
        ArrayList<Object> credentials = new ArrayList<Object>();
        return credentials;
    }

    private static void addPassword(RealmIdentity realmIdentity, Class<? extends Password> credentialType, List<Object> credentials) throws RealmUnavailableException {
    }

    static class AuthenticatorOperationHandler
    implements OperationStepHandler {
        private static final ServiceUtil<SecurityDomain> DOMAIN_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY, "security-domain", SecurityDomain.class);
        private static final String OPERATION_NAME = "authenticate";
        private static final String PARAMETER_USERNAME = "username";
        private static final String PARAMETER_PASSWORD = "password";
        public static final SimpleAttributeDefinition USER_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("username", ModelType.STRING, false).setAllowExpression(false)).build();
        public static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).setAllowExpression(false)).build();

        static String getOperationName() {
            return OPERATION_NAME;
        }

        static AttributeDefinition[] getParameterDefinitions() {
            return new AttributeDefinition[]{USER_NAME, PASSWORD};
        }

        public static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver resolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition(AuthenticatorOperationHandler.getOperationName(), resolver, AuthenticatorOperationHandler.getParameterDefinitions()), (OperationStepHandler)new AuthenticatorOperationHandler());
        }

        AuthenticatorOperationHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep((contextStep, operationStep) -> {
                String principalName = USER_NAME.resolveModelAttribute(context, operation).asString();
                String password = PASSWORD.resolveModelAttribute(context, operation).asString();
                SecurityDomain securityDomain = this.getSecurityDomain(context, operation);
                try {
                    ServerAuthenticationContext authenticationContext = securityDomain.createNewAuthenticationContext();
                    authenticationContext.setAuthenticationName(principalName);
                    if (!authenticationContext.exists()) {
                        this.addFailureDescription("Principal [" + principalName + "] does not exist.", context);
                        return;
                    }
                    if (authenticationContext.verifyEvidence((Evidence)new PasswordGuessEvidence(password.toCharArray()))) {
                        authenticationContext.succeed();
                        SecurityIdentity authorizedIdentity = authenticationContext.getAuthorizedIdentity();
                        if (authorizedIdentity == null) {
                            this.addFailureDescription("Principal [" + principalName + "] authenticated but no identity could be obtained.", context);
                            return;
                        }
                        context.getResult().add("Principal [" + principalName + "] successfully authenticated.");
                        context.getResult().add("Roles are " + authorizedIdentity.getRoles() + ".");
                        context.getResult().add("Permissions are [" + authorizedIdentity.getPermissions() + "].");
                    } else {
                        authenticationContext.fail();
                        this.addFailureDescription("Invalid credentials for Principal [" + principalName + "].", context);
                    }
                }
                catch (Exception cause) {
                    this.addFailureDescription(cause.getMessage(), context);
                    ElytronSubsystemMessages.ROOT_LOGGER.error(cause);
                }
                finally {
                    context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }

        private void addFailureDescription(String message, OperationContext context) {
            ModelNode failureDescription = context.getFailureDescription();
            failureDescription.add(message);
        }

        private SecurityDomain getSecurityDomain(OperationContext context, ModelNode operation) {
            ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
            ServiceController<SecurityDomain> serviceController = ElytronExtension.getRequiredService(serviceRegistry, DOMAIN_SERVICE_UTIL.serviceName(operation), SecurityDomain.class);
            Service service = serviceController.getService();
            return (SecurityDomain)service.getValue();
        }
    }

    static class StringValuesValidator
    extends ModelTypeValidator
    implements AllowedValuesValidator {
        private List<ModelNode> allowedValues = new ArrayList<ModelNode>();

        public StringValuesValidator(String ... values) {
            super(ModelType.STRING);
            for (String value : values) {
                this.allowedValues.add(new ModelNode().set(value));
            }
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined() && !this.allowedValues.contains(value)) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidValue(value.asString(), parameterName, this.allowedValues));
            }
        }

        public List<ModelNode> getAllowedValues() {
            return this.allowedValues;
        }
    }

    static class PasswordSetHandler
    implements OperationStepHandler {
        PasswordSetHandler() {
        }

        public static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver resourceDescriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition("set-password", resourceDescriptionResolver, new AttributeDefinition[]{Bcrypt.OBJECT_DEFINITION, Clear.OBJECT_DEFINITION, SimpleDigest.OBJECT_DEFINITION, SaltedSimpleDigest.OBJECT_DEFINITION, Digest.OBJECT_DEFINITION}), (OperationStepHandler)new PasswordSetHandler());
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(operation, (parentContext, parentOperation) -> {
                ModifiableRealmIdentity realmIdentity = IdentityResourceDefinition.getRealmIdentity(context);
                List modelNodes = parentOperation.asList();
                Property passwordProperty = ((ModelNode)modelNodes.get(2)).asProperty();
                PathAddress currentAddress = parentContext.getCurrentAddress();
                String principalName = currentAddress.getLastElement().getValue();
                try {
                    realmIdentity.setCredentials(Collections.singleton(new PasswordCredential(this.createPassword(parentContext, principalName, passwordProperty))));
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException | RealmUnavailableException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotCreatePassword((Exception)e);
                }
                parentContext.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
            }, OperationContext.Stage.RUNTIME);
        }

        private Password createPassword(OperationContext parentContext, String principalName, Property passwordProperty) throws OperationFailedException, NoSuchAlgorithmException, InvalidKeySpecException {
            String algorithm;
            ClearPasswordSpec passwordSpec;
            String passwordType = passwordProperty.getName();
            ModelNode passwordNode = passwordProperty.getValue();
            String password = Bcrypt.PASSWORD.resolveModelAttribute(parentContext, passwordNode).asString();
            if (passwordType.equals("bcrypt")) {
                byte[] salt = Bcrypt.SALT.resolveModelAttribute(parentContext, passwordNode).asBytes();
                int iterationCount = Bcrypt.ITERATION_COUNT.resolveModelAttribute(parentContext, passwordNode).asInt();
                passwordSpec = new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(iterationCount, salt));
                algorithm = Bcrypt.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
            } else if (passwordType.equals("clear")) {
                passwordSpec = new ClearPasswordSpec(password.toCharArray());
                algorithm = Clear.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
            } else if (passwordType.equals("simple-digest")) {
                passwordSpec = new EncryptablePasswordSpec(password.toCharArray(), null);
                algorithm = SimpleDigest.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
            } else if (passwordType.equals("salted-simple-digest")) {
                byte[] salt = SaltedSimpleDigest.SALT.resolveModelAttribute(parentContext, passwordNode).asBytes();
                SaltedPasswordAlgorithmSpec spac = new SaltedPasswordAlgorithmSpec(salt);
                passwordSpec = new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)spac);
                algorithm = SaltedSimpleDigest.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
            } else if (passwordType.equals("digest")) {
                String realm = Digest.REALM.resolveModelAttribute(parentContext, passwordNode).asString();
                algorithm = Digest.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
                DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec(principalName, realm);
                passwordSpec = new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)dpas);
            } else {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unexpectedPasswordType(passwordType);
            }
            return PasswordFactory.getInstance((String)algorithm).generatePassword((KeySpec)passwordSpec);
        }

        static class Digest {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("digest-sha-512"))).setValidator((ParameterValidator)new StringValuesValidator("digest-md5", "digest-sha", "digest-sha-256", "digest-sha-512"))).setAllowExpression(false)).build();
            static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).setAllowExpression(false)).build();
            static final SimpleAttributeDefinition REALM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, false).setAllowExpression(false)).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("digest", new AttributeDefinition[]{ALGORITHM, PASSWORD, REALM}).setAllowNull(true).build();

            Digest() {
            }
        }

        static class SaltedSimpleDigest {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("password-salt-digest-sha-512"))).setValidator((ParameterValidator)new StringValuesValidator("password-salt-digest-md5", "password-salt-digest-sha-1", "password-salt-digest-sha-256", "password-salt-digest-sha-384", "password-salt-digest-sha-512", "salt-password-digest-md5", "salt-password-digest-sha-1", "salt-password-digest-sha-256", "salt-password-digest-sha-384", "salt-password-digest-sha-512"))).setAllowExpression(false)).build();
            static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).setAllowExpression(false)).build();
            static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt", ModelType.BYTES, false).setAllowExpression(false)).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("salted-simple-digest", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT}).setAllowNull(true).build();

            SaltedSimpleDigest() {
            }
        }

        static class SimpleDigest {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("simple-digest-sha-512"))).setValidator((ParameterValidator)new StringValuesValidator("simple-digest-md2", "simple-digest-md5", "simple-digest-sha-1", "simple-digest-sha-256", "simple-digest-sha-384", "simple-digest-sha-512"))).setAllowExpression(false)).build();
            static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).setMinSize(1)).setAllowExpression(false)).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("simple-digest", new AttributeDefinition[]{ALGORITHM, PASSWORD}).setAllowNull(true).build();

            SimpleDigest() {
            }
        }

        static class Clear {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("clear"))).setValidator((ParameterValidator)new StringValuesValidator("clear"))).setAllowExpression(false)).build();
            static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).setMinSize(1)).setAllowExpression(false)).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("clear", new AttributeDefinition[]{PASSWORD}).setAllowNull(true).build();

            Clear() {
            }
        }

        static class Bcrypt {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("bcrypt"))).setValidator((ParameterValidator)new StringValuesValidator("bcrypt"))).setAllowExpression(false)).build();
            static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).setMinSize(1)).setAllowExpression(false)).build();
            static final SimpleAttributeDefinition ITERATION_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("iteration-count", ModelType.INT, false).setAllowExpression(false)).build();
            static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt", ModelType.BYTES, false).setAllowExpression(false)).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("bcrypt", new AttributeDefinition[]{PASSWORD, SALT, ITERATION_COUNT}).setAllowNull(true).build();

            Bcrypt() {
            }
        }
    }

    static class AttributeRemoveHandler
    implements OperationStepHandler {
        public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setAllowExpression(false)).build();
        static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, false).setAllowExpression(false)).build();
        static final SimpleListAttributeDefinition VALUES = ((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("value", (AttributeDefinition)VALUE).setAllowNull(true).setMinSize(0).setAllowExpression(false)).build();

        AttributeRemoveHandler() {
        }

        public static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver resourceDescriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition("remove-attribute", resourceDescriptionResolver, new AttributeDefinition[]{NAME, VALUES}), (OperationStepHandler)new AttributeRemoveHandler());
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(operation, (parentContext, parentOperation) -> {
                AuthorizationIdentity authorizationIdentity;
                ModifiableRealmIdentity realmIdentity = IdentityResourceDefinition.getRealmIdentity(context);
                try {
                    authorizationIdentity = realmIdentity.getAuthorizationIdentity();
                }
                catch (RealmUnavailableException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotObtainAuthorizationIdentity((Exception)((Object)e));
                }
                try {
                    MapAttributes attributes = new MapAttributes(authorizationIdentity.getAttributes());
                    String name = NAME.resolveModelAttribute(context, operation).asString();
                    ModelNode valuesNode = VALUES.resolveModelAttribute(parentContext, parentOperation);
                    if (valuesNode.isDefined()) {
                        for (ModelNode valueNode : valuesNode.asList()) {
                            attributes.removeAll(name, valueNode.asString());
                        }
                    } else {
                        attributes.remove(name);
                    }
                    realmIdentity.setAttributes((Attributes)attributes);
                }
                catch (RealmUnavailableException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotRemoveAttribute((Exception)((Object)e));
                }
                parentContext.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static class AttributeAddHandler
    implements OperationStepHandler {
        public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setAllowExpression(false)).build();
        static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, false).setAllowExpression(false)).build();
        static final SimpleListAttributeDefinition VALUES = ((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("value", (AttributeDefinition)VALUE).setMinSize(1).setAllowExpression(false)).build();

        AttributeAddHandler() {
        }

        public static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver resourceDescriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition("add-attribute", resourceDescriptionResolver, new AttributeDefinition[]{NAME, VALUES}), (OperationStepHandler)new AttributeAddHandler());
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(operation, (parentContext, parentOperation) -> {
                AuthorizationIdentity authorizationIdentity;
                ModifiableRealmIdentity realmIdentity = IdentityResourceDefinition.getRealmIdentity(context);
                try {
                    authorizationIdentity = realmIdentity.getAuthorizationIdentity();
                }
                catch (RealmUnavailableException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotObtainAuthorizationIdentity((Exception)((Object)e));
                }
                try {
                    MapAttributes attributes = new MapAttributes(authorizationIdentity.getAttributes());
                    String name = NAME.resolveModelAttribute(context, operation).asString();
                    VALUES.resolveModelAttribute(parentContext, parentOperation).asList().forEach(arg_0 -> AttributeAddHandler.lambda$null$54((Attributes)attributes, name, arg_0));
                    realmIdentity.setAttributes((Attributes)attributes);
                }
                catch (RealmUnavailableException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotAddAttribute((Exception)((Object)e));
                }
                parentContext.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
            }, OperationContext.Stage.RUNTIME);
        }

        private static /* synthetic */ void lambda$null$54(Attributes attributes, String name, ModelNode modelNode) {
            attributes.addLast(name, modelNode.asString());
        }
    }

    static class ReadIdentityHandler
    implements OperationStepHandler {
        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition("read-identity", descriptionResolver), (OperationStepHandler)new ReadIdentityHandler());
        }

        private ReadIdentityHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(operation, (parentContext, parentOperation) -> {
                String principalName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
                ModifiableRealmIdentity realmIdentity = IdentityResourceDefinition.getRealmIdentity(context);
                try {
                    if (!realmIdentity.exists()) {
                        parentContext.getFailureDescription().add(ElytronSubsystemMessages.ROOT_LOGGER.identityNotFound(principalName));
                        return;
                    }
                    AuthorizationIdentity identity = realmIdentity.getAuthorizationIdentity();
                    ModelNode result = parentContext.getResult();
                    result.get("name").set(principalName);
                    ModelNode attributesNode = result.get("attributes");
                    identity.getAttributes().entries().forEach(entry -> {
                        ModelNode entryNode = attributesNode.get(entry.getKey()).setEmptyList();
                        entry.forEach(value -> entryNode.add(value));
                    });
                    ModelNode credentialsNode = result.get("credentials").setEmptyList();
                    IdentityResourceDefinition.getCredentials(realmIdentity).forEach(password -> {
                        String passwordType;
                        if (password instanceof BCryptPassword) {
                            passwordType = "bcrypt";
                        } else if (password instanceof ClearPassword) {
                            passwordType = "clear";
                        } else if (password instanceof SimpleDigestPassword) {
                            passwordType = "simple-digest";
                        } else if (password instanceof SaltedSimpleDigestPassword) {
                            passwordType = "salted-simple-digest";
                        } else if (password instanceof DigestPassword) {
                            passwordType = "digest";
                        } else {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unsupportedPasswordType(password.getClass());
                        }
                        credentialsNode.add(passwordType);
                    });
                    parentContext.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                }
                catch (RealmUnavailableException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotReadIdentity(principalName, (Exception)((Object)e));
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static class ReadSecurityDomainIdentityHandler
    implements OperationStepHandler {
        public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setAllowExpression(false)).build();

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition("read-identity", descriptionResolver, new AttributeDefinition[]{NAME}), (OperationStepHandler)new ReadSecurityDomainIdentityHandler());
        }

        private ReadSecurityDomainIdentityHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(operation, (parentContext, parentOperation) -> {
                ServiceRegistry serviceRegistry = parentContext.getServiceRegistry(false);
                RuntimeCapability runtimeCapability = Capabilities.SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(parentContext.getCurrentAddressValue());
                ServiceName domainServiceName = runtimeCapability.getCapabilityServiceName(SecurityDomain.class);
                ServiceController<SecurityDomain> serviceController = ElytronExtension.getRequiredService(serviceRegistry, domainServiceName, SecurityDomain.class);
                SecurityDomain domain = (SecurityDomain)serviceController.getValue();
                ServerAuthenticationContext authenticationContext = domain.createNewAuthenticationContext();
                String principalName = NAME.resolveModelAttribute(parentContext, parentOperation).asString();
                try {
                    authenticationContext.setAuthenticationName(principalName);
                    if (!authenticationContext.exists()) {
                        parentContext.getFailureDescription().add(ElytronSubsystemMessages.ROOT_LOGGER.identityNotFound(principalName));
                        return;
                    }
                    if (!authenticationContext.authorize(principalName)) {
                        parentContext.getFailureDescription().add(ElytronSubsystemMessages.ROOT_LOGGER.identityNotAuthorized(principalName));
                        return;
                    }
                    SecurityIdentity identity = authenticationContext.getAuthorizedIdentity();
                    ModelNode result = parentContext.getResult();
                    result.get("name").set(principalName);
                    ModelNode attributesNode = result.get("attributes");
                    identity.getAttributes().entries().forEach(entry -> {
                        ModelNode entryNode = attributesNode.get(entry.getKey()).setEmptyList();
                        entry.forEach(value -> entryNode.add(value));
                    });
                    ModelNode rolesNode = result.get("roles");
                    identity.getRoles().forEach(roleName -> rolesNode.add(roleName));
                    ModelNode permissionsNode = result.get("permissions").setEmptyList();
                    Enumeration<Permission> permissions = identity.getPermissions().elements();
                    while (permissions.hasMoreElements()) {
                        permissionsNode.add(permissions.nextElement().toString());
                    }
                    parentContext.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                }
                catch (RealmUnavailableException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotReadIdentity(principalName, domainServiceName, (Exception)((Object)e));
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class IdentityRemoveHandler
    implements OperationStepHandler {
        private IdentityRemoveHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(operation, (context1, operation1) -> {
                ModifiableSecurityRealm modifiableRealm = IdentityResourceDefinition.getModifiableSecurityRealm(context1);
                String principalName = PathAddress.pathAddress((ModelNode)operation1.get("address")).getLastElement().getValue();
                try {
                    ModifiableRealmIdentity realmIdentity = modifiableRealm.getRealmIdentityForUpdate(principalName, null, null);
                    if (!realmIdentity.exists()) {
                        throw new OperationFailedException(ElytronSubsystemMessages.ROOT_LOGGER.identityNotFound(principalName));
                    }
                    realmIdentity.delete();
                }
                catch (RealmUnavailableException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotCreateIdentity(principalName, (Exception)((Object)e));
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class IdentityAddHandler
    implements OperationStepHandler {
        private IdentityAddHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(operation, (context1, operation1) -> {
                ModifiableSecurityRealm modifiableRealm = IdentityResourceDefinition.getModifiableSecurityRealm(context);
                String principalName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
                try {
                    ModifiableRealmIdentity identity = modifiableRealm.getRealmIdentityForUpdate(principalName, null, null);
                    if (identity.exists()) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.identityAlreadyExists(principalName);
                    }
                    identity.create();
                }
                catch (RealmUnavailableException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotCreateIdentity(principalName, (Exception)((Object)e));
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

