/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron.CertificateChainAttributeDefintions;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.KeyStoreDefinition;
import org.wildfly.extension.elytron.KeyStoreService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.keystore.PasswordEntry;

class KeyStoreAliasDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition CREATION_DATE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("creation-date", ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition ENTRY_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("entry-type", ModelType.STRING).setStorageRuntime()).setAllowedValues(new String[]{PasswordEntry.class.getSimpleName(), KeyStore.PrivateKeyEntry.class.getSimpleName(), KeyStore.SecretKeyEntry.class.getSimpleName(), KeyStore.TrustedCertificateEntry.class.getSimpleName(), "Other"})).build();

    KeyStoreAliasDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"alias"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("keystore", "alias")).setRemoveHandler((OperationStepHandler)new RemoveHandler()).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CREATION_DATE, (OperationStepHandler)new KeyStoreDefinition.KeyStoreRuntimeOnlyHandler(false){

            @Override
            protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                Date creationDate;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                String alias = KeyStoreAliasDefinition.alias(operation);
                try {
                    creationDate = keyStoreService.getValue().getCreationDate(alias);
                }
                catch (RuntimeException | KeyStoreException e) {
                    ElytronSubsystemMessages.ROOT_LOGGER.tracef(e, "Unable to populate %s", CREATION_DATE);
                    return;
                }
                if (creationDate != null) {
                    result.set(sdf.format(creationDate));
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ENTRY_TYPE, (OperationStepHandler)new KeyStoreDefinition.KeyStoreRuntimeOnlyHandler(false){

            @Override
            protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                KeyStore keyStore = keyStoreService.getValue();
                String alias = KeyStoreAliasDefinition.alias(operation);
                try {
                    if (keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                        result.set(KeyStore.PrivateKeyEntry.class.getSimpleName());
                    } else if (keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
                        result.set(KeyStore.SecretKeyEntry.class.getSimpleName());
                    } else if (keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
                        result.set(KeyStore.TrustedCertificateEntry.class.getSimpleName());
                    } else if (keyStore.entryInstanceOf(alias, PasswordEntry.class)) {
                        result.set(PasswordEntry.class.getSimpleName());
                    } else {
                        result.set("Other");
                    }
                }
                catch (RuntimeException | KeyStoreException e) {
                    ElytronSubsystemMessages.ROOT_LOGGER.tracef(e, "Unable to populate %s", ENTRY_TYPE);
                    return;
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CertificateChainAttributeDefintions.CERTIFICATE, (OperationStepHandler)new KeyStoreDefinition.KeyStoreRuntimeOnlyHandler(false){

            @Override
            protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                String alias = KeyStoreAliasDefinition.alias(operation);
                KeyStore keyStore = keyStoreService.getValue();
                try {
                    Certificate cert;
                    if (keyStore.getCertificateChain(alias) == null && (cert = keyStore.getCertificate(alias)) != null) {
                        CertificateChainAttributeDefintions.writeCertificate(result, cert);
                    }
                }
                catch (RuntimeException | KeyStoreException | NoSuchAlgorithmException | CertificateEncodingException e) {
                    ElytronSubsystemMessages.ROOT_LOGGER.tracef(e, "Unable to populate %s", CertificateChainAttributeDefintions.CERTIFICATE);
                    return;
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CertificateChainAttributeDefintions.CERTIFICATE_CHAIN, (OperationStepHandler)new KeyStoreDefinition.KeyStoreRuntimeOnlyHandler(false){

            @Override
            protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                String alias = KeyStoreAliasDefinition.alias(operation);
                KeyStore keyStore = keyStoreService.getValue();
                try {
                    Certificate[] chain = keyStore.getCertificateChain(alias);
                    if (chain != null) {
                        CertificateChainAttributeDefintions.writeCertificateChain(result, chain);
                    }
                }
                catch (RuntimeException | KeyStoreException | NoSuchAlgorithmException | CertificateEncodingException e) {
                    ElytronSubsystemMessages.ROOT_LOGGER.tracef(e, "Unable to populate %s", CertificateChainAttributeDefintions.CERTIFICATE_CHAIN);
                    return;
                }
            }
        });
    }

    static String alias(ModelNode operation) {
        String aliasName = null;
        PathAddress pa = PathAddress.pathAddress((ModelNode)operation.require("address"));
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"alias".equals(pe.getKey())) continue;
            aliasName = pe.getValue();
            break;
        }
        if (aliasName == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.operationAddressMissingKey("alias");
        }
        return aliasName;
    }

    private static class RemoveHandler
    extends KeyStoreDefinition.KeyStoreRuntimeOnlyHandler {
        RemoveHandler() {
            super(true, true);
        }

        @Override
        protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
            String alias = KeyStoreAliasDefinition.alias(operation);
            KeyStore keyStore = keyStoreService.getModifiableValue();
            try {
                keyStore.deleteEntry(alias);
            }
            catch (KeyStoreException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }
}

