/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SingleCapabilityServiceRemoveHandler;

class TrivialResourceDefinition<T>
extends SimpleResourceDefinition {
    private final String pathKey;
    private final RuntimeCapability<?> runtimeCapability;
    private final Class<T> serviceType;
    private final AttributeDefinition[] attributes;

    TrivialResourceDefinition(String pathKey, RuntimeCapability<?> runtimeCapability, Class<T> serviceType, AbstractAddStepHandler add, AttributeDefinition ... attributes) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddHandler((OperationStepHandler)add).setRemoveHandler(new SingleCapabilityServiceRemoveHandler<T>(add, runtimeCapability, serviceType)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
        this.pathKey = pathKey;
        this.runtimeCapability = runtimeCapability;
        this.serviceType = serviceType;
        this.attributes = attributes;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.attributes != null && this.attributes.length > 0) {
            WriteAttributeHandler write = new WriteAttributeHandler(this.pathKey, this.attributes);
            for (AttributeDefinition current : this.attributes) {
                resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
            }
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(this.runtimeCapability);
    }

    private class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler(String parentName, AttributeDefinition ... attributes) {
            super(parentName, attributes);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return TrivialResourceDefinition.this.runtimeCapability.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(TrivialResourceDefinition.this.serviceType);
        }
    }
}

