/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.SingleCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.jdbc.ColumnMapper;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.realm.jdbc.KeyMapper;
import org.wildfly.security.auth.realm.jdbc.QueryBuilder;
import org.wildfly.security.auth.realm.jdbc.mapper.AttributeMapper;
import org.wildfly.security.auth.realm.jdbc.mapper.PasswordKeyMapper;
import org.wildfly.security.auth.server.SecurityRealm;

class JdbcRealmDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "jdbc-realm", SecurityRealm.class);
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PrincipalQueryAttributes.PRINCIPAL_QUERIES};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new SingleCapabilityServiceRemoveHandler<SecurityRealm>(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, SecurityRealm.class);
    private static final OperationStepHandler WRITE = new WriteAttributeHandler();

    JdbcRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"jdbc-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("jdbc-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, WRITE);
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("jdbc-realm", ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(SecurityRealm.class);
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            ModelNode principalQueries = PrincipalQueryAttributes.PRINCIPAL_QUERIES.resolveModelAttribute(context, operation);
            JdbcSecurityRealmBuilder builder = JdbcSecurityRealm.builder();
            TrivialService<SecurityRealm> service = new TrivialService<SecurityRealm>(() -> ((JdbcSecurityRealmBuilder)builder).build());
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, service);
            for (ModelNode query : principalQueries.asList()) {
                String authenticationQuerySql = ElytronExtension.asStringIfDefined(context, PrincipalQueryAttributes.SQL, query);
                final QueryBuilder queryBuilder = builder.principalQuery(authenticationQuerySql).withMapper((ColumnMapper[])this.resolveAttributeMappers(context, query)).withMapper((ColumnMapper[])this.resolveKeyMappers(context, query));
                String dataSourceName = ElytronExtension.asStringIfDefined(context, PrincipalQueryAttributes.DATA_SOURCE, query);
                String capabilityName = "org.wildfly.data-source." + dataSourceName;
                ServiceName dataSourceServiceName = context.getCapabilityServiceName(capabilityName, DataSource.class);
                serviceBuilder.addDependency(dataSourceServiceName, DataSource.class, (Injector)new Injector<DataSource>(){

                    public void inject(DataSource value) throws InjectionException {
                        queryBuilder.from(value);
                    }

                    public void uninject() {
                    }
                });
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private KeyMapper[] resolveKeyMappers(OperationContext context, ModelNode authenticationQueryNode) throws OperationFailedException {
            ArrayList<PasswordKeyMapper> keyMappers = new ArrayList<PasswordKeyMapper>();
            for (String name : authenticationQueryNode.keys()) {
                ModelNode propertyNode = authenticationQueryNode.require(name);
                PasswordMapperObjectDefinition mapperResource = PrincipalQueryAttributes.SUPPORTED_PASSWORD_MAPPERS.get(name);
                if (mapperResource == null) continue;
                try {
                    keyMappers.add(mapperResource.toPasswordKeyMapper(context, propertyNode));
                }
                catch (InvalidKeyException e) {
                    throw new OperationFailedException("Invalid key type.", (Throwable)e);
                }
            }
            return keyMappers.toArray(new KeyMapper[keyMappers.size()]);
        }

        private AttributeMapper[] resolveAttributeMappers(OperationContext context, ModelNode principalQueryNode) throws OperationFailedException {
            ArrayList<AttributeMapper> attributeMappers = new ArrayList<AttributeMapper>();
            ModelNode attributeMappingNode = PrincipalQueryAttributes.ATTRIBUTE_MAPPINGS.resolveModelAttribute(context, principalQueryNode);
            if (attributeMappingNode.isDefined()) {
                for (ModelNode attributeNode : attributeMappingNode.asList()) {
                    ModelNode indexNode = AttributeMappingObjectDefinition.INDEX.resolveModelAttribute(context, attributeNode);
                    ModelNode nameNode = AttributeMappingObjectDefinition.TO.resolveModelAttribute(context, attributeNode);
                    attributeMappers.add(new AttributeMapper(indexNode.asInt(), nameNode.asString()));
                }
            }
            return attributeMappers.toArray(new AttributeMapper[attributeMappers.size()]);
        }
    }

    static class StringValuesValidator
    extends ModelTypeValidator
    implements AllowedValuesValidator {
        private List<ModelNode> allowedValues = new ArrayList<ModelNode>();

        public StringValuesValidator(String ... values) {
            super(ModelType.STRING);
            for (String value : values) {
                this.allowedValues.add(new ModelNode().set(value));
            }
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined() && !this.allowedValues.contains(value)) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidValue(value.asString(), parameterName, this.allowedValues));
            }
        }

        public List<ModelNode> getAllowedValues() {
            return this.allowedValues;
        }
    }

    static class PrincipalQueryAttributes {
        static final SimpleAttributeDefinition SQL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sql", ModelType.STRING, false).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition DATA_SOURCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("data-source", ModelType.STRING, false).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.data-source", "org.wildfly.security.security-realm", true)).build();
        static final ObjectListAttributeDefinition ATTRIBUTE_MAPPINGS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("attribute-mapping", AttributeMappingObjectDefinition.OBJECT_DEFINITION).setAllowNull(true).setAttributeGroup("attribute")).setAllowDuplicates(true)).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SQL, DATA_SOURCE};
        static Map<String, PasswordMapperObjectDefinition> SUPPORTED_PASSWORD_MAPPERS;
        static final ObjectTypeAttributeDefinition PRINCIPAL_QUERY;
        static final ObjectListAttributeDefinition PRINCIPAL_QUERIES;

        PrincipalQueryAttributes() {
        }

        static {
            HashMap<String, PasswordMapperObjectDefinition> supportedMappers = new HashMap<String, PasswordMapperObjectDefinition>();
            supportedMappers.put("clear-password-mapper", new ClearPasswordObjectDefinition());
            supportedMappers.put("bcrypt-mapper", new BcryptPasswordObjectDefinition());
            supportedMappers.put("salted-simple-digest-mapper", new SaltedSimpleDigestObjectDefinition());
            supportedMappers.put("simple-digest-mapper", new SimpleDigestMapperObjectDefinition());
            supportedMappers.put("scram-mapper", new ScramMapperObjectDefinition());
            SUPPORTED_PASSWORD_MAPPERS = Collections.unmodifiableMap(supportedMappers);
            PRINCIPAL_QUERY = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("principal-query", new AttributeDefinition[]{SQL, DATA_SOURCE, ATTRIBUTE_MAPPINGS, ClearPasswordObjectDefinition.OBJECT_DEFINITION, BcryptPasswordObjectDefinition.OBJECT_DEFINITION, SaltedSimpleDigestObjectDefinition.OBJECT_DEFINITION, SimpleDigestMapperObjectDefinition.OBJECT_DEFINITION, ScramMapperObjectDefinition.OBJECT_DEFINITION}).setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
            PRINCIPAL_QUERIES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("principal-query", PRINCIPAL_QUERY).setAllowNull(true).setAttributeGroup("attribute")).setAllowDuplicates(true)).build();
        }
    }

    static class AttributeMappingObjectDefinition {
        static final SimpleAttributeDefinition INDEX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("index", ModelType.INT, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("to", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{TO, INDEX};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("attribute", (AttributeDefinition[])ATTRIBUTES).setAllowNull(true).build();

        AttributeMappingObjectDefinition() {
        }
    }

    static interface PasswordMapperObjectDefinition {
        public ObjectTypeAttributeDefinition getObjectDefinition();

        public SimpleAttributeDefinition[] getAttributes();

        public PasswordKeyMapper toPasswordKeyMapper(OperationContext var1, ModelNode var2) throws OperationFailedException, InvalidKeyException;
    }

    static class ScramMapperObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("scram-sha-256"))).setValidator((ParameterValidator)new StringValuesValidator("scram-sha-1", "scram-sha-256"))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ITERATION_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("iteration-count-index", ModelType.INT, false).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-index", ModelType.INT, false).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("scram-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT, ITERATION_COUNT}).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        ScramMapperObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{ALGORITHM, PASSWORD, SALT, ITERATION_COUNT};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            String algorithm = ElytronExtension.asStringIfDefined(context, ALGORITHM, propertyNode);
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            int salt = ElytronExtension.asIntIfDefined(context, SALT, propertyNode);
            int iterationCount = ElytronExtension.asIntIfDefined(context, ITERATION_COUNT, propertyNode);
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).setSaltColumn(salt).setIterationCountColumn(iterationCount).build();
        }
    }

    static class SimpleDigestMapperObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("simple-digest-md5"))).setValidator((ParameterValidator)new StringValuesValidator("simple-digest-md2", "simple-digest-md5", "simple-digest-sha-1", "simple-digest-sha-256", "simple-digest-sha-384", "simple-digest-sha-512"))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("simple-digest-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD}).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        SimpleDigestMapperObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{ALGORITHM, PASSWORD};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            String algorithm = ElytronExtension.asStringIfDefined(context, ALGORITHM, propertyNode);
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).build();
        }
    }

    static class SaltedSimpleDigestObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("password-salt-digest-md5"))).setValidator((ParameterValidator)new StringValuesValidator("password-salt-digest-md5", "password-salt-digest-sha-1", "password-salt-digest-sha-256", "password-salt-digest-sha-384", "password-salt-digest-sha-512", "salt-password-digest-md5", "salt-password-digest-sha-1", "salt-password-digest-sha-256", "salt-password-digest-sha-384", "salt-password-digest-sha-512"))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-index", ModelType.INT, false).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("salted-simple-digest-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT}).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        SaltedSimpleDigestObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{ALGORITHM, PASSWORD, SALT};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            String algorithm = ElytronExtension.asStringIfDefined(context, ALGORITHM, propertyNode);
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            int salt = ElytronExtension.asIntIfDefined(context, SALT, propertyNode);
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).setSaltColumn(salt).build();
        }
    }

    static class BcryptPasswordObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("bcrypt"))).setValidator((ParameterValidator)new StringValuesValidator("bcrypt"))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ITERATION_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("iteration-count-index", ModelType.INT, false).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-index", ModelType.INT, false).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("bcrypt-mapper", new AttributeDefinition[]{PASSWORD, SALT, ITERATION_COUNT}).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        BcryptPasswordObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{PASSWORD, SALT, ITERATION_COUNT};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            int salt = ElytronExtension.asIntIfDefined(context, SALT, propertyNode);
            int iterationCount = ElytronExtension.asIntIfDefined(context, ITERATION_COUNT, propertyNode);
            return PasswordKeyMapper.builder().setHashColumn(password).setSaltColumn(salt).setIterationCountColumn(iterationCount).build();
        }
    }

    static class ClearPasswordObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setDefaultValue(new ModelNode("clear"))).setValidator((ParameterValidator)new StringValuesValidator("clear"))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("clear-password-mapper", new AttributeDefinition[]{PASSWORD}).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        ClearPasswordObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{PASSWORD};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            return PasswordKeyMapper.builder().setHashColumn(password).build();
        }
    }
}

