/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.msc.service.ServiceController;
import org.wildfly.security.util.ByteIterator;

class SSLContextResource
extends DelegatingResource {
    private ServiceController<SSLContext> sslContextServiceController;

    public SSLContextResource(Resource delegate) {
        super(delegate);
    }

    public void setSSLContextServiceController(ServiceController<SSLContext> sslContextServiceController) {
        this.sslContextServiceController = sslContextServiceController;
    }

    public Set<String> getChildTypes() {
        if (this.hasActiveSessions()) {
            return Collections.singleton("ssl-session");
        }
        return Collections.emptySet();
    }

    public boolean hasChildren(String childType) {
        return "ssl-session".equals(childType) && this.hasActiveSessions();
    }

    public boolean hasChild(PathElement element) {
        SSLContext sslContext;
        if ("ssl-session".equals(element.getKey()) && (sslContext = SSLContextResource.getSSLContext(this.sslContextServiceController)) != null) {
            byte[] sessionId = ByteIterator.ofBytes((byte[])element.getValue().getBytes(StandardCharsets.UTF_8)).hexDecode().drain();
            return sslContext.getServerSessionContext().getSession(sessionId) != null;
        }
        return false;
    }

    public Resource getChild(PathElement element) {
        return this.hasChild(element) ? PlaceholderResource.INSTANCE : null;
    }

    public Resource requireChild(PathElement element) {
        Resource resource = this.getChild(element);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(element);
        }
        return resource;
    }

    public Set<String> getChildrenNames(String childType) {
        SSLContext sslContext;
        if ("ssl-session".equals(childType) && (sslContext = SSLContextResource.getSSLContext(this.sslContextServiceController)) != null) {
            return Collections.list(sslContext.getServerSessionContext().getIds()).stream().map(b -> ByteIterator.ofBytes((byte[])b).hexEncode(true).drainToString()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        return this.getChildrenNames(childType).stream().map(s -> new PlaceholderResource.PlaceholderResourceEntry("ssl-session", s)).collect(Collectors.toSet());
    }

    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate((Resource)this, (PathAddress)address);
    }

    public Resource clone() {
        SSLContextResource sslContextResource = new SSLContextResource(super.clone());
        sslContextResource.setSSLContextServiceController(this.sslContextServiceController);
        return sslContextResource;
    }

    private boolean hasActiveSessions() {
        SSLContext sslContext = SSLContextResource.getSSLContext(this.sslContextServiceController);
        return sslContext != null && sslContext.getServerSessionContext().getIds().hasMoreElements();
    }

    static SSLContext getSSLContext(ServiceController<SSLContext> sslContexyServiceController) {
        if (sslContexyServiceController == null || sslContexyServiceController.getState() != ServiceController.State.UP) {
            return null;
        }
        return (SSLContext)sslContexyServiceController.getValue();
    }
}

