/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.BiConsumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron.CertificateChainAttributeDefintions;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SSLDefinitions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.util.ByteIterator;

public class SSLSessionDefinition
extends SimpleResourceDefinition {
    private static final SimpleAttributeDefinition APPLICATION_BUFFER_SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("application-buffer-size", ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition CIPHER_SUITE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cipher-suite", ModelType.STRING).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition CREATION_TIME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("creation-time", ModelType.STRING).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition LAST_ACCESSED_TIME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("last-accessed-time", ModelType.STRING).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition LOCAL_PRINCIPAL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("local-principal", ModelType.STRING).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition PACKET_BUFFER_SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("packet-buffer-size", ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition PEER_HOST = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("peer-host", ModelType.STRING).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition PEER_PORT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("peer-port", ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition PEER_PRINCIPAL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("peer-principal", ModelType.STRING).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition VALID = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("valid", ModelType.BOOLEAN).setStorageRuntime()).build();
    private static final ResourceDescriptionResolver RESOURCE_DESCRIPTION_RESOLVER = ElytronExtension.getResourceDescriptionResolver("server-ssl-context", "ssl-session");
    private static final SimpleOperationDefinition INVALIDATE = new SimpleOperationDefinitionBuilder("invalidate", RESOURCE_DESCRIPTION_RESOLVER).build();

    SSLSessionDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"ssl-session"), RESOURCE_DESCRIPTION_RESOLVER).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)APPLICATION_BUFFER_SIZE, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> r.set(s.getApplicationBufferSize())));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CIPHER_SUITE, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> r.set(s.getCipherSuite())));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CREATION_TIME, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> r.set(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date(s.getCreationTime())))));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LAST_ACCESSED_TIME, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> r.set(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date(s.getLastAccessedTime())))));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CertificateChainAttributeDefintions.getNamedCertificateList("local-certificates"), (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> {
            try {
                CertificateChainAttributeDefintions.writeCertificates(r, s.getLocalCertificates());
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
                // empty catch block
            }
        }));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LOCAL_PRINCIPAL, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> {
            Principal p = s.getLocalPrincipal();
            if (p != null) {
                r.set(p.toString());
            }
        }));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PACKET_BUFFER_SIZE, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> r.set(s.getPacketBufferSize())));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CertificateChainAttributeDefintions.getNamedCertificateList("peer-certificates"), (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> {
            try {
                CertificateChainAttributeDefintions.writeCertificates(r, s.getPeerCertificates());
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException | SSLPeerUnverifiedException exception) {
                // empty catch block
            }
        }));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PEER_HOST, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> r.set(s.getPeerHost())));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PEER_PORT, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> r.set(s.getPeerPort())));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PEER_PRINCIPAL, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> {
            try {
                Principal p = s.getPeerPrincipal();
                if (p != null) {
                    r.set(p.toString());
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PROTOCOL, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> r.set(s.getProtocol())));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)VALID, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> r.set(s.isValid())));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)INVALIDATE, (OperationStepHandler)new SSLSessionRuntimeHandler((r, s) -> s.invalidate()));
    }

    private static byte[] sessionId(ModelNode operation) {
        PathAddress pa = PathAddress.pathAddress((ModelNode)operation.require("address"));
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"ssl-session".equals(pe.getKey())) continue;
            return ByteIterator.ofBytes((byte[])pe.getValue().getBytes(StandardCharsets.UTF_8)).hexDecode().drain();
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.operationAddressMissingKey("ssl-session");
    }

    static class SSLSessionRuntimeHandler
    extends SSLDefinitions.SSLContextRuntimeHandler {
        private final BiConsumer<ModelNode, SSLSession> biConsumer;

        SSLSessionRuntimeHandler(BiConsumer<ModelNode, SSLSession> biConsumer) {
            this.biConsumer = biConsumer;
        }

        @Override
        protected void performRuntime(ModelNode result, ModelNode operation, SSLContext sslContext) throws OperationFailedException {
            SSLSession sslSession = sslContext.getServerSessionContext().getSession(SSLSessionDefinition.sessionId(operation));
            if (sslSession != null) {
                this.performRuntime(result, operation, sslSession);
            }
        }

        protected void performRuntime(ModelNode result, ModelNode operation, SSLSession sslSession) throws OperationFailedException {
            this.biConsumer.accept(result, sslSession);
        }
    }
}

