/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.Assert;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.TrivialService;

abstract class TrivialAddHandler<T>
extends BaseAddHandler {
    private final RuntimeCapability<?> runtimeCapability;
    private final Class<T> serviceType;
    private final ServiceController.Mode initialMode;

    TrivialAddHandler(RuntimeCapability<?> runtimeCapability, Class<T> serviceType, AttributeDefinition ... attributes) {
        this(runtimeCapability, serviceType, ServiceController.Mode.ACTIVE, attributes);
    }

    TrivialAddHandler(RuntimeCapability<?> runtimeCapability, Class<T> serviceType, ServiceController.Mode initialMode, AttributeDefinition ... attributes) {
        super((RuntimeCapability)Assert.checkNotNullParam((String)"runtimeCapability", runtimeCapability), attributes);
        this.runtimeCapability = runtimeCapability;
        this.serviceType = (Class)Assert.checkNotNullParam((String)"serviceType", serviceType);
        this.initialMode = (ServiceController.Mode)Assert.checkNotNullParam((String)"initialMode", (Object)initialMode);
    }

    protected final void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        RuntimeCapability runtimeCapability = this.runtimeCapability.fromBaseCapability(context.getCurrentAddressValue());
        ServiceName serviceName = runtimeCapability.getCapabilityServiceName(this.serviceType);
        ServiceTarget serviceTarget = context.getServiceTarget();
        TrivialService<T> trivialService = new TrivialService<T>();
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, trivialService);
        trivialService.setValueSupplier(this.getValueSupplier(serviceBuilder, context, resource.getModel()));
        this.installedForResource(ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(this.initialMode).install(), resource);
    }

    protected void installedForResource(ServiceController<T> serviceController, Resource resource) {
    }

    protected abstract TrivialService.ValueSupplier<T> getValueSupplier(ServiceBuilder<T> var1, OperationContext var2, ModelNode var3) throws OperationFailedException;
}

