/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AuthenticationFactoryDefinitions;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.SaslServerDefinitions;

class AuthenticationFactoryParser {
    AuthenticationFactoryParser() {
    }

    private void readMechanismRealmElement(ModelNode mechanismRealmConfiguration, XMLExtendedStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "realm-name": {
                    AuthenticationFactoryDefinitions.REALM_NAME.parseAndSetParameter(value, mechanismRealmConfiguration, (XMLStreamReader)reader);
                    continue block14;
                }
                case "pre-realm-name-rewriter": {
                    AuthenticationFactoryDefinitions.BASE_PRE_REALM_NAME_REWRITER.parseAndSetParameter(value, mechanismRealmConfiguration, (XMLStreamReader)reader);
                    continue block14;
                }
                case "post-realm-name-rewriter": {
                    AuthenticationFactoryDefinitions.BASE_POST_REALM_NAME_REWRITER.parseAndSetParameter(value, mechanismRealmConfiguration, (XMLStreamReader)reader);
                    continue block14;
                }
                case "final-name-rewriter": {
                    AuthenticationFactoryDefinitions.BASE_FINAL_NAME_REWRITER.parseAndSetParameter(value, mechanismRealmConfiguration, (XMLStreamReader)reader);
                    continue block14;
                }
                case "realm-mapper": {
                    AuthenticationFactoryDefinitions.BASE_REALM_MAPPER.parseAndSetParameter(value, mechanismRealmConfiguration, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!mechanismRealmConfiguration.hasDefined("realm-name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("realm-name"));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readMechanismElement(ModelNode mechanismConfiguration, XMLExtendedStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "mechanism-name": {
                    AuthenticationFactoryDefinitions.MECHANISM_NAME.parseAndSetParameter(value, mechanismConfiguration, (XMLStreamReader)reader);
                    continue block20;
                }
                case "host-name": {
                    AuthenticationFactoryDefinitions.HOST_NAME.parseAndSetParameter(value, mechanismConfiguration, (XMLStreamReader)reader);
                    continue block20;
                }
                case "protocol": {
                    AuthenticationFactoryDefinitions.PROTOCOL.parseAndSetParameter(value, mechanismConfiguration, (XMLStreamReader)reader);
                    continue block20;
                }
                case "pre-realm-name-rewriter": {
                    AuthenticationFactoryDefinitions.BASE_PRE_REALM_NAME_REWRITER.parseAndSetParameter(value, mechanismConfiguration, (XMLStreamReader)reader);
                    continue block20;
                }
                case "post-realm-name-rewriter": {
                    AuthenticationFactoryDefinitions.BASE_POST_REALM_NAME_REWRITER.parseAndSetParameter(value, mechanismConfiguration, (XMLStreamReader)reader);
                    continue block20;
                }
                case "final-name-rewriter": {
                    AuthenticationFactoryDefinitions.BASE_FINAL_NAME_REWRITER.parseAndSetParameter(value, mechanismConfiguration, (XMLStreamReader)reader);
                    continue block20;
                }
                case "realm-mapper": {
                    AuthenticationFactoryDefinitions.BASE_REALM_MAPPER.parseAndSetParameter(value, mechanismConfiguration, (XMLStreamReader)reader);
                    continue block20;
                }
                case "credential-security-factory": {
                    AuthenticationFactoryDefinitions.BASE_CREDENTIAL_SECURITY_FACTORY.parseAndSetParameter(value, mechanismConfiguration, (XMLStreamReader)reader);
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"mechanism-realm".equals(localName)) continue;
            ModelNode mechanismRealmConfiguration = new ModelNode();
            this.readMechanismRealmElement(mechanismRealmConfiguration, reader);
            mechanismConfiguration.get("mechanism-realm-configurations").add(mechanismRealmConfiguration);
        }
    }

    private void readMechanismConfigurationElement(ModelNode addOperation, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"mechanism".equals(localName)) continue;
            ModelNode mechanismConfiguration = new ModelNode();
            this.readMechanismElement(mechanismConfiguration, reader);
            addOperation.get("mechanism-configurations").add(mechanismConfiguration);
        }
    }

    private void attemptReadMechanismConfigurationElement(ModelNode addOperation, XMLExtendedStreamReader reader) throws XMLStreamException {
        boolean mechanismConfigurationAdded = false;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("mechanism-configuration".equals(localName) && !mechanismConfigurationAdded) {
                mechanismConfigurationAdded = true;
                this.readMechanismConfigurationElement(addOperation, reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readHttpServerAuthenticationElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "security-domain", "http-server-factory"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "http-server-factory": {
                    AuthenticationFactoryDefinitions.HTTP_SERVER_FACTORY.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                case "security-domain": {
                    AuthenticationFactoryDefinitions.BASE_SECURITY_DOMAIN_REF.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addOperation.get("address").set(parentAddress).add("http-server-authentication", name);
        this.attemptReadMechanismConfigurationElement(addOperation, reader);
        operations.add(addOperation);
    }

    void readSaslServerAuthenticationElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "security-domain", "sasl-server-factory"));
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block10;
                }
                case "sasl-server-factory": {
                    SaslServerDefinitions.SASL_SERVER_FACTORY.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                case "security-domain": {
                    SaslServerDefinitions.SECURITY_DOMAIN.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addOperation.get("address").set(parentAddress).add("sasl-server-authentication", name);
        this.attemptReadMechanismConfigurationElement(addOperation, reader);
        operations.add(addOperation);
    }

    private void writeMechanismConfiguration(ModelNode configuration, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (configuration.hasDefined("mechanism-configurations")) {
            writer.writeStartElement("mechanism-configuration");
            for (ModelNode currentMechConfig : configuration.require("mechanism-configurations").asList()) {
                writer.writeStartElement("mechanism");
                AuthenticationFactoryDefinitions.MECHANISM_NAME.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.HOST_NAME.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.PROTOCOL.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_PRE_REALM_NAME_REWRITER.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_POST_REALM_NAME_REWRITER.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_FINAL_NAME_REWRITER.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_REALM_MAPPER.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_CREDENTIAL_SECURITY_FACTORY.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                if (currentMechConfig.hasDefined("mechanism-realm-configurations")) {
                    for (ModelNode currentMechRealmConfig : currentMechConfig.require("mechanism-realm-configurations").asList()) {
                        writer.writeStartElement("mechanism-realm");
                        AuthenticationFactoryDefinitions.REALM_NAME.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        AuthenticationFactoryDefinitions.BASE_PRE_REALM_NAME_REWRITER.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        AuthenticationFactoryDefinitions.BASE_POST_REALM_NAME_REWRITER.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        AuthenticationFactoryDefinitions.BASE_FINAL_NAME_REWRITER.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        AuthenticationFactoryDefinitions.BASE_REALM_MAPPER.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    boolean writeHttpServerAuthentication(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer, WrapperWriter wrapperWriter) throws XMLStreamException {
        if (subsystem.hasDefined("http-server-authentication")) {
            wrapperWriter.start(started);
            ModelNode securityDomainHttpConfiguration = subsystem.require("http-server-authentication");
            for (String name : securityDomainHttpConfiguration.keys()) {
                ModelNode configuration = securityDomainHttpConfiguration.require(name);
                writer.writeStartElement("http-server-authentication");
                writer.writeAttribute("name", name);
                AuthenticationFactoryDefinitions.HTTP_SERVER_FACTORY.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_SECURITY_DOMAIN_REF.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                this.writeMechanismConfiguration(configuration, writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    boolean writeSaslServerAuthenticationConfiguration(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer, WrapperWriter wrapperWriter) throws XMLStreamException {
        if (subsystem.hasDefined("sasl-server-authentication")) {
            wrapperWriter.start(started);
            ModelNode securityDomainSaslConfigurationInstances = subsystem.require("sasl-server-authentication");
            for (String name : securityDomainSaslConfigurationInstances.keys()) {
                ModelNode configuration = securityDomainSaslConfigurationInstances.require(name);
                writer.writeStartElement("sasl-server-authentication");
                writer.writeAttribute("name", name);
                SaslServerDefinitions.SASL_SERVER_FACTORY.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                SaslServerDefinitions.SECURITY_DOMAIN.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                this.writeMechanismConfiguration(configuration, writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    @FunctionalInterface
    static interface WrapperWriter {
        public void start(boolean var1) throws XMLStreamException;
    }
}

