/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SSLContextResource;
import org.wildfly.extension.elytron.SSLSessionDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.Protocol;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLContextBuilder;

class SSLDefinitions {
    static final ServiceUtil<SSLContext> SERVER_SSL_CONTEXT = ServiceUtil.newInstance(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY, "server-ssl-context", SSLContext.class);
    static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROVIDER_LOADER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-loader", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEYSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDeprecated(ElytronExtension.ELYTRON_1_0_0)).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.ssl-context", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CIPHER_SUITE_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cipher-suite-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StringListAttributeDefinition PROTOCOLS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("protocols").setAllowExpression(true)).setMinSize(1)).setAllowedValues(ElytronExtension.allowedValues(Protocol.values()))).setValidator((ParameterValidator)new EnumValidator(Protocol.class, false, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition WANT_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("want-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition NEED_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("need-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition AUTHENTICATION_OPTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-optional", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MAXIMUM_SESSION_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-session-cache-size", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SESSION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-timeout", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEY_MANAGERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-managers", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.key-managers", "org.wildfly.security.ssl-context", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition TRUST_MANAGERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trust-managers", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.trust-managers", "org.wildfly.security.ssl-context", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static SimpleAttributeDefinition ACTIVE_SESSION_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("active-session-count", ModelType.INT).setStorageRuntime()).build();

    SSLDefinitions() {
    }

    static ResourceDefinition getKeyManagerDefinition() {
        final SimpleAttributeDefinition providerLoaderDefinition = SSLDefinitions.setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.key-managers", PROVIDER_LOADER);
        final SimpleAttributeDefinition keystoreDefinition = SSLDefinitions.setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.key-managers", KEYSTORE);
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providerLoaderDefinition, keystoreDefinition, PASSWORD};
        TrivialAddHandler<KeyManager[]> add = new TrivialAddHandler<KeyManager[]>(KeyManager[].class, attributes, new RuntimeCapability[]{Capabilities.KEY_MANAGERS_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<KeyManager[]> getValueSupplier(ServiceBuilder<KeyManager[]> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithm = ALGORITHM.resolveModelAttribute(context, model).asString();
                String password = ElytronExtension.asStringIfDefined(context, PASSWORD, model);
                String providerLoader = ElytronExtension.asStringIfDefined(context, providerLoaderDefinition, model);
                InjectedValue providersInjector = new InjectedValue();
                if (providerLoader != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providerLoader), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStore = ElytronExtension.asStringIfDefined(context, keystoreDefinition, model);
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStore != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStore), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                return () -> {
                    Provider[] providers = (Provider[])providersInjector.getOptionalValue();
                    KeyManagerFactory keyManagerFactory = null;
                    if (providers != null) {
                        for (Provider current : providers) {
                            try {
                                keyManagerFactory = KeyManagerFactory.getInstance(algorithm, current);
                                break;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            }
                        }
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(KeyManagerFactory.class.getSimpleName(), algorithm);
                    }
                    try {
                        keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new StartException((Throwable)e);
                    }
                    try {
                        keyManagerFactory.init((KeyStore)keyStoreInjector.getOptionalValue(), password != null ? password.toCharArray() : null);
                    }
                    catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                        throw new StartException((Throwable)e);
                    }
                    return keyManagerFactory.getKeyManagers();
                };
            }
        };
        return new TrivialResourceDefinition("key-managers", add, attributes, Capabilities.KEY_MANAGERS_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getTrustManagerDefinition() {
        final SimpleAttributeDefinition providerLoaderDefinition = SSLDefinitions.setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.trust-managers", PROVIDER_LOADER);
        final SimpleAttributeDefinition keystoreDefinition = SSLDefinitions.setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.trust-managers", KEYSTORE);
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providerLoaderDefinition, keystoreDefinition};
        TrivialAddHandler<TrustManager[]> add = new TrivialAddHandler<TrustManager[]>(TrustManager[].class, attributes, new RuntimeCapability[]{Capabilities.TRUST_MANAGERS_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<TrustManager[]> getValueSupplier(ServiceBuilder<TrustManager[]> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithm = ALGORITHM.resolveModelAttribute(context, model).asString();
                String providerLoader = ElytronExtension.asStringIfDefined(context, providerLoaderDefinition, model);
                InjectedValue providersInjector = new InjectedValue();
                if (providerLoader != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providerLoader), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStore = ElytronExtension.asStringIfDefined(context, keystoreDefinition, model);
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStore != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStore), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                return () -> {
                    Provider[] providers = (Provider[])providersInjector.getOptionalValue();
                    TrustManagerFactory trustManagerFactory = null;
                    if (providers != null) {
                        for (Provider current : providers) {
                            try {
                                trustManagerFactory = TrustManagerFactory.getInstance(algorithm, current);
                                break;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            }
                        }
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(TrustManagerFactory.class.getSimpleName(), algorithm);
                    }
                    try {
                        trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new StartException((Throwable)e);
                    }
                    try {
                        trustManagerFactory.init((KeyStore)keyStoreInjector.getOptionalValue());
                    }
                    catch (KeyStoreException e) {
                        throw new StartException((Throwable)e);
                    }
                    return trustManagerFactory.getTrustManagers();
                };
            }
        };
        return new TrivialResourceDefinition("trust-managers", add, attributes, Capabilities.TRUST_MANAGERS_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getServerSSLContextBuilder() {
        final SimpleAttributeDefinition providerLoaderDefinition = SSLDefinitions.setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.ssl-context", PROVIDER_LOADER);
        AttributeDefinition[] attributes = new AttributeDefinition[]{SECURITY_DOMAIN, CIPHER_SUITE_FILTER, PROTOCOLS, WANT_CLIENT_AUTH, NEED_CLIENT_AUTH, AUTHENTICATION_OPTIONAL, MAXIMUM_SESSION_CACHE_SIZE, SESSION_TIMEOUT, KEY_MANAGERS, TRUST_MANAGERS, providerLoaderDefinition};
        TrivialAddHandler<SSLContext> add = new TrivialAddHandler<SSLContext>(SSLContext.class, attributes, new RuntimeCapability[]{Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String securityDomain = ElytronExtension.asStringIfDefined(context, SECURITY_DOMAIN, model);
                String keyManagers = ElytronExtension.asStringIfDefined(context, KEY_MANAGERS, model);
                String trustManagers = ElytronExtension.asStringIfDefined(context, TRUST_MANAGERS, model);
                String providerLoaders = ElytronExtension.asStringIfDefined(context, providerLoaderDefinition, model);
                List protocols = PROTOCOLS.unwrap((ExpressionResolver)context, model);
                String cipherSuiteFilter = ElytronExtension.asStringIfDefined(context, CIPHER_SUITE_FILTER, model);
                boolean wantClientAuth = WANT_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean needClientAuth = NEED_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean authenticationOptional = AUTHENTICATION_OPTIONAL.resolveModelAttribute(context, model).asBoolean();
                int maximumSessionCacheSize = MAXIMUM_SESSION_CACHE_SIZE.resolveModelAttribute(context, model).asInt();
                int sessionTimeout = SESSION_TIMEOUT.resolveModelAttribute(context, model).asInt();
                InjectedValue securityDomainInjector = new InjectedValue();
                InjectedValue keyManagersInjector = new InjectedValue();
                InjectedValue trustManagersInjector = new InjectedValue();
                InjectedValue providersInjector = new InjectedValue();
                if (securityDomain != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-domain", (String)securityDomain), SecurityDomain.class), SecurityDomain.class, (Injector)securityDomainInjector);
                }
                if (keyManagers != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-managers", (String)keyManagers), KeyManager[].class), KeyManager[].class, (Injector)keyManagersInjector);
                }
                if (trustManagers != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.trust-managers", (String)trustManagers), TrustManager[].class), TrustManager[].class, (Injector)trustManagersInjector);
                }
                if (providerLoaders != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providerLoaders), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                return () -> {
                    SecurityDomain securityDomainRef = (SecurityDomain)securityDomainInjector.getOptionalValue();
                    X509ExtendedKeyManager keyManager = SSLDefinitions.getX509KeyManager((KeyManager[])keyManagersInjector.getOptionalValue());
                    X509ExtendedTrustManager trustManager = SSLDefinitions.getX509TrustManager((TrustManager[])trustManagersInjector.getOptionalValue());
                    Provider[] providersRef = (Provider[])providersInjector.getOptionalValue();
                    SSLContextBuilder builder = new SSLContextBuilder();
                    if (securityDomainRef != null) {
                        builder.setSecurityDomain(securityDomainRef);
                    }
                    if (keyManager != null) {
                        builder.setKeyManager(keyManager);
                    }
                    if (trustManager != null) {
                        builder.setTrustManager((X509TrustManager)trustManager);
                    }
                    if (providersRef != null) {
                        builder.setProviderSupplier(() -> providersRef);
                    }
                    if (cipherSuiteFilter != null) {
                        builder.setCipherSuiteSelector(CipherSuiteSelector.fromString((String)cipherSuiteFilter));
                    }
                    if (!protocols.isEmpty()) {
                        builder.setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(protocols.stream().map(Protocol::valueOf).collect(Collectors.toList()))));
                    }
                    builder.setWantClientAuth(wantClientAuth).setNeedClientAuth(needClientAuth).setAuthenticationOptional(authenticationOptional).setSessionCacheSize(maximumSessionCacheSize).setSessionTimeout(sessionTimeout);
                    try {
                        return (SSLContext)builder.build().create();
                    }
                    catch (GeneralSecurityException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }

            @Override
            protected void installedForResource(ServiceController<SSLContext> serviceController, Resource resource) {
                assert (resource instanceof SSLContextResource);
                ((SSLContextResource)resource).setSSLContextServiceController(serviceController);
            }

            protected Resource createResource(OperationContext context) {
                SSLContextResource resource = new SSLContextResource(Resource.Factory.create());
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
                return resource;
            }
        };
        return new TrivialResourceDefinition("server-ssl-context", (AbstractAddStepHandler)add, attributes, new RuntimeCapability[]{Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY}){

            @Override
            public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
                super.registerAttributes(resourceRegistration);
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ACTIVE_SESSION_COUNT, (OperationStepHandler)new SSLContextRuntimeHandler(){

                    @Override
                    protected void performRuntime(ModelNode result, ModelNode operation, SSLContext sslContext) throws OperationFailedException {
                        result.set(Collections.list(sslContext.getServerSessionContext().getIds()).stream().mapToInt(b -> 1).sum());
                    }
                });
            }

            public void registerChildren(ManagementResourceRegistration resourceRegistration) {
                super.registerChildren(resourceRegistration);
                resourceRegistration.registerSubModel((ResourceDefinition)new SSLSessionDefinition());
            }
        };
    }

    private static X509ExtendedKeyManager getX509KeyManager(KeyManager[] keyManagers) throws StartException {
        if (keyManagers == null) {
            return null;
        }
        for (KeyManager current : keyManagers) {
            if (!(current instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)current;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedKeyManager.class.getSimpleName());
    }

    private static X509ExtendedTrustManager getX509TrustManager(TrustManager[] trustManagers) throws StartException {
        if (trustManagers == null) {
            return null;
        }
        for (TrustManager current : trustManagers) {
            if (!(current instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)current;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedTrustManager.class.getSimpleName());
    }

    private static SimpleAttributeDefinition setCapabilityReference(String referencedCapability, String dependentCapability, SimpleAttributeDefinition attribute) {
        return ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(attribute).setCapabilityReference(referencedCapability, dependentCapability, true)).build();
    }

    static abstract class SSLContextRuntimeHandler
    extends AbstractRuntimeOnlyHandler {
        SSLContextRuntimeHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName serverSSLContextName = SERVER_SSL_CONTEXT.serviceName(operation);
            ServiceController<SSLContext> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(false), serverSSLContextName, SSLContext.class);
            ServiceController.State serviceState = serviceContainer.getState();
            if (serviceState != ServiceController.State.UP) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serverSSLContextName, serviceState);
            }
            this.performRuntime(context.getResult(), operation, (SSLContext)serviceContainer.getService().getValue());
        }

        protected abstract void performRuntime(ModelNode var1, ModelNode var2, SSLContext var3) throws OperationFailedException;
    }
}

