/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.SecurityRealm;

class LdapRealmDefinition
extends SimpleResourceDefinition {
    static Map<String, CredentialMappingObjectDefinition> SUPPORTED_CREDENTIAL_MAPPERS;
    static final SimpleAttributeDefinition DIR_CONTEXT;
    static final SimpleAttributeDefinition DIRECT_VERIFICATION;
    private static final AttributeDefinition[] ATTRIBUTES;
    private static final AbstractAddStepHandler ADD;
    private static final OperationStepHandler REMOVE;
    private static final OperationStepHandler WRITE;

    LdapRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"ldap-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("ldap-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, WRITE);
        }
    }

    static {
        HashMap<String, CredentialMappingObjectDefinition> supported = new HashMap<String, CredentialMappingObjectDefinition>();
        supported.put("user-password-mapper", new UserPasswordCredentialMappingObjectDefinition());
        supported.put("otp-credential-mapper", new OtpCredentialMappingObjectDefinition());
        SUPPORTED_CREDENTIAL_MAPPERS = Collections.unmodifiableMap(supported);
        DIR_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("dir-context", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.dir-context", "org.wildfly.security.security-realm", true)).build();
        DIRECT_VERIFICATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("direct-verification", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        ATTRIBUTES = new AttributeDefinition[]{IdentityMappingObjectDefinition.OBJECT_DEFINITION, DIR_CONTEXT, DIRECT_VERIFICATION};
        ADD = new RealmAddHandler();
        REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
        WRITE = new WriteAttributeHandler();
    }

    private static class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("ldap-realm", ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName();
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(new HashSet<RuntimeCapability>(Arrays.asList(Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY)), ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            ServiceName mainServiceName = Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            ServiceName aliasServiceName = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            LdapSecurityRealmBuilder builder = LdapSecurityRealmBuilder.builder();
            if (DIRECT_VERIFICATION.resolveModelAttribute(context, model).asBoolean()) {
                builder.addDirectEvidenceVerification();
            }
            TrivialService<SecurityRealm> ldapRealmService = new TrivialService<SecurityRealm>(() -> ((LdapSecurityRealmBuilder)builder).build());
            ServiceBuilder serviceBuilder = serviceTarget.addService(mainServiceName, ldapRealmService).addAliases(new ServiceName[]{aliasServiceName});
            ElytronDefinition.commonDependencies(serviceBuilder);
            this.configureIdentityMapping(context, model, builder);
            this.configureDirContext(context, model, builder, (ServiceBuilder<SecurityRealm>)serviceBuilder);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private void configureDirContext(OperationContext context, ModelNode model, LdapSecurityRealmBuilder realmBuilder, ServiceBuilder<SecurityRealm> serviceBuilder) throws OperationFailedException {
            String dirContextName = ElytronExtension.asStringIfDefined(context, DIR_CONTEXT, model);
            String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.dir-context", (String)dirContextName);
            ServiceName dirContextServiceName = context.getCapabilityServiceName(runtimeCapability, ExceptionSupplier.class);
            InjectedValue dirContextInjector = new InjectedValue();
            serviceBuilder.addDependency(dirContextServiceName, ExceptionSupplier.class, (Injector)dirContextInjector);
            realmBuilder.setDirContextSupplier(() -> {
                ExceptionSupplier supplier = (ExceptionSupplier)dirContextInjector.getValue();
                return (DirContext)supplier.get();
            });
        }

        private void configureIdentityMapping(OperationContext context, ModelNode model, LdapSecurityRealmBuilder builder) throws OperationFailedException {
            ModelNode newIdentityAttributesNode;
            ModelNode newIdentityParentDnNode;
            ModelNode modelNode;
            ModelNode useRecursiveSearchNode;
            ModelNode principalMappingNode = IdentityMappingObjectDefinition.OBJECT_DEFINITION.resolveModelAttribute(context, model);
            LdapSecurityRealmBuilder.IdentityMappingBuilder identityMappingBuilder = builder.identityMapping();
            ModelNode nameAttributeNode = IdentityMappingObjectDefinition.RDN_IDENTIFIER.resolveModelAttribute(context, principalMappingNode);
            identityMappingBuilder.setRdnIdentifier(nameAttributeNode.asString());
            ModelNode searchDnNode = IdentityMappingObjectDefinition.SEARCH_BASE_DN.resolveModelAttribute(context, principalMappingNode);
            if (searchDnNode.isDefined()) {
                identityMappingBuilder.setSearchDn(searchDnNode.asString());
            }
            if ((useRecursiveSearchNode = IdentityMappingObjectDefinition.USE_RECURSIVE_SEARCH.resolveModelAttribute(context, principalMappingNode)).asBoolean()) {
                identityMappingBuilder.searchRecursive();
            }
            for (Map.Entry<String, CredentialMappingObjectDefinition> entry : SUPPORTED_CREDENTIAL_MAPPERS.entrySet()) {
                ModelNode node = model.get("identity-mapping").get(entry.getKey());
                entry.getValue().configure(builder, node);
            }
            ModelNode attributeMappingNode = IdentityMappingObjectDefinition.ATTRIBUTE_MAPPINGS.resolveModelAttribute(context, principalMappingNode);
            if (attributeMappingNode.isDefined()) {
                for (ModelNode attributeNode : attributeMappingNode.asList()) {
                    ModelNode asRdnNode;
                    ModelNode fromNode = AttributeMappingObjectDefinition.FROM.resolveModelAttribute(context, attributeNode);
                    ModelNode filterNode = AttributeMappingObjectDefinition.FILTER.resolveModelAttribute(context, attributeNode);
                    ModelNode filterBaseDnNode = AttributeMappingObjectDefinition.FILTER_BASE_DN.resolveModelAttribute(context, attributeNode);
                    AttributeMapping attribute = filterBaseDnNode.isDefined() ? AttributeMapping.fromFilter((String)filterBaseDnNode.asString(), (String)filterNode.asString(), (String)fromNode.asString()) : (filterNode.isDefined() ? AttributeMapping.fromFilter((String)filterNode.asString(), (String)fromNode.asString()) : AttributeMapping.from((String)fromNode.asString()));
                    ModelNode toNode = AttributeMappingObjectDefinition.TO.resolveModelAttribute(context, attributeNode);
                    if (toNode.isDefined()) {
                        attribute.to(toNode.asString());
                    }
                    if ((asRdnNode = AttributeMappingObjectDefinition.AS_RDN.resolveModelAttribute(context, attributeNode)).isDefined()) {
                        attribute.asRdn(asRdnNode.asString());
                    }
                    identityMappingBuilder.map(new AttributeMapping[]{attribute});
                }
            }
            if ((modelNode = IdentityMappingObjectDefinition.ITERATOR_FILTER.resolveModelAttribute(context, principalMappingNode)).isDefined()) {
                identityMappingBuilder.setIteratorFilter(modelNode.asString());
            }
            if ((newIdentityParentDnNode = IdentityMappingObjectDefinition.NEW_IDENTITY_PARENT_DN.resolveModelAttribute(context, principalMappingNode)).isDefined()) {
                try {
                    identityMappingBuilder.setNewIdentityParent(new LdapName(newIdentityParentDnNode.asString()));
                }
                catch (InvalidNameException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
            if ((newIdentityAttributesNode = IdentityMappingObjectDefinition.NEW_IDENTITY_ATTRIBUTES.resolveModelAttribute(context, principalMappingNode)).isDefined()) {
                BasicAttributes attributes = new BasicAttributes(true);
                for (ModelNode attributeNode : newIdentityAttributesNode.asList()) {
                    ModelNode nameNode = NewIdentityAttributeObjectDefinition.NAME.resolveModelAttribute(context, attributeNode);
                    ModelNode valuesNode = NewIdentityAttributeObjectDefinition.VALUE.resolveModelAttribute(context, attributeNode);
                    if (valuesNode.getType() == ModelType.LIST) {
                        BasicAttribute objectClass = new BasicAttribute(nameNode.asString());
                        for (ModelNode valueNode : valuesNode.asList()) {
                            objectClass.add(valueNode.asString());
                        }
                        attributes.put(objectClass);
                        continue;
                    }
                    attributes.put(new BasicAttribute(nameNode.asString(), valuesNode.asString()));
                }
                identityMappingBuilder.setNewIdentityAttributes((Attributes)attributes);
            }
            identityMappingBuilder.build();
        }
    }

    static class IdentityMappingObjectDefinition {
        static final SimpleAttributeDefinition RDN_IDENTIFIER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rdn-identifier", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition USE_RECURSIVE_SEARCH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-recursive-search", ModelType.BOOLEAN, false).setRequires(new String[]{"search-base-dn"})).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SEARCH_BASE_DN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-base-dn", ModelType.STRING, true).setRequires(new String[]{"rdn-identifier"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectListAttributeDefinition ATTRIBUTE_MAPPINGS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("attribute-mapping", AttributeMappingObjectDefinition.OBJECT_DEFINITION).setAllowNull(true).setAttributeGroup("attribute")).setAllowDuplicates(true)).build();
        static final ObjectListAttributeDefinition NEW_IDENTITY_ATTRIBUTES = ((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("new-identity-attributes", NewIdentityAttributeObjectDefinition.OBJECT_DEFINITION).setAllowNull(true).setAllowDuplicates(true)).build();
        static final SimpleAttributeDefinition ITERATOR_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("iterator-filter", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition NEW_IDENTITY_PARENT_DN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("new-identity-parent-dn", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RDN_IDENTIFIER, USE_RECURSIVE_SEARCH, SEARCH_BASE_DN, ATTRIBUTE_MAPPINGS, ITERATOR_FILTER, NEW_IDENTITY_PARENT_DN, NEW_IDENTITY_ATTRIBUTES};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("identity-mapping", new AttributeDefinition[]{RDN_IDENTIFIER, USE_RECURSIVE_SEARCH, SEARCH_BASE_DN, ATTRIBUTE_MAPPINGS, ITERATOR_FILTER, NEW_IDENTITY_PARENT_DN, NEW_IDENTITY_ATTRIBUTES, UserPasswordCredentialMappingObjectDefinition.OBJECT_DEFINITION, OtpCredentialMappingObjectDefinition.OBJECT_DEFINITION}).setAllowNull(false).build();

        IdentityMappingObjectDefinition() {
        }
    }

    static class NewIdentityAttributeObjectDefinition {
        static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final StringListAttributeDefinition VALUE = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("value").setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{NAME, VALUE};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("attribute", ATTRIBUTES).setAllowNull(true).build();

        NewIdentityAttributeObjectDefinition() {
        }
    }

    static class OtpCredentialMappingObjectDefinition
    implements CredentialMappingObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm-from", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition HASH_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-from", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SEED_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("seed-from", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SEQUENCE_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sequence-from", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{ALGORITHM_FROM, HASH_FROM, SEED_FROM, SEQUENCE_FROM};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("otp-credential-mapper", (AttributeDefinition[])ATTRIBUTES).setAllowNull(true).build();

        OtpCredentialMappingObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return ATTRIBUTES;
        }

        @Override
        public void configure(LdapSecurityRealmBuilder builder, ModelNode node) {
            String algorithmFrom = node.get("algorithm-from").asString();
            String hashFrom = node.get("hash-from").asString();
            String seedFrom = node.get("seed-from").asString();
            String sequenceFrom = node.get("sequence-from").asString();
            LdapSecurityRealmBuilder.OtpCredentialLoaderBuilder b = builder.otpCredentialLoader();
            if (algorithmFrom != null) {
                b.setOtpAlgorithmAttribute(algorithmFrom);
            }
            if (hashFrom != null) {
                b.setOtpHashAttribute(hashFrom);
            }
            if (seedFrom != null) {
                b.setOtpSeedAttribute(seedFrom);
            }
            if (sequenceFrom != null) {
                b.setOtpSequenceAttribute(sequenceFrom);
            }
            b.build();
        }
    }

    static class UserPasswordCredentialMappingObjectDefinition
    implements CredentialMappingObjectDefinition {
        static final SimpleAttributeDefinition FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("from", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition WRITABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("writable", ModelType.BOOLEAN, false).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition VERIFIABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("verifiable", ModelType.BOOLEAN, false).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{FROM, WRITABLE, VERIFIABLE};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("user-password-mapper", (AttributeDefinition[])ATTRIBUTES).setAllowNull(true).build();

        UserPasswordCredentialMappingObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return ATTRIBUTES;
        }

        @Override
        public void configure(LdapSecurityRealmBuilder builder, ModelNode node) {
            String from = node.get("from").asString();
            boolean writable = node.get("writable").asBoolean();
            boolean verifiable = node.get("verifiable").asBoolean();
            LdapSecurityRealmBuilder.UserPasswordCredentialLoaderBuilder b = builder.userPasswordCredentialLoader();
            if (from != null) {
                b.setUserPasswordAttribute(from);
            }
            if (writable) {
                b.enablePersistence();
            }
            if (!verifiable) {
                b.disableVerification();
            }
            b.build();
        }
    }

    static interface CredentialMappingObjectDefinition {
        public ObjectTypeAttributeDefinition getObjectDefinition();

        public SimpleAttributeDefinition[] getAttributes();

        public void configure(LdapSecurityRealmBuilder var1, ModelNode var2);
    }

    static class AttributeMappingObjectDefinition {
        static final SimpleAttributeDefinition FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("from", ModelType.STRING, false).setAlternatives(new String[]{"filter"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("to", ModelType.STRING, true).setRequires(new String[]{"from"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter", ModelType.STRING, true).setRequires(new String[]{"to"})).setAlternatives(new String[]{"from"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition FILTER_BASE_DN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-base-dn", ModelType.STRING, true).setRequires(new String[]{"filter"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition AS_RDN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("as-rdn", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{FROM, TO, FILTER, FILTER_BASE_DN, AS_RDN};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("attribute", (AttributeDefinition[])ATTRIBUTES).setAllowNull(true).build();

        AttributeMappingObjectDefinition() {
        }
    }
}

