/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class ProviderLoaderService
implements Service<Provider[]> {
    private final boolean register;
    private final ProviderConfig[] providerConfig;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final List<PathManager.Callback.Handle> callbackHandles = new ArrayList<PathManager.Callback.Handle>();
    private volatile Provider[] providers;

    private ProviderLoaderService(boolean register, ProviderConfig[] providerConfig) {
        this.register = register;
        this.providerConfig = providerConfig;
    }

    public void start(StartContext context) throws StartException {
        try {
            ArrayList<Provider> providerList = new ArrayList<Provider>();
            for (ProviderConfig currentConfig : this.providerConfig) {
                providerList.addAll(this.loadProviders(currentConfig));
            }
            Provider[] providers = providerList.toArray(new Provider[providerList.size()]);
            if (this.register) {
                SecurityActions.doPrivileged(() -> {
                    this.registerProviders(providers);
                    return null;
                });
            }
            this.providers = providers;
        }
        catch (Exception e) {
            this.clearCallbacks();
            if (e instanceof StartException) {
                throw (StartException)e;
            }
            if (e.getCause() instanceof StartException) {
                throw (StartException)e.getCause();
            }
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    private List<Provider> loadProviders(ProviderConfig config) throws Exception {
        Supplier<InputStream> configurationStreamSupplier;
        ClassLoader classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(config.getModule()));
        ArrayList<Provider> providers = new ArrayList<Provider>();
        HashSet discovered = new HashSet();
        if (config.loadServices()) {
            ServiceLoader<Provider> loader = ServiceLoader.load(Provider.class, classLoader);
            loader.iterator().forEachRemaining(p -> {
                providers.add((Provider)p);
                discovered.add(p.getClass().getName());
            });
        }
        if ((configurationStreamSupplier = this.getConfigurationSupplier(config)) != null) {
            for (Provider p2 : providers) {
                InputStream is = configurationStreamSupplier.get();
                Throwable throwable = null;
                try {
                    p2.load(is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        for (String className : config.getClassNames()) {
            if (discovered.contains(className)) continue;
            Class<Provider> providerClazz = classLoader.loadClass(className).asSubclass(Provider.class);
            Provider provider = null;
            if (configurationStreamSupplier != null) {
                Constructor<?>[] constructors = providerClazz.getConstructors();
                for (Constructor<?> current : constructors) {
                    Class<?>[] parameterTypes = current.getParameterTypes();
                    if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(InputStream.class)) continue;
                    try (InputStream is = configurationStreamSupplier.get();){
                        provider = (Provider)current.newInstance(configurationStreamSupplier.get());
                        break;
                    }
                }
            }
            if (provider == null) {
                provider = providerClazz.newInstance();
                if (configurationStreamSupplier != null) {
                    InputStream is = configurationStreamSupplier.get();
                    Object object = null;
                    try {
                        provider.load(configurationStreamSupplier.get());
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (object != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
            }
            providers.add(provider);
        }
        return providers;
    }

    private void registerProviders(Provider[] providers) throws StartException {
        for (int i = 0; i < providers.length; ++i) {
            if (Security.addProvider(providers[i]) >= 0) continue;
            for (int j = i - 1; j > 0; --j) {
                Security.removeProvider(providers[j].getName());
            }
            throw ElytronSubsystemMessages.ROOT_LOGGER.providerAlreadyRegistered(providers[i].getName());
        }
    }

    private static InputStream toInputStream(File file) {
        try {
            SecurityActions.doPrivileged(() -> new FileInputStream(file));
            return new FileInputStream(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Supplier<InputStream> getConfigurationSupplier(ProviderConfig config) {
        if (config.getPath() != null) {
            File configFile = this.resolveFileLocation(config.getPath(), config.getRelativeTo());
            return () -> ProviderLoaderService.toInputStream(configFile);
        }
        List configurationProperties = config.getPropertyList();
        if (configurationProperties != null) {
            StringBuilder sb = new StringBuilder();
            for (Property current : configurationProperties) {
                sb.append(current.getKey()).append('=').append(current.getValue()).append('\n');
            }
            byte[] configBytes = sb.toString().getBytes(StandardCharsets.UTF_8);
            return () -> new ByteArrayInputStream(configBytes);
        }
        return null;
    }

    private File resolveFileLocation(String path, String relativeTo) {
        File resolvedPath;
        if (relativeTo != null) {
            PathManager pathManager = (PathManager)this.pathManager.getValue();
            resolvedPath = new File(pathManager.resolveRelativePathEntry(path, relativeTo));
            this.callbackHandles.add(pathManager.registerCallback(relativeTo, new PathManager.Callback(){

                public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                    if (!eventContext.isResourceServiceRestartAllowed()) {
                        eventContext.reloadRequired();
                    }
                }

                public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                }
            }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED}));
        } else {
            resolvedPath = new File(path);
        }
        return resolvedPath;
    }

    private void clearCallbacks() {
        while (!this.callbackHandles.isEmpty()) {
            this.callbackHandles.remove(0).remove();
        }
    }

    public void stop(StopContext context) {
        if (this.register) {
            SecurityActions.doPrivileged(() -> {
                this.unregisterProviders();
                return null;
            });
        }
        this.clearCallbacks();
        this.providers = null;
    }

    private void unregisterProviders() {
        for (int i = this.providers.length - 1; i < 0; --i) {
            Security.removeProvider(this.providers[i].getName());
        }
    }

    Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }

    public Provider[] getValue() throws IllegalStateException, IllegalArgumentException {
        return this.providers == null ? null : (Provider[])this.providers.clone();
    }

    static ProviderLoaderServiceBuilder builder() {
        return new ProviderLoaderServiceBuilder();
    }

    static class PropertyListBuilder {
        private final ProviderConfigBuilder configBuilder;
        private final List<Property> propertyList = new ArrayList<Property>();

        private PropertyListBuilder(ProviderConfigBuilder configBuilder) {
            this.configBuilder = configBuilder;
        }

        PropertyListBuilder add(String key, String value) {
            this.propertyList.add(new Property(key, value));
            return this;
        }

        ProviderConfigBuilder build() {
            return this.configBuilder.setPropertyList(Collections.unmodifiableList(this.propertyList));
        }
    }

    static class ProviderConfigBuilder {
        private final ProviderLoaderServiceBuilder serviceBuilder;
        private String module;
        private boolean loadServices;
        private String[] classNames;
        private String path;
        private String relativeTo;
        private List<Property> propertyList;

        private ProviderConfigBuilder(ProviderLoaderServiceBuilder serviceBuilder) {
            this.serviceBuilder = serviceBuilder;
        }

        ProviderConfigBuilder setModule(String module) {
            this.module = module;
            return this;
        }

        ProviderConfigBuilder setLoadServices(boolean loadServices) {
            this.loadServices = loadServices;
            return this;
        }

        ProviderConfigBuilder setClassNames(String[] classNames) {
            this.classNames = classNames == null ? new String[]{} : (String[])classNames.clone();
            return this;
        }

        ProviderConfigBuilder setPath(String path) {
            this.path = path;
            return this;
        }

        ProviderConfigBuilder setRelativeTo(String relativeTo) {
            this.relativeTo = relativeTo;
            return this;
        }

        PropertyListBuilder addPropertyList() {
            return new PropertyListBuilder(this);
        }

        private ProviderConfigBuilder setPropertyList(List<Property> propertyList) {
            this.propertyList = propertyList;
            return this;
        }

        ProviderLoaderServiceBuilder build() {
            this.serviceBuilder.add(new ProviderConfig(this.module, this.loadServices, this.classNames, this.path, this.relativeTo, this.propertyList));
            return this.serviceBuilder;
        }
    }

    static class ProviderLoaderServiceBuilder {
        private boolean register = false;
        private ArrayList<ProviderConfig> providerConfig = new ArrayList();

        private ProviderLoaderServiceBuilder() {
        }

        ProviderLoaderServiceBuilder setRegister(boolean register) {
            this.register = register;
            return this;
        }

        ProviderConfigBuilder addProviderConfig() {
            return new ProviderConfigBuilder(this);
        }

        private void add(ProviderConfig config) {
            this.providerConfig.add(config);
        }

        ProviderLoaderService build() {
            return new ProviderLoaderService(this.register, this.providerConfig.toArray(new ProviderConfig[this.providerConfig.size()]));
        }
    }

    private static class ProviderConfig {
        private final String module;
        private final boolean loadServices;
        private final String[] classNames;
        private final String path;
        private final String relativeTo;
        private final List<Property> propertyList;

        private ProviderConfig(String module, boolean loadServices, String[] classNames, String path, String relativeTo, List<Property> propertyList) {
            this.module = module;
            this.loadServices = loadServices;
            this.classNames = classNames;
            this.path = path;
            this.relativeTo = relativeTo;
            this.propertyList = propertyList;
        }

        private String getModule() {
            return this.module;
        }

        private boolean loadServices() {
            return this.loadServices;
        }

        private String[] getClassNames() {
            return this.classNames;
        }

        private String getPath() {
            return this.path;
        }

        private String getRelativeTo() {
            return this.relativeTo;
        }

        private List<Property> getPropertyList() {
            return this.propertyList;
        }
    }

    private static class Property {
        private final String key;
        private final String value;

        private Property(String key, String value) {
            this.key = key;
            this.value = value;
        }

        private String getKey() {
            return this.key;
        }

        private String getValue() {
            return this.value;
        }
    }
}

