/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.KeyStoreDefinition;
import org.wildfly.extension.elytron.SSLDefinitions;

class TlsParser {
    TlsParser() {
    }

    void readTls(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean keyManagersFound = false;
        boolean keyStoresFound = false;
        boolean trustManagersFound = false;
        boolean serverSSLContextsFound = false;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("key-managers".equals(localName) && !keyManagersFound) {
                keyManagersFound = true;
                this.readKeyManagers(parentAddress, reader, operations);
                continue;
            }
            if ("key-stores".equals(localName) && !keyStoresFound) {
                keyStoresFound = true;
                this.readKeyStores(parentAddress, reader, operations);
                continue;
            }
            if ("trust-managers".equals(localName) && !trustManagersFound) {
                trustManagersFound = true;
                this.readTrustManagers(parentAddress, reader, operations);
                continue;
            }
            if ("server-ssl-contexts".equals(localName) && !serverSSLContextsFound) {
                serverSSLContextsFound = true;
                this.readServerSSLContexts(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readKeyManagers(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("key-manager".equals(localName)) {
                this.readKeyManager(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readKeyManager(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addKeyManager = new ModelNode();
        addKeyManager.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "algorithm"));
        String name = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block14;
                }
                case "algorithm": {
                    SSLDefinitions.ALGORITHM.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block14;
                }
                case "key-store": {
                    SSLDefinitions.KEYSTORE.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block14;
                }
                case "provider": {
                    SSLDefinitions.PROVIDER_LOADER.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block14;
                }
                case "password": {
                    SSLDefinitions.PASSWORD.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addKeyManager.get("address").set(parentAddress).add("key-managers", name);
        list.add(addKeyManager);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readTrustManagers(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("trust-manager".equals(localName)) {
                this.readTrustManager(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readTrustManager(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addKeyManager = new ModelNode();
        addKeyManager.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "algorithm"));
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block12;
                }
                case "algorithm": {
                    SSLDefinitions.ALGORITHM.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block12;
                }
                case "key-store": {
                    SSLDefinitions.KEYSTORE.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block12;
                }
                case "provider": {
                    SSLDefinitions.PROVIDER_LOADER.parseAndSetParameter(value, addKeyManager, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addKeyManager.get("address").set(parentAddress).add("trust-managers", name);
        list.add(addKeyManager);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readServerSSLContexts(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("server-ssl-context".equals(localName)) {
                this.readServerSSLContext(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readServerSSLContext(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addServerSSLContext = new ModelNode();
        addServerSSLContext.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name"));
        String name = null;
        int count = reader.getAttributeCount();
        block28: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block28;
                }
                case "security-domain": {
                    SSLDefinitions.SECURITY_DOMAIN.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                case "cipher-suite-filter": {
                    SSLDefinitions.CIPHER_SUITE_FILTER.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                case "protocols": {
                    for (String protocol : reader.getListAttributeValue(i)) {
                        SSLDefinitions.PROTOCOLS.parseAndAddParameterElement(protocol, addServerSSLContext, (XMLStreamReader)reader);
                    }
                    continue block28;
                }
                case "want-client-auth": {
                    SSLDefinitions.WANT_CLIENT_AUTH.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                case "need-client-auth": {
                    SSLDefinitions.NEED_CLIENT_AUTH.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                case "authentication-optional": {
                    SSLDefinitions.AUTHENTICATION_OPTIONAL.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                case "maximum-session-cache-size": {
                    SSLDefinitions.MAXIMUM_SESSION_CACHE_SIZE.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                case "session-timeout": {
                    SSLDefinitions.SESSION_TIMEOUT.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                case "key-managers": {
                    SSLDefinitions.KEY_MANAGERS.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                case "trust-managers": {
                    SSLDefinitions.TRUST_MANAGERS.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                case "provider": {
                    SSLDefinitions.PROVIDER_LOADER.parseAndSetParameter(value, addServerSSLContext, (XMLStreamReader)reader);
                    continue block28;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addServerSSLContext.get("address").set(parentAddress).add("server-ssl-context", name);
        list.add(addServerSSLContext);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readKeyStores(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("key-store".equals(localName)) {
                this.readKeyStore(parentAddress, reader, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readKeyStore(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addKeyStore = new ModelNode();
        addKeyStore.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "type"));
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "type": {
                    KeyStoreDefinition.TYPE.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                case "provider": {
                    KeyStoreDefinition.PROVIDER.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                case "provider-loader": {
                    KeyStoreDefinition.PROVIDER_LOADER.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                case "password": {
                    KeyStoreDefinition.PASSWORD.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                case "alias-filter": {
                    KeyStoreDefinition.ALIAS_FILTER.parseAndSetParameter(value, addKeyStore, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addKeyStore.get("address").set(parentAddress).add("key-store", name);
        list.add(addKeyStore);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("file".equals(localName)) {
                this.readFile(addKeyStore, reader, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readFile(ModelNode addOp, XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        boolean pathFound = false;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "relative-to": {
                    FileAttributeDefinitions.RELATIVE_TO.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case "path": {
                    pathFound = true;
                    FileAttributeDefinitions.PATH.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case "required": {
                    KeyStoreDefinition.REQUIRED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!pathFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"path"});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void startTLS(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("tls");
        }
    }

    void writeTLS(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean tlsStarted = false;
        tlsStarted |= this.writeKeyStores(tlsStarted, subsystem, writer);
        tlsStarted |= this.writeKeyManagers(tlsStarted, subsystem, writer);
        tlsStarted |= this.writeTrustManagers(tlsStarted, subsystem, writer);
        if (tlsStarted |= this.writeServerSSLContext(tlsStarted, subsystem, writer)) {
            writer.writeEndElement();
        }
    }

    private boolean writeKeyManagers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("key-managers")) {
            this.startTLS(started, writer);
            writer.writeStartElement("key-managers");
            ModelNode keyManagers = subsystem.require("key-managers");
            for (String name : keyManagers.keys()) {
                ModelNode keyManager = keyManagers.require(name);
                writer.writeStartElement("key-manager");
                writer.writeAttribute("name", name);
                SSLDefinitions.ALGORITHM.marshallAsAttribute(keyManager, (XMLStreamWriter)writer);
                SSLDefinitions.KEYSTORE.marshallAsAttribute(keyManager, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDER_LOADER.marshallAsAttribute(keyManager, (XMLStreamWriter)writer);
                SSLDefinitions.PASSWORD.marshallAsAttribute(keyManager, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeTrustManagers(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("trust-managers")) {
            this.startTLS(started, writer);
            writer.writeStartElement("trust-managers");
            ModelNode trustManagers = subsystem.require("trust-managers");
            for (String name : trustManagers.keys()) {
                ModelNode trustManager = trustManagers.require(name);
                writer.writeStartElement("trust-manager");
                writer.writeAttribute("name", name);
                SSLDefinitions.ALGORITHM.marshallAsAttribute(trustManager, (XMLStreamWriter)writer);
                SSLDefinitions.KEYSTORE.marshallAsAttribute(trustManager, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDER_LOADER.marshallAsAttribute(trustManager, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeServerSSLContext(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("server-ssl-context")) {
            this.startTLS(started, writer);
            writer.writeStartElement("server-ssl-contexts");
            ModelNode serverSSLContexts = subsystem.require("server-ssl-context");
            for (String name : serverSSLContexts.keys()) {
                ModelNode serverSSLContext = serverSSLContexts.require(name);
                writer.writeStartElement("server-ssl-context");
                writer.writeAttribute("name", name);
                SSLDefinitions.SECURITY_DOMAIN.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.CIPHER_SUITE_FILTER.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.PROTOCOLS.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)SSLDefinitions.PROTOCOLS, serverSSLContext, false, (XMLStreamWriter)writer);
                SSLDefinitions.WANT_CLIENT_AUTH.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.NEED_CLIENT_AUTH.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.AUTHENTICATION_OPTIONAL.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.MAXIMUM_SESSION_CACHE_SIZE.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.SESSION_TIMEOUT.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.KEY_MANAGERS.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.TRUST_MANAGERS.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                SSLDefinitions.PROVIDER_LOADER.marshallAsAttribute(serverSSLContext, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeKeyStores(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("key-store")) {
            this.startTLS(started, writer);
            writer.writeStartElement("key-stores");
            ModelNode keystores = subsystem.require("key-store");
            for (String name : keystores.keys()) {
                ModelNode keyStore = keystores.require(name);
                writer.writeStartElement("key-store");
                writer.writeAttribute("name", name);
                KeyStoreDefinition.TYPE.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                KeyStoreDefinition.PROVIDER.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                KeyStoreDefinition.PROVIDER_LOADER.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                KeyStoreDefinition.PASSWORD.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                KeyStoreDefinition.ALIAS_FILTER.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                if (keyStore.hasDefined("path")) {
                    writer.writeStartElement("file");
                    FileAttributeDefinitions.RELATIVE_TO.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    FileAttributeDefinitions.PATH.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    KeyStoreDefinition.REQUIRED.marshallAsAttribute(keyStore, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }
}

