/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.CredentialStoreResourceDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemParser;

class CredentialStoreParser {
    CredentialStoreParser() {
    }

    void readCredentialStores(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "credential-store": {
                    this.readCredentialStore(parentAddress, reader, operations);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readCredentialStore(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        String value;
        ModelNode addCredentialStore = new ModelNode();
        addCredentialStore.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name"));
        String name = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block14;
                }
                case "type": {
                    CredentialStoreResourceDefinition.TYPE.parseAndSetParameter(value, addCredentialStore, (XMLStreamReader)reader);
                    continue block14;
                }
                case "provider-name": {
                    CredentialStoreResourceDefinition.PROVIDER_NAME.parseAndSetParameter(value, addCredentialStore, (XMLStreamReader)reader);
                    continue block14;
                }
                case "providers": {
                    CredentialStoreResourceDefinition.PROVIDERS.parseAndSetParameter(value, addCredentialStore, (XMLStreamReader)reader);
                    continue block14;
                }
                case "relative-to": {
                    CredentialStoreResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, addCredentialStore, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addCredentialStore.get("address").set(parentAddress).add("credential-store", name);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("uri".equals(localName)) {
                value = reader.getElementText();
                CredentialStoreResourceDefinition.URI.parseAndSetParameter(value, addCredentialStore, (XMLStreamReader)reader);
                continue;
            }
            if (CredentialStoreResourceDefinition.CREDENTIAL_REFERENCE.getXmlName().equals(localName)) {
                AttributeParser ap = CredentialStoreResourceDefinition.CREDENTIAL_REFERENCE.getParser();
                ap.parseElement((AttributeDefinition)CredentialStoreResourceDefinition.CREDENTIAL_REFERENCE, reader, addCredentialStore);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(addCredentialStore);
    }

    void writeCredentialStores(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("credential-store")) {
            writer.writeStartElement("credential-stores");
            ModelNode credentialStores = subsystem.require("credential-store");
            for (String name : credentialStores.keys()) {
                ModelNode credentialStoreModelNode = credentialStores.require(name);
                writer.writeStartElement("credential-store");
                writer.writeAttribute("name", name);
                CredentialStoreResourceDefinition.TYPE.marshallAsAttribute(credentialStoreModelNode, (XMLStreamWriter)writer);
                CredentialStoreResourceDefinition.PROVIDER_NAME.marshallAsAttribute(credentialStoreModelNode, (XMLStreamWriter)writer);
                CredentialStoreResourceDefinition.PROVIDERS.marshallAsAttribute(credentialStoreModelNode, (XMLStreamWriter)writer);
                CredentialStoreResourceDefinition.RELATIVE_TO.marshallAsAttribute(credentialStoreModelNode, (XMLStreamWriter)writer);
                CredentialStoreResourceDefinition.URI.marshallAsElement(credentialStoreModelNode, (XMLStreamWriter)writer);
                if (credentialStoreModelNode.hasDefined(CredentialStoreResourceDefinition.CREDENTIAL_REFERENCE.getName())) {
                    CredentialStoreResourceDefinition.CREDENTIAL_REFERENCE.marshallAsElement(credentialStoreModelNode, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

