/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities.DirContextSupplier;
import org.wildfly.security.keystore.LdapKeyStore;
import org.wildfly.security.keystore.UnmodifiableKeyStore;

class LdapKeyStoreService
implements ModifiableKeyStoreService {
    private final InjectedValue<DirContextSupplier> dirContextSupplierInjector = new InjectedValue();
    private final String searchPath;
    private final String filterAlias;
    private final String filterCertificate;
    private final String filterIterate;
    private final LdapName createPath;
    private final String createRdn;
    private final Attributes createAttributes;
    private final String aliasAttribute;
    private final String certificateAttribute;
    private final String certificateType;
    private final String certificateChainAttribute;
    private final String certificateChainEncoding;
    private final String keyAttribute;
    private final String keyType;
    private volatile KeyStore modifiableKeyStore = null;
    private volatile KeyStore unmodifiableKeyStore = null;

    LdapKeyStoreService(String searchPath, String filterAlias, String filterCertificate, String filterIterate, LdapName createPath, String createRdn, Attributes createAttributes, String aliasAttribute, String certificateAttribute, String certificateType, String certificateChainAttribute, String certificateChainEncoding, String keyAttribute, String keyType) {
        this.searchPath = searchPath;
        this.filterAlias = filterAlias;
        this.filterCertificate = filterCertificate;
        this.filterIterate = filterIterate;
        this.createPath = createPath;
        this.createRdn = createRdn;
        this.createAttributes = createAttributes;
        this.aliasAttribute = aliasAttribute;
        this.certificateAttribute = certificateAttribute;
        this.certificateType = certificateType;
        this.certificateChainAttribute = certificateChainAttribute;
        this.certificateChainEncoding = certificateChainEncoding;
        this.keyAttribute = keyAttribute;
        this.keyType = keyType;
    }

    Injector<DirContextSupplier> getDirContextSupplierInjector() {
        return this.dirContextSupplierInjector;
    }

    public void start(StartContext startContext) throws StartException {
        try {
            LdapKeyStore.Builder builder = LdapKeyStore.builder().setDirContextSupplier((ExceptionSupplier)this.dirContextSupplierInjector.getValue()).setSearchPath(this.searchPath);
            if (this.filterAlias != null) {
                builder.setFilterAlias(this.filterAlias);
            }
            if (this.filterCertificate != null) {
                builder.setFilterCertificate(this.filterCertificate);
            }
            if (this.filterIterate != null) {
                builder.setFilterIterate(this.filterIterate);
            }
            if (this.createPath != null) {
                builder.setCreatePath(this.createPath);
            }
            if (this.createRdn != null) {
                builder.setCreateRdn(this.createRdn);
            }
            if (this.createAttributes != null) {
                builder.setCreateAttributes(this.createAttributes);
            }
            if (this.aliasAttribute != null) {
                builder.setAliasAttribute(this.aliasAttribute);
            }
            if (this.certificateAttribute != null) {
                builder.setCertificateAttribute(this.certificateAttribute);
            }
            if (this.certificateType != null) {
                builder.setCertificateType(this.certificateType);
            }
            if (this.certificateChainAttribute != null) {
                builder.setCertificateChainAttribute(this.certificateChainAttribute);
            }
            if (this.certificateChainEncoding != null) {
                builder.setCertificateChainEncoding(this.certificateChainEncoding);
            }
            if (this.keyAttribute != null) {
                builder.setKeyAttribute(this.keyAttribute);
            }
            if (this.keyType != null) {
                builder.setKeyType(this.keyType);
            }
            LdapKeyStore keyStore = builder.build();
            keyStore.load(null);
            this.modifiableKeyStore = keyStore;
            this.unmodifiableKeyStore = UnmodifiableKeyStore.unmodifiableKeyStore((KeyStore)keyStore);
        }
        catch (IOException | GeneralSecurityException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    public void stop(StopContext stopContext) {
        this.modifiableKeyStore = null;
        this.unmodifiableKeyStore = null;
    }

    public KeyStore getValue() throws IllegalStateException, IllegalArgumentException {
        return this.unmodifiableKeyStore;
    }

    @Override
    public KeyStore getModifiableValue() {
        return this.modifiableKeyStore;
    }
}

