/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AggregateRealmDefinition;
import org.wildfly.extension.elytron.CachingRealmDefinition;
import org.wildfly.extension.elytron.CustomComponentDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.FileSystemRealmDefinition;
import org.wildfly.extension.elytron.JdbcRealmDefinition;
import org.wildfly.extension.elytron.KeyStoreRealmDefinition;
import org.wildfly.extension.elytron.LdapRealmDefinition;
import org.wildfly.extension.elytron.PropertiesRealmDefinition;
import org.wildfly.extension.elytron.RealmDefinitions;
import org.wildfly.extension.elytron.TokenRealmDefinition;

class RealmParser {
    private final PersistentResourceXMLDescription aggregateRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"aggregate-realm"), null).addAttributes(AggregateRealmDefinition.ATTRIBUTES).build();
    private final PersistentResourceXMLDescription customRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"custom-realm"), null).addAttributes(CustomComponentDefinition.ATTRIBUTES).setUseElementsForGroups(false).build();
    private final PersistentResourceXMLDescription customModifiableRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"custom-modifiable-realm"), null).addAttributes(CustomComponentDefinition.ATTRIBUTES).setUseElementsForGroups(false).build();
    private final PersistentResourceXMLDescription identityRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"identity-realm"), null).addAttributes(RealmDefinitions.IDENTITY_REALM_ATTRIBUTES).setUseElementsForGroups(false).build();
    private final PersistentResourceXMLDescription jdbcRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"jdbc-realm"), null).addAttribute((AttributeDefinition)JdbcRealmDefinition.PrincipalQueryAttributes.PRINCIPAL_QUERIES, AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER, AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER).build();
    private final PersistentResourceXMLDescription keyStoreRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"key-store-realm"), null).addAttributes(new AttributeDefinition[]{KeyStoreRealmDefinition.KEYSTORE}).build();
    private final PersistentResourceXMLDescription propertiesRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"properties-realm"), null).addAttributes(new AttributeDefinition[]{PropertiesRealmDefinition.GROUPS_ATTRIBUTE}).addAttribute((AttributeDefinition)PropertiesRealmDefinition.USERS_PROPERTIES, AttributeParser.OBJECT_PARSER, AttributeMarshaller.ATTRIBUTE_OBJECT).addAttribute((AttributeDefinition)PropertiesRealmDefinition.GROUPS_PROPERTIES, AttributeParser.OBJECT_PARSER, AttributeMarshaller.ATTRIBUTE_OBJECT).build();
    private final PersistentResourceXMLDescription ldapRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"ldap-realm"), null).addAttributes(LdapRealmDefinition.ATTRIBUTES).build();
    private final PersistentResourceXMLDescription fileSystemRealmDescription = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"filesystem-realm"), null).addAttributes(FileSystemRealmDefinition.ATTRIBUTES).setMarshallDefaultValues(true).build();
    private final PersistentResourceXMLDescription tokenRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"token-realm"), null).addAttributes(TokenRealmDefinition.ATTRIBUTES).build();
    private final PersistentResourceXMLDescription cachingRealmParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"caching-realm"), null).addAttributes(CachingRealmDefinition.ATTRIBUTES).build();

    RealmParser() {
    }

    void readRealms(ModelNode parentAddressNode, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block26: while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            PathAddress parentAddress = PathAddress.pathAddress((ModelNode)parentAddressNode);
            switch (localName) {
                case "aggregate-realm": {
                    this.aggregateRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "custom-realm": {
                    this.customRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "custom-modifiable-realm": {
                    this.customModifiableRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "jdbc-realm": {
                    this.jdbcRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "identity-realm": {
                    this.identityRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "key-store-realm": {
                    this.keyStoreRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "properties-realm": {
                    this.propertiesRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "ldap-realm": {
                    this.ldapRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "filesystem-realm": {
                    this.fileSystemRealmDescription.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "token-realm": {
                    this.tokenRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
                case "caching-realm": {
                    this.cachingRealmParser.parse(reader, parentAddress, operations);
                    continue block26;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void writeRealms(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!this.shouldWrite(subsystem)) {
            return;
        }
        writer.writeStartElement("security-realms");
        this.aggregateRealmParser.persist(writer, subsystem);
        this.customRealmParser.persist(writer, subsystem);
        this.customModifiableRealmParser.persist(writer, subsystem);
        this.identityRealmParser.persist(writer, subsystem);
        this.jdbcRealmParser.persist(writer, subsystem);
        this.keyStoreRealmParser.persist(writer, subsystem);
        this.propertiesRealmParser.persist(writer, subsystem);
        this.ldapRealmParser.persist(writer, subsystem);
        this.fileSystemRealmDescription.persist(writer, subsystem);
        this.tokenRealmParser.persist(writer, subsystem);
        this.cachingRealmParser.persist(writer, subsystem);
        writer.writeEndElement();
    }

    private boolean shouldWrite(ModelNode subsystem) {
        return subsystem.hasDefined("aggregate-realm") || subsystem.hasDefined("custom-realm") || subsystem.hasDefined("custom-modifiable-realm") || subsystem.hasDefined("jdbc-realm") || subsystem.hasDefined("identity-realm") || subsystem.hasDefined("key-store-realm") || subsystem.hasDefined("properties-realm") || subsystem.hasDefined("ldap-realm") || subsystem.hasDefined("filesystem-realm") || subsystem.hasDefined("token-realm");
    }
}

