/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.capabilities;

import java.util.function.Consumer;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.event.SecurityEvent;

public interface SecurityEventListener
extends Consumer<SecurityEvent> {
    public static SecurityEventListener from(Consumer<SecurityEvent> consumer) {
        return consumer::accept;
    }

    public static SecurityEventListener aggregate(SecurityEventListener ... listeners) {
        Assert.checkNotNullParam((String)"listeners", (Object)listeners);
        SecurityEventListener[] clone = (SecurityEventListener[])listeners.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam((String)"listener", (int)i, (Object)clone[i]);
        }
        return e -> {
            for (SecurityEventListener sel : clone) {
                sel.accept(e);
            }
        };
    }
}

