/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;

class CredentialStoreResource
extends DelegatingResource {
    private ServiceController<CredentialStore> credentialStoreServiceController;

    CredentialStoreResource(Resource delegate) {
        super(delegate);
    }

    public void setCredentialStoreServiceController(ServiceController<CredentialStore> credentialStoreServiceController) {
        this.credentialStoreServiceController = credentialStoreServiceController;
    }

    public Set<String> getChildTypes() {
        if (this.containsAliases()) {
            return Collections.singleton("alias");
        }
        return Collections.emptySet();
    }

    public boolean hasChildren(String childType) {
        return "alias".equals(childType) && this.containsAliases();
    }

    public boolean hasChild(PathElement element) {
        try {
            if ("alias".equals(element.getKey())) {
                CredentialStore credentialStore;
                CredentialStore credentialStore2 = credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
                return credentialStore != null && credentialStore.getAliases().contains(element.getValue());
            }
        }
        catch (CredentialStoreException e) {
            ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreIssueEncountered((Exception)((Object)e));
        }
        return false;
    }

    public Resource getChild(PathElement element) {
        try {
            if ("alias".equals(element.getKey())) {
                CredentialStore credentialStore;
                CredentialStore credentialStore2 = credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
                if (credentialStore != null && credentialStore.getAliases().contains(element.getValue())) {
                    return Resource.Factory.create((boolean)true);
                }
                return null;
            }
        }
        catch (CredentialStoreException e) {
            ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreIssueEncountered((Exception)((Object)e));
        }
        return null;
    }

    public Resource requireChild(PathElement element) {
        Resource resource = this.getChild(element);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(element);
        }
        return resource;
    }

    public Set<String> getChildrenNames(String childType) {
        try {
            if ("alias".equals(childType)) {
                CredentialStore credentialStore;
                CredentialStore credentialStore2 = credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
                if (credentialStore != null && credentialStore.isInitialized()) {
                    return credentialStore.getAliases();
                }
                return Collections.emptySet();
            }
        }
        catch (CredentialStoreException e) {
            ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreIssueEncountered((Exception)((Object)e));
        }
        return Collections.emptySet();
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        try {
            if ("alias".equals(childType)) {
                CredentialStore credentialStore;
                CredentialStore credentialStore2 = credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
                if (credentialStore != null && credentialStore.isInitialized() && credentialStore.getAliases().size() > 0) {
                    Set aliases = credentialStore.getAliases();
                    LinkedHashSet<Resource.ResourceEntry> children = new LinkedHashSet<Resource.ResourceEntry>(aliases.size());
                    children.addAll(aliases.stream().map(alias -> new PlaceholderResource.PlaceholderResourceEntry("alias", alias)).collect(Collectors.toList()));
                    return children;
                }
                return Collections.emptySet();
            }
        }
        catch (CredentialStoreException e) {
            ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreIssueEncountered((Exception)((Object)e));
        }
        return Collections.emptySet();
    }

    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate((Resource)this, (PathAddress)address);
    }

    public Resource clone() {
        CredentialStoreResource credentialStoreResource = new CredentialStoreResource(super.clone());
        credentialStoreResource.setCredentialStoreServiceController(this.credentialStoreServiceController);
        return credentialStoreResource;
    }

    private boolean containsAliases() {
        try {
            CredentialStore credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
            return credentialStore != null && credentialStore.isInitialized() && credentialStore.getAliases().size() > 0;
        }
        catch (CredentialStoreException e) {
            return false;
        }
    }
}

