/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Provider;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.FileAttributeDefinitions;

class ProviderAttributeDefinition {
    private static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).build();
    private static final SimpleAttributeDefinition INFO = new SimpleAttributeDefinitionBuilder("info", ModelType.STRING).build();
    private static final SimpleAttributeDefinition VERSION = new SimpleAttributeDefinitionBuilder("version", ModelType.DOUBLE).build();
    static final ObjectTypeAttributeDefinition LOADED_PROVIDER = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("loaded-provider", new AttributeDefinition[]{NAME, INFO, VERSION}).setStorageRuntime()).setAllowNull(false).build();
    private static final SimpleAttributeDefinition TYPE = new SimpleAttributeDefinitionBuilder("type", ModelType.STRING).build();
    private static final SimpleAttributeDefinition ALGORITHM = new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).build();
    private static final SimpleAttributeDefinition CLASS_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("class-name", ModelType.STRING).setAllowExpression(false)).build();
    private static final ObjectTypeAttributeDefinition SERVICE = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("service", new AttributeDefinition[]{TYPE, ALGORITHM, CLASS_NAME}).setStorageRuntime()).setAllowNull(false).build();
    private static final ObjectListAttributeDefinition SERVICES = new ObjectListAttributeDefinition.Builder("services", SERVICE).build();
    private static final ObjectTypeAttributeDefinition FULL_PROVIDER = new ObjectTypeAttributeDefinition.Builder("provider", new AttributeDefinition[]{NAME, INFO, VERSION, SERVICES}).setAllowNull(false).build();
    static final ObjectListAttributeDefinition LOADED_PROVIDERS = ((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("loaded-providers", FULL_PROVIDER).setStorageRuntime()).setAllowNull(false).build();
    private static final SimpleAttributeDefinition INDEX = new SimpleAttributeDefinitionBuilder("index", ModelType.INT).build();
    static final SimpleAttributeDefinition LOAD_SERVICES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("load-services", ModelType.BOOLEAN).setAttributeGroup("class-loading")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    static final SimpleAttributeDefinition PROPERTY_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).build();
    static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).build();
    private static final AttributeDefinition[] PROPERTY_ATTRIBUTES = new AttributeDefinition[]{PROPERTY_NAME, VALUE};
    private static final ObjectTypeAttributeDefinition PROPERTY = new ObjectTypeAttributeDefinition.Builder("property", PROPERTY_ATTRIBUTES).build();
    private static final AttributeDefinition[] INDEXED_PROPERTY_ATTRIBUTES = ProviderAttributeDefinition.combine((AttributeDefinition)INDEX, PROPERTY_ATTRIBUTES, new AttributeDefinition[0]);
    private static final ObjectTypeAttributeDefinition INDEXED_PROPERTY = new ObjectTypeAttributeDefinition.Builder("property", INDEXED_PROPERTY_ATTRIBUTES).build();
    static final ObjectListAttributeDefinition PROPERTY_LIST = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("property-list", PROPERTY).setAttributeGroup("configuration")).setAlternatives(new String[]{"path"})).setAllowDuplicates(true)).setAllowNull(true).build();
    static final ObjectListAttributeDefinition INDEXED_PROPERTY_LIST = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("property-list", INDEXED_PROPERTY).setAttributeGroup("configuration")).setAlternatives(new String[]{"path"})).setAllowDuplicates(true)).setAllowNull(true).build();
    private static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setAttributeGroup("configuration")).setAlternatives(new String[]{"property-list"})).build();
    private static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", FileAttributeDefinitions.RELATIVE_TO).setAttributeGroup("configuration")).build();
    private static final AttributeDefinition[] PROVIDER_ATTRIBUTES = new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE, LOAD_SERVICES, ClassLoadingAttributeDefinitions.CLASS_NAMES, PATH, RELATIVE_TO};
    static final ObjectTypeAttributeDefinition PROVIDER = new ObjectTypeAttributeDefinition.Builder("provider", ProviderAttributeDefinition.combine(null, PROVIDER_ATTRIBUTES, new AttributeDefinition[]{PROPERTY_LIST})).build();
    private static final ObjectTypeAttributeDefinition INDEXED_PROVIDER = new ObjectTypeAttributeDefinition.Builder("provider", ProviderAttributeDefinition.combine((AttributeDefinition)INDEX, PROVIDER_ATTRIBUTES, new AttributeDefinition[]{INDEXED_PROPERTY_LIST})).build();
    static final ObjectListAttributeDefinition PROVIDERS = new ObjectListAttributeDefinition.Builder("providers", PROVIDER).setAllowNull(true).build();
    static final ObjectListAttributeDefinition INDEXED_PROVIDERS = new ObjectListAttributeDefinition.Builder("providers", INDEXED_PROVIDER).setAllowNull(true).build();

    private ProviderAttributeDefinition() {
    }

    static void populateProvider(ModelNode response, Provider provider, boolean includeServices) {
        response.get("name").set(provider.getName());
        response.get("info").set(provider.getInfo());
        response.get("version").set(provider.getVersion());
        if (includeServices) {
            ProviderAttributeDefinition.addServices(response, provider);
        }
    }

    static void populateProviders(ModelNode response, Provider[] providers) {
        for (Provider current : providers) {
            ModelNode providerModel = new ModelNode();
            ProviderAttributeDefinition.populateProvider(providerModel, current, true);
            response.add(providerModel);
        }
    }

    private static void addServices(ModelNode providerModel, Provider provider) {
        ModelNode servicesModel = providerModel.get("services");
        for (Provider.Service current : provider.getServices()) {
            ModelNode serviceModel = new ModelNode();
            serviceModel.get("type").set(current.getType());
            serviceModel.get("algorithm").set(current.getAlgorithm());
            serviceModel.get("class-name").set(current.getClassName());
            servicesModel.add(serviceModel);
        }
    }

    private static AttributeDefinition[] combine(AttributeDefinition first, AttributeDefinition[] remaining, AttributeDefinition ... more) {
        AttributeDefinition[] response = new AttributeDefinition[(first == null ? 0 : 1) + remaining.length + more.length];
        int pos = 0;
        if (first != null) {
            response[pos++] = first;
        }
        System.arraycopy(remaining, 0, response, pos, remaining.length);
        System.arraycopy(more, 0, response, pos += remaining.length, more.length);
        return response;
    }
}

