/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SecurityActions;

class ProviderRegistrationService
implements Service<Void> {
    static final ServiceName SERVICE_NAME = ElytronExtension.BASE_SERVICE_NAME.append(new String[]{"provider-registration"});
    private InjectedValue<Provider[]> initialProviders = new InjectedValue();
    private InjectedValue<Provider[]> finalProviders = new InjectedValue();
    private final Set<String> registeredProviderNames = new HashSet<String>();

    ProviderRegistrationService() {
    }

    public void start(StartContext context) throws StartException {
        Provider[] initialProviders = (Provider[])this.initialProviders.getOptionalValue();
        Provider[] finalProviders = (Provider[])this.finalProviders.getOptionalValue();
        if (initialProviders != null) {
            SecurityActions.doPrivileged(() -> {
                for (int i = initialProviders.length - 1; i >= 0; --i) {
                    int position = Security.insertProviderAt(initialProviders[i], 0);
                    if (position <= -1) continue;
                    this.registeredProviderNames.add(initialProviders[i].getName());
                }
                return null;
            });
        }
        if (finalProviders != null) {
            SecurityActions.doPrivileged(() -> {
                for (Provider current : finalProviders) {
                    int position = Security.addProvider(current);
                    if (position <= -1) continue;
                    this.registeredProviderNames.add(current.getName());
                }
                return null;
            });
        }
    }

    public void stop(StopContext context) {
        Iterator<String> namesIterator = this.registeredProviderNames.iterator();
        SecurityActions.doPrivileged(() -> {
            while (namesIterator.hasNext()) {
                Security.removeProvider((String)namesIterator.next());
                namesIterator.remove();
            }
            return null;
        });
    }

    Injector<Provider[]> getInitialProivders() {
        return this.initialProviders;
    }

    Injector<Provider[]> getFinalProviders() {
        return this.finalProviders;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

