/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.DomainDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemParser;

class DomainParser {
    DomainParser() {
    }

    void readDomain(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addDomain = new ModelNode();
        addDomain.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "default-realm"));
        String name = null;
        int count = reader.getAttributeCount();
        block26: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block26;
                }
                case "default-realm": {
                    DomainDefinition.DEFAULT_REALM.parseAndSetParameter(value, addDomain, (XMLStreamReader)reader);
                    continue block26;
                }
                case "permission-mapper": {
                    DomainDefinition.PERMISSION_MAPPER.parseAndSetParameter(value, addDomain, (XMLStreamReader)reader);
                    continue block26;
                }
                case "pre-realm-principal-transformer": {
                    DomainDefinition.PRE_REALM_PRINCIPAL_TRANSFORMER.parseAndSetParameter(value, addDomain, (XMLStreamReader)reader);
                    continue block26;
                }
                case "post-realm-principal-transformer": {
                    DomainDefinition.POST_REALM_PRINCIPAL_TRANSFORMER.parseAndSetParameter(value, addDomain, (XMLStreamReader)reader);
                    continue block26;
                }
                case "principal-decoder": {
                    DomainDefinition.PRINCIPAL_DECODER.parseAndSetParameter(value, addDomain, (XMLStreamReader)reader);
                    continue block26;
                }
                case "realm-mapper": {
                    DomainDefinition.REALM_MAPPER.parseAndSetParameter(value, addDomain, (XMLStreamReader)reader);
                    continue block26;
                }
                case "role-mapper": {
                    DomainDefinition.ROLE_MAPPER.parseAndSetParameter(value, addDomain, (XMLStreamReader)reader);
                    continue block26;
                }
                case "trusted-security-domains": {
                    for (String trustedSecurityDomain : reader.getListAttributeValue(i)) {
                        DomainDefinition.TRUSTED_SECURITY_DOMAINS.parseAndAddParameterElement(trustedSecurityDomain, addDomain, (XMLStreamReader)reader);
                    }
                    continue block26;
                }
                case "outflow-anonymous": {
                    DomainDefinition.OUTFLOW_ANONYMOUS.parseAndSetParameter(value, addDomain, (XMLStreamReader)reader);
                    continue block26;
                }
                case "outflow-security-domains": {
                    for (String outflowSecurityDomain : reader.getListAttributeValue(i)) {
                        DomainDefinition.OUTFLOW_SECURITY_DOMAINS.parseAndAddParameterElement(outflowSecurityDomain, addDomain, (XMLStreamReader)reader);
                    }
                    continue block26;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addDomain.get("address").set(parentAddress).add("security-domain", name);
        boolean realmFound = false;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"realm".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            this.parseRealmElement(addDomain, reader);
            realmFound = true;
        }
        if (!realmFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"realm"});
        }
        operations.add(addDomain);
    }

    private String parseRealmElement(ModelNode addOperation, XMLExtendedStreamReader reader) throws XMLStreamException {
        String realmName = null;
        ModelNode realm = new ModelNode();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String attribute;
            String attributeValue = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    realmName = attributeValue;
                    DomainDefinition.REALM_NAME.parseAndSetParameter(attributeValue, realm, (XMLStreamReader)reader);
                    continue block12;
                }
                case "principal-transformer": {
                    DomainDefinition.REALM_PRINCIPAL_TRANSFORMER.parseAndSetParameter(attributeValue, realm, (XMLStreamReader)reader);
                    continue block12;
                }
                case "role-decoder": {
                    DomainDefinition.REALM_ROLE_DECODER.parseAndSetParameter(attributeValue, realm, (XMLStreamReader)reader);
                    continue block12;
                }
                case "role-mapper": {
                    DomainDefinition.ROLE_MAPPER.parseAndSetParameter(attributeValue, realm, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (realmName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOperation.get("realms").add(realm);
        return realmName;
    }

    void writeDomain(String name, ModelNode domain, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("security-domain");
        writer.writeAttribute("name", name);
        DomainDefinition.PRE_REALM_PRINCIPAL_TRANSFORMER.marshallAsAttribute(domain, (XMLStreamWriter)writer);
        DomainDefinition.DEFAULT_REALM.marshallAsAttribute(domain, (XMLStreamWriter)writer);
        DomainDefinition.POST_REALM_PRINCIPAL_TRANSFORMER.marshallAsAttribute(domain, (XMLStreamWriter)writer);
        DomainDefinition.PERMISSION_MAPPER.marshallAsAttribute(domain, (XMLStreamWriter)writer);
        DomainDefinition.PRINCIPAL_DECODER.marshallAsAttribute(domain, (XMLStreamWriter)writer);
        DomainDefinition.REALM_MAPPER.marshallAsAttribute(domain, (XMLStreamWriter)writer);
        DomainDefinition.ROLE_MAPPER.marshallAsAttribute(domain, (XMLStreamWriter)writer);
        DomainDefinition.TRUSTED_SECURITY_DOMAINS.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)DomainDefinition.TRUSTED_SECURITY_DOMAINS, domain, false, (XMLStreamWriter)writer);
        DomainDefinition.OUTFLOW_ANONYMOUS.marshallAsAttribute(domain, (XMLStreamWriter)writer);
        DomainDefinition.OUTFLOW_SECURITY_DOMAINS.getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)DomainDefinition.OUTFLOW_SECURITY_DOMAINS, domain, false, (XMLStreamWriter)writer);
        List realms = domain.get("realms").asList();
        for (ModelNode current : realms) {
            this.writeRealm(current, writer);
        }
        writer.writeEndElement();
    }

    private void writeRealm(ModelNode realm, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("realm");
        DomainDefinition.REALM_NAME.marshallAsAttribute(realm, (XMLStreamWriter)writer);
        DomainDefinition.REALM_PRINCIPAL_TRANSFORMER.marshallAsAttribute(realm, (XMLStreamWriter)writer);
        DomainDefinition.REALM_ROLE_DECODER.marshallAsAttribute(realm, (XMLStreamWriter)writer);
        DomainDefinition.ROLE_MAPPER.marshallAsAttribute(realm, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }
}

