/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.barehttp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import org.wildfly.elytron.web.barehttp.BareHttpClient;
import org.wildfly.elytron.web.barehttp.BareHttpResponse;

public class BareHttpRequest {
    private final BareHttpClient.Target target;
    private final String path;
    private final String messageBody;

    BareHttpRequest(BareHttpClient.Target target, String path, String messageBody) {
        this.target = target;
        this.path = path;
        this.messageBody = messageBody;
    }

    public BareHttpResponse execute() throws IOException {
        this.target.connect();
        ByteBuffer requestMessage = this.createRequestByteBuffer();
        return this.target.sendAndReceive(requestMessage);
    }

    private ByteBuffer createRequestByteBuffer() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        int contentLength = this.messageBody.length();
        writer.printf(contentLength > 0 ? "POST %s HTTP/1.1" : "GET %s HTTP/1.1", this.path);
        writer.print("\r\n");
        if (contentLength > 0) {
            writer.printf("Content-Length: %d", contentLength);
            writer.print("\r\n");
            writer.print("Content-Type: application/x-www-form-urlencoded");
            writer.print("\r\n");
        }
        writer.printf("Host: %s", this.target.getHost());
        writer.print("\r\n");
        writer.print("Connection: keep-alive");
        writer.print("\r\n");
        writer.printf("User-Agent: %s", "Bare HTTP Test Utility");
        writer.print("\r\n");
        Map<String, String> cookies = this.target.getCookies();
        for (Map.Entry<String, String> current : cookies.entrySet()) {
            writer.printf("Cookie: %s=%s", current.getKey(), current.getValue());
            writer.print("\r\n");
        }
        writer.print("Accept-Encoding: gzip,deflate");
        writer.print("\r\n");
        writer.print("\r\n");
        if (contentLength > 0) {
            writer.print(this.messageBody);
        }
        writer.flush();
        byte[] message = baos.toByteArray();
        ByteBuffer messageBuffer = ByteBuffer.wrap(message);
        return messageBuffer;
    }

    static Builder builder(BareHttpClient.Target target, String path) {
        return new Builder(target, path);
    }

    public static class Builder {
        private final BareHttpClient.Target target;
        private final String path;
        private String messageBody = "";

        Builder(BareHttpClient.Target target, String path) {
            this.target = target;
            this.path = path.trim().isEmpty() ? "/" : path;
        }

        public Builder setMessageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public BareHttpRequest build() {
            return new BareHttpRequest(this.target, this.path, this.messageBody);
        }
    }
}

