/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.barehttp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.elytron.web.barehttp.BareHttpRequest;
import org.wildfly.elytron.web.barehttp.BareHttpResponse;

public class BareHttpClient {
    BareHttpClient() {
    }

    public Target target(String hostName, int port) {
        return new Target(hostName, port);
    }

    public static Builder builder() {
        return new Builder();
    }

    public class Target {
        private final InetSocketAddress address;
        private final Map<String, String> cookies = new HashMap<String, String>();
        private SocketChannel socketChannel;

        Target(String hostName, int port) {
            this.address = new InetSocketAddress(hostName, port);
        }

        public String getHost() {
            return this.address.getHostName() + ":" + this.address.getPort();
        }

        boolean connect() throws IOException {
            if (this.isConnected()) {
                return false;
            }
            this.socketChannel = SocketChannel.open(this.address);
            return this.socketChannel.isConnected();
        }

        void setCookie(String cookieName, String cookieValue) {
            this.cookies.put(cookieName, cookieValue);
        }

        Map<String, String> getCookies() {
            return this.cookies;
        }

        public boolean hasCookie(String cookieName) {
            return this.cookies.containsKey(cookieName);
        }

        void close() throws IOException {
            if (this.isConnected()) {
                this.socketChannel.close();
                this.socketChannel = null;
            }
        }

        BareHttpResponse sendAndReceive(ByteBuffer request) throws IOException {
            if (!this.isConnected()) {
                throw new IOException("Connection is not open.");
            }
            while (request.hasRemaining()) {
                this.socketChannel.write(request);
            }
            ByteBuffer responseMessage = ByteBuffer.allocate(1024);
            this.socketChannel.read(responseMessage);
            responseMessage.flip();
            BareHttpResponse.Builder responseBuilder = null;
            boolean complete = false;
            StringBuilder currentLine = new StringBuilder();
            while (responseMessage.hasRemaining() && !complete) {
                char c = (char)responseMessage.get();
                boolean endOfLine = false;
                if (c == '\r') {
                    if (responseMessage.hasRemaining()) {
                        responseMessage.mark();
                        char next = (char)responseMessage.get();
                        if (next == '\n') {
                            endOfLine = true;
                        } else {
                            responseMessage.reset();
                        }
                    }
                } else if (!responseMessage.hasRemaining()) {
                    endOfLine = true;
                }
                if (endOfLine) {
                    if (responseBuilder == null) {
                        responseBuilder = BareHttpResponse.builder(this, currentLine.toString());
                    } else if (currentLine.length() > 0) {
                        responseBuilder.processHeader(currentLine.toString());
                    } else {
                        responseBuilder.setMessageBody(this.toMessageBody(responseMessage, responseBuilder.getContentLength(), responseBuilder.isChunkedEncoding()));
                        complete = true;
                    }
                    currentLine = new StringBuilder();
                    continue;
                }
                currentLine.append(c);
            }
            return responseBuilder != null ? responseBuilder.build() : null;
        }

        private String toMessageBody(ByteBuffer byteBuffer, int contentLength, boolean chunkedEncoding) throws IOException {
            StringBuilder chunkSizeString;
            if (!chunkedEncoding) {
                byte[] bodyBytes = new byte[contentLength];
                byteBuffer.get(bodyBytes);
                return new String(bodyBytes, StandardCharsets.UTF_8);
            }
            StringBuilder responseBuilder = new StringBuilder();
            int chunkSize = -1;
            do {
                boolean endReached;
                if (chunkSize > 0) {
                    byte[] chunkData = new byte[chunkSize];
                    byteBuffer.get(chunkData);
                    byteBuffer.get();
                    byteBuffer.get();
                    responseBuilder.append(new String(chunkData, StandardCharsets.UTF_8));
                }
                if (!byteBuffer.hasRemaining()) {
                    byteBuffer.clear();
                    this.socketChannel.read(byteBuffer);
                    byteBuffer.flip();
                }
                chunkSize = 0;
                chunkSizeString = new StringBuilder();
                boolean bl = endReached = !byteBuffer.hasRemaining();
                while (!endReached) {
                    char currentChar = (char)byteBuffer.get();
                    if (currentChar >= '0' && currentChar <= '9' || currentChar >= 'a' && currentChar <= 'f' || currentChar >= 'A' && currentChar <= 'F') {
                        chunkSizeString.append(currentChar);
                        continue;
                    }
                    if (currentChar != '\r') continue;
                    byteBuffer.mark();
                    if (byteBuffer.hasRemaining() && byteBuffer.get() == 10) {
                        endReached = true;
                        continue;
                    }
                    byteBuffer.reset();
                }
            } while ((chunkSize = Integer.parseInt(chunkSizeString.toString(), 16)) > 0);
            return responseBuilder.toString();
        }

        public boolean isConnected() {
            return this.socketChannel != null && this.socketChannel.isConnected();
        }

        public BareHttpRequest.Builder buildRequest(String path) {
            return BareHttpRequest.builder(this, path);
        }
    }

    public static class Builder {
        Builder() {
        }

        public BareHttpClient build() {
            return new BareHttpClient();
        }
    }
}

