/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.jetty.server;

import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.wildfly.elytron.web.jetty.server.ElytronHttpExchange;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpAuthenticator;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public class ElytronAuthenticator
implements Authenticator {
    private final SecurityDomain securityDomain;
    private HttpAuthenticationFactory httpAuthenticationFactory;

    private ElytronAuthenticator(Builder builder) {
        this.securityDomain = builder.securityDomain;
        this.httpAuthenticationFactory = HttpAuthenticationFactory.builder().setSecurityDomain(this.securityDomain).setMechanismConfigurationSelector(builder.mechanismConfigurationSelector).setFactory(builder.httpServerAuthenticationMechanismFactory).build();
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
    }

    public String getAuthMethod() {
        return null;
    }

    public void prepareRequest(ServletRequest request) {
    }

    public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean mandatory) throws ServerAuthException {
        boolean authenticated;
        Request request = (Request)servletRequest;
        Response response = (Response)servletResponse;
        HttpAuthenticator authenticator = HttpAuthenticator.builder().setSecurityDomain(this.securityDomain).setMechanismSupplier(() -> this.httpAuthenticationFactory.getMechanismNames().stream().map(mechanismName -> {
            try {
                return (HttpServerAuthenticationMechanism)this.httpAuthenticationFactory.createMechanism(mechanismName);
            }
            catch (HttpAuthenticationException e) {
                throw new RuntimeException("Failed to create mechanism.", e);
            }
        }).filter(m -> m != null).collect(Collectors.toList())).setHttpExchangeSpi((HttpExchangeSpi)new ElytronHttpExchange(request, response)).setRequired(mandatory).build();
        try {
            authenticated = authenticator.authenticate();
        }
        catch (HttpAuthenticationException e) {
            throw new ServerAuthException((Throwable)e);
        }
        if (authenticated) {
            return request.getAuthentication();
        }
        return Authentication.SEND_CONTINUE;
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SecurityDomain securityDomain;
        private MechanismConfigurationSelector mechanismConfigurationSelector;
        private HttpServerAuthenticationMechanismFactory httpServerAuthenticationMechanismFactory;

        Builder() {
        }

        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder setMechanismConfigurationSelector(MechanismConfigurationSelector mechanismConfigurationSelector) {
            this.mechanismConfigurationSelector = mechanismConfigurationSelector;
            return this;
        }

        public Builder setFactory(HttpServerAuthenticationMechanismFactory httpServerAuthenticationMechanismFactory) {
            this.httpServerAuthenticationMechanismFactory = httpServerAuthenticationMechanismFactory;
            return this;
        }

        public ElytronAuthenticator build() {
            return new ElytronAuthenticator(this);
        }
    }
}

