/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequest;
import java.util.function.Function;
import java.util.function.Predicate;
import org.wildfly.elytron.web.netty.server.ElytronInboundHandler;
import org.wildfly.elytron.web.netty.server.ElytronOutboundHandler;
import org.wildfly.elytron.web.netty.server.ElytronRunAsHandler;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public class ElytronHandlers
implements Function<ChannelPipeline, ChannelPipeline> {
    private SecurityDomain securityDomain;
    private MechanismConfigurationSelector mechanismConfigurationSelector;
    private HttpServerAuthenticationMechanismFactory httpServerAuthenticationMechanismFactory;
    private Predicate<HttpRequest> authenticationRequired;

    private ElytronHandlers() {
    }

    public ElytronHandlers setSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
        return this;
    }

    public ElytronHandlers setMechanismConfigurationSelector(MechanismConfigurationSelector mechanismConfigurationSelector) {
        this.mechanismConfigurationSelector = mechanismConfigurationSelector;
        return this;
    }

    public ElytronHandlers setFactory(HttpServerAuthenticationMechanismFactory httpServerAuthenticationMechanismFactory) {
        this.httpServerAuthenticationMechanismFactory = httpServerAuthenticationMechanismFactory;
        return this;
    }

    public ElytronHandlers setAuthenticationRequired(Predicate<HttpRequest> authenticationRequired) {
        this.authenticationRequired = authenticationRequired;
        return this;
    }

    @Override
    public ChannelPipeline apply(ChannelPipeline pipeline) {
        HttpAuthenticationFactory httpAuthenticationFactory = HttpAuthenticationFactory.builder().setSecurityDomain(this.securityDomain).setFactory(this.httpServerAuthenticationMechanismFactory).setMechanismConfigurationSelector(this.mechanismConfigurationSelector).build();
        ElytronInboundHandler inboundHandler = new ElytronInboundHandler(httpAuthenticationFactory, this.authenticationRequired);
        ElytronOutboundHandler outboundHandler = new ElytronOutboundHandler(inboundHandler::getElytronResponse);
        ElytronRunAsHandler runAsHandler = new ElytronRunAsHandler(inboundHandler::getSecurityIdentity);
        pipeline.addLast(new ChannelHandler[]{outboundHandler});
        pipeline.addLast(new ChannelHandler[]{inboundHandler});
        pipeline.addLast(new ChannelHandler[]{runAsHandler});
        return pipeline;
    }

    public static ElytronHandlers newInstance() {
        return new ElytronHandlers();
    }
}

