/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import java.net.URI;
import java.security.Permission;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.wildfly.elytron.web.barehttp.BareHttpClient;
import org.wildfly.elytron.web.barehttp.BareHttpRequest;
import org.wildfly.elytron.web.barehttp.BareHttpResponse;
import org.wildfly.elytron.web.undertow.common.AbstractHttpServerMechanismTest;
import org.wildfly.elytron.web.undertow.common.UndertowServer;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.PermissionVerifier;

public abstract class FormAuthenticationBase
extends AbstractHttpServerMechanismTest {
    @Rule
    public UndertowServer server = this.createUndertowServer();
    private AtomicInteger realmIdentityInvocationCount = new AtomicInteger(0);
    private static final String J_SECURITY_DATA = "j_username=%s&j_password=%s";

    protected FormAuthenticationBase() throws Exception {
    }

    @Test
    public void testRedirectLoginPage() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        FormAuthenticationBase.assertLoginPage(httpClient.execute((HttpUriRequest)new HttpGet(this.server.createUri())));
    }

    @Test
    public void testFormSuccessfulAuthentication() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        HttpPost httpAuthenticate = new HttpPost(this.server.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
        this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)httpAuthenticate), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)httpAuthenticate), "ladybird");
    }

    @Test
    public void testSessionIdentityCache() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        HttpPost httpAuthenticate = new HttpPost(this.server.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
        this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)httpAuthenticate), "ladybird");
        for (int i = 0; i < 10; ++i) {
            this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.server.createUri())), "ladybird");
        }
        Assert.assertEquals((long)1L, (long)this.realmIdentityInvocationCount.get());
    }

    @Test
    public void testLogout() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        HttpPost httpAuthenticate = new HttpPost(this.server.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
        this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)httpAuthenticate), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.server.createUri())), "ladybird");
        httpClient.execute((HttpUriRequest)new HttpGet(this.server.createUri("/logout")));
        FormAuthenticationBase.assertLoginPage(httpClient.execute((HttpUriRequest)new HttpGet(this.server.createUri())));
    }

    public void bareHttpClientRunner(String initialPath, Predicate<String> redirectVerifier) throws Exception {
        URI defaultUri = this.server.createUri();
        BareHttpClient httpClient = BareHttpClient.builder().build();
        String hostName = defaultUri.getHost();
        int port = defaultUri.getPort();
        BareHttpClient.Target targetServer = httpClient.target(hostName, port);
        BareHttpRequest initialRequest = targetServer.buildRequest(initialPath).build();
        BareHttpResponse httpResponse = initialRequest.execute();
        Assert.assertNotEquals((String)"Request Rejected", (long)400L, (long)httpResponse.getStatusCode());
        Assert.assertTrue((String)"Response should set JSESSIONID", (boolean)targetServer.hasCookie("JSESSIONID"));
        if (httpResponse.getStatusCode() == 302) {
            String location = (String)((List)httpResponse.getHeaders().get("Location")).get(0);
            URI locationUri = new URI(location);
            Assert.assertEquals((String)"Expected same hostName on redirect", (Object)hostName, (Object)locationUri.getHost());
            Assert.assertEquals((String)"Expected same port on redirect", (long)port, (long)locationUri.getPort());
            httpResponse = targetServer.buildRequest(locationUri.getPath()).build().execute();
        }
        Assert.assertEquals((String)"Expected Success", (long)200L, (long)httpResponse.getStatusCode());
        Assert.assertTrue((String)"We expect the login page.", (boolean)httpResponse.getMessageBody().contains("Login Page"));
        URI jSecurityCheckUri = this.server.createUri("/j_security_check");
        String messageBody = String.format(J_SECURITY_DATA, "ladybird", "Coleoptera");
        httpResponse = targetServer.buildRequest(jSecurityCheckUri.getPath()).setMessageBody(messageBody).build().execute();
        Assert.assertEquals((String)"Expected Redirect", (long)302L, (long)httpResponse.getStatusCode());
        String location = (String)((List)httpResponse.getHeaders().get("Location")).get(0);
        String redirectPath = location.substring(location.indexOf(47, 7));
        Assert.assertTrue((String)"Redirect URI", (boolean)redirectVerifier.test(redirectPath));
        URI locationUri = new URI(location);
        Assert.assertEquals((String)"Expected same hostName on redirect", (Object)hostName, (Object)locationUri.getHost());
        Assert.assertEquals((String)"Expected same port on redirect", (long)port, (long)locationUri.getPort());
        httpResponse = targetServer.buildRequest(redirectPath).build().execute();
        Assert.assertEquals((String)"Expected Success", (long)200L, (long)httpResponse.getStatusCode());
        Assert.assertEquals((String)"Expected UndertowUser", (Object)"ladybird", ((List)httpResponse.getHeaders().get("UndertowUser")).get(0));
        Assert.assertEquals((String)"Expected ElytronUser", (Object)"ladybird", ((List)httpResponse.getHeaders().get("ElytronUser")).get(0));
    }

    @Test
    public void testDefaultURLBare() throws Exception {
        URI defaultUri = this.server.createUri();
        String defaultPath = defaultUri.getPath().isEmpty() ? "/" : defaultUri.getPath();
        this.bareHttpClientRunner(defaultUri.getPath(), p -> defaultPath.equals(p));
    }

    @Test
    public void testEncodedQueryStringBare() throws Exception {
        String encodedQuery = "project=%7BElytron%20Web%7D";
        URI defaultUri = this.server.createUri();
        String defaultPath = defaultUri.getPath().isEmpty() ? "/" : defaultUri.getPath();
        String path = defaultPath + "?" + encodedQuery;
        this.bareHttpClientRunner(path, p -> path.equals(p));
    }

    @Test
    public void testEncodedQueryStringPlusBare() throws Exception {
        String encodedQuery = "project=%7BElytron%2BWeb%7D";
        URI defaultUri = this.server.createUri();
        String defaultPath = defaultUri.getPath().isEmpty() ? "/" : defaultUri.getPath();
        String path = defaultPath + "?" + encodedQuery;
        this.bareHttpClientRunner(path, p -> path.equals(p));
    }

    @Test
    public void testNonEncodedQueryStringPlusBare() throws Exception {
        String nonEncodedQuery = "project={Elytron+Web}";
        URI defaultUri = this.server.createUri();
        String defaultPath = defaultUri.getPath().isEmpty() ? "/" : defaultUri.getPath();
        String path = defaultPath + "?" + nonEncodedQuery;
        String encodedQuery = "project=%7BElytron+Web%7D";
        String expectedPath = defaultPath + "?" + encodedQuery;
        this.bareHttpClientRunner(path, p -> expectedPath.equals(p));
    }

    @Test
    public void testNonEncodedQueryStringBare() throws Exception {
        String nonEncodedQuery = "project={ElytronWeb}";
        URI defaultUri = this.server.createUri();
        String defaultPath = defaultUri.getPath().isEmpty() ? "/" : defaultUri.getPath();
        String path = defaultPath + "?" + nonEncodedQuery;
        String encodedQuery = "project=%7BElytronWeb%7D";
        String expectedPath = defaultPath + "?" + encodedQuery;
        this.bareHttpClientRunner(path, p -> expectedPath.equals(p));
    }

    @Test
    public void testEncodedPathBare() throws Exception {
        URI defaultUri = this.server.createUri();
        String encodedPath = defaultUri.getPath() + "/file%7B1%7D.txt";
        this.bareHttpClientRunner(encodedPath, p -> encodedPath.equals(p));
    }

    @Test
    public void testNonEncodedPathBare() throws Exception {
        URI defaultUri = this.server.createUri();
        String nonEncodedPath = defaultUri.getPath() + "/file{1}.txt";
        String encodedPath = defaultUri.getPath() + "/file%7B1%7D.txt";
        this.bareHttpClientRunner(nonEncodedPath, p -> encodedPath.equals(p));
    }

    @Override
    protected String getMechanismName() {
        return "FORM";
    }

    @Override
    protected SecurityDomain doCreateSecurityDomain() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
        HashMap<String, SimpleRealmEntry> passwordMap = new HashMap<String, SimpleRealmEntry>();
        passwordMap.put("ladybird", new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec("Coleoptera".toCharArray()))))));
        final SimpleMapBackedSecurityRealm delegate = new SimpleMapBackedSecurityRealm();
        delegate.setPasswordMap(passwordMap);
        SecurityRealm securityRealm = new SecurityRealm(){

            public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
                FormAuthenticationBase.this.realmIdentityInvocationCount.incrementAndGet();
                return delegate.getRealmIdentity(principal);
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec algorithmParameterSpec) throws RealmUnavailableException {
                return delegate.getCredentialAcquireSupport(credentialType, algorithmName, algorithmParameterSpec);
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return delegate.getEvidenceVerifySupport(evidenceType, algorithmName);
            }
        };
        SecurityDomain.Builder builder = SecurityDomain.builder().setDefaultRealmName("TestRealm");
        builder.addRealm("TestRealm", securityRealm).build();
        builder.setPermissionMapper((principal, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        return builder.build();
    }

    protected abstract UndertowServer createUndertowServer() throws Exception;
}

