/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.security.Permission;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.wildfly.elytron.web.undertow.common.AbstractHttpServerMechanismTest;
import org.wildfly.elytron.web.undertow.common.UndertowServer;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.PermissionVerifier;

public abstract class BasicAuthenticationBase
extends AbstractHttpServerMechanismTest {
    @Rule
    public UndertowServer server = this.createUndertowServer();

    protected BasicAuthenticationBase() throws Exception {
    }

    @Test
    public void testUnauthorized() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri());
        this.assertUnauthorizedResponse(httpClient.execute((HttpUriRequest)get));
    }

    @Test
    public void testSuccessfulAuthentication() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri());
        get.addHeader(Headers.AUTHORIZATION.toString(), String.valueOf(Headers.BASIC) + " " + FlexBase64.encodeString((byte[])"elytron:Coleoptera".getBytes(), (boolean)false));
        HttpResponse result = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        this.assertSuccessfulResponse(result, "elytron");
    }

    @Test
    public void testFailedAuthentication() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri());
        get.addHeader(Headers.AUTHORIZATION.toString(), String.valueOf(Headers.BASIC) + " " + FlexBase64.encodeString((byte[])"elytron:bad_password".getBytes(), (boolean)false));
        this.assertUnauthorizedResponse(httpClient.execute((HttpUriRequest)get));
    }

    @Test
    public void testUnconstrainedAccessWithCorrectPassword() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri("/unsecure"));
        get.addHeader(Headers.AUTHORIZATION.toString(), String.valueOf(Headers.BASIC) + " " + FlexBase64.encodeString((byte[])"elytron:Coleoptera".getBytes(), (boolean)false));
        HttpResponse result = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        this.assertSuccessfulUnconstraintResponse(result, "elytron");
    }

    @Test
    public void testUnconstrainedAccessWithIncorrectPassword() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri("/unsecure"));
        get.addHeader(Headers.AUTHORIZATION.toString(), String.valueOf(Headers.BASIC) + " " + FlexBase64.encodeString((byte[])"elytron:bad_password".getBytes(), (boolean)false));
        HttpResponse result = httpClient.execute((HttpUriRequest)get);
        this.assertUnauthorizedResponse(result);
    }

    @Test
    public void testUnconstrainedAccessWithoutPassword() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.server.createUri("/unsecure"));
        HttpResponse result = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        this.assertSuccessfulUnconstraintResponse(result, null);
    }

    private void assertUnauthorizedResponse(HttpResponse result) {
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header wwwAuthenticateHeader = result.getFirstHeader(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertNotNull((Object)wwwAuthenticateHeader);
        Assert.assertEquals((Object)(String.valueOf(Headers.BASIC) + " realm=\"Elytron Realm\""), (Object)wwwAuthenticateHeader.getValue());
    }

    @Override
    protected String getMechanismName() {
        return "BASIC";
    }

    @Override
    protected SecurityDomain doCreateSecurityDomain() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
        HashMap<String, SimpleRealmEntry> passwordMap = new HashMap<String, SimpleRealmEntry>();
        passwordMap.put("elytron", new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec("Coleoptera".toCharArray()))))));
        SimpleMapBackedSecurityRealm simpleRealm = new SimpleMapBackedSecurityRealm();
        simpleRealm.setPasswordMap(passwordMap);
        SecurityDomain.Builder builder = SecurityDomain.builder().setDefaultRealmName("TestRealm");
        builder.addRealm("TestRealm", (SecurityRealm)simpleRealm).build();
        builder.setPermissionMapper((principal, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        return builder.build();
    }

    protected abstract UndertowServer createUndertowServer() throws Exception;
}

