/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;

class CertificateUtil {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORTHM = "SHA256withRSA";
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final char[] PASSWORD = "Elytron".toCharArray();

    CertificateUtil() {
    }

    static X509Certificate createSelfSignedIdentity(String alias, X500Principal principal, String workingDir, String keyStoreName) {
        SelfSignedX509CertificateAndSigningKey selfSignedIdentity = SelfSignedX509CertificateAndSigningKey.builder().setDn(principal).setKeyAlgorithmName(KEY_ALGORITHM).setSignatureAlgorithmName(SIGNATURE_ALGORTHM).build();
        X509Certificate selfSignedCertificate = selfSignedIdentity.getSelfSignedCertificate();
        File keyStoreFile = new File(workingDir, keyStoreName);
        KeyStore keyStore = CertificateUtil.createEmptyKeyStore();
        try {
            keyStore.setKeyEntry(alias, selfSignedIdentity.getSigningKey(), PASSWORD, new X509Certificate[]{selfSignedIdentity.getSelfSignedCertificate()});
            try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
                keyStore.store(out, PASSWORD);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        return selfSignedCertificate;
    }

    private static KeyStore createEmptyKeyStore() {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
            ks.load(null, null);
            return ks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

