/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.wildfly.elytron.web.undertow.server.SecurityContextImpl;
import org.wildfly.elytron.web.undertow.server.servlet.CleanUpTask;
import org.wildfly.elytron.web.undertow.server.servlet.RequestResponseAccessor;
import org.wildfly.security.auth.jaspi.impl.JaspiAuthenticationContext;
import org.wildfly.security.auth.jaspi.impl.ServletMessageInfo;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.cache.CachedIdentity;

public class ServletSecurityContextImpl
extends SecurityContextImpl {
    private static final Logger log = Logger.getLogger((String)"org.wildfly.security.http.servlet");
    private static final String AUTH_TYPE = "jakarta.servlet.http.authType";
    private static final String DEFAULT_JASPI_MECHANISM = "JASPI";
    private static final String MANDATORY = "jakarta.security.auth.message.MessagePolicy.isMandatory";
    private static final String REGISTER_SESSION = "jakarta.servlet.http.registerSession";
    private static final String SERVLET_MESSAGE_LAYER = "HttpServlet";
    private static final String IDENTITY_KEY = IdentityContainer.class.getName();
    private final boolean enableJaspi;
    private final boolean integratedJaspi;
    private final String applicationContext;
    private final RequestResponseAccessor requestResponseAccessor;

    ServletSecurityContextImpl(Builder builder) {
        super((SecurityContextImpl.Builder)builder);
        this.enableJaspi = builder.enableJaspi;
        this.integratedJaspi = builder.integratedJaspi;
        this.applicationContext = builder.applicationContext;
        this.requestResponseAccessor = builder.requestResponseAccessor;
        log.tracef("Created ServletSecurityContextImpl enableJapi=%b, integratedJaspi=%b, applicationContext=%s", (Object)this.enableJaspi, (Object)this.integratedJaspi, (Object)this.applicationContext);
    }

    public boolean authenticate() {
        if (this.isAuthenticated()) {
            return true;
        }
        if (this.enableJaspi) {
            AuthConfigFactory authConfigFactory = ServletSecurityContextImpl.getAuthConfigFactory();
            if (authConfigFactory != null) {
                AuthConfigProvider configProvider = authConfigFactory.getConfigProvider(SERVLET_MESSAGE_LAYER, this.applicationContext, null);
                if (configProvider != null) {
                    try {
                        return this.authenticate(configProvider);
                    }
                    catch (AuthException | SecurityException e) {
                        log.trace((Object)"Authentication failed.", e);
                        this.exchange.setStatusCode(500);
                        return false;
                    }
                }
                log.tracef("No AuthConfigProvider for layer=%s, appContext=%s", (Object)SERVLET_MESSAGE_LAYER, (Object)this.applicationContext);
            } else {
                log.trace((Object)"No AuthConfigFactory available.");
            }
        }
        log.trace((Object)"JASPIC Unavailable, using HTTP authentication.");
        return super.authenticate();
    }

    private static AuthConfigFactory getAuthConfigFactory() {
        try {
            if (System.getSecurityManager() != null) {
                return ServletSecurityContextImpl.doPrivileged(AuthConfigFactory::getFactory);
            }
            return AuthConfigFactory.getFactory();
        }
        catch (Exception e) {
            log.trace((Object)"Unable to get AuthConfigFactory", (Throwable)e);
            return null;
        }
    }

    private boolean authenticate(AuthConfigProvider authConfigProvider) throws AuthException, SecurityException {
        boolean registerSession;
        HttpServletRequest originalRequest = this.requestResponseAccessor.getHttpServletRequest();
        HttpSession session = originalRequest.getSession(false);
        IdentityContainer identityContainer = null;
        if (session != null) {
            identityContainer = (IdentityContainer)session.getAttribute(IDENTITY_KEY);
        }
        CachedIdentity cachedIdentity = identityContainer != null ? identityContainer.getSecurityIdentity() : null;
        Object httpServletRequest = cachedIdentity != null ? new JakartaAuthenticationRequest(cachedIdentity, originalRequest) : originalRequest;
        JaspiAuthenticationContext authenticationContext = ServletSecurityContextImpl.doPrivileged(() -> JaspiAuthenticationContext.newInstance((SecurityDomain)this.securityDomain, (boolean)this.integratedJaspi, (CachedIdentity)cachedIdentity));
        ServerAuthConfig serverAuthConfig = authenticationContext.getServerAuthConfig(authConfigProvider, SERVLET_MESSAGE_LAYER, this.applicationContext);
        HttpServletResponse httpServletResponse = this.requestResponseAccessor.getHttpServletResponse();
        ServletMessageInfo messageInfo = new ServletMessageInfo();
        messageInfo.setRequestMessage(httpServletRequest);
        messageInfo.setResponseMessage((Object)httpServletResponse);
        if (this.isAuthenticationRequired()) {
            messageInfo.getMap().put(MANDATORY, Boolean.TRUE.toString());
        }
        Subject serverSubject = null;
        String authContextId = serverAuthConfig.getAuthContextID((MessageInfo)messageInfo);
        ServerAuthContext serverAuthContext = serverAuthConfig.getAuthContext(authContextId, null, Collections.emptyMap());
        if (serverAuthContext == null) {
            log.trace((Object)"No ServerAuthContext returned, JASPI authentication can not proceed.");
            return false;
        }
        Subject clientSubject = new Subject();
        AuthStatus authStatus = serverAuthContext.validateRequest((MessageInfo)messageInfo, clientSubject, serverSubject);
        log.tracef("ServerAuthContext.validateRequest returned AuthStatus=%s", (Object)authStatus);
        this.registerCleanUpTask(this.exchange, serverAuthContext, (MessageInfo)messageInfo, serverSubject);
        Map options = messageInfo.getMap();
        boolean bl = registerSession = options.containsKey(REGISTER_SESSION) && Boolean.parseBoolean(String.valueOf(options.get(REGISTER_SESSION)));
        if (authStatus == AuthStatus.SUCCESS || authStatus == AuthStatus.SEND_SUCCESS && registerSession) {
            CachedIdentity securityIdentity;
            String authType = options.containsKey(AUTH_TYPE) ? String.valueOf(options.get(AUTH_TYPE)) : this.getMechanismName(DEFAULT_JASPI_MECHANISM);
            CachedIdentity cachedIdentity2 = securityIdentity = authenticationContext.getAuthorizedIdentity() != null ? new CachedIdentity(DEFAULT_JASPI_MECHANISM, true, authenticationContext.getAuthorizedIdentity()) : null;
            if (registerSession) {
                log.trace((Object)"Storing SecurityIdentity in HttpSession");
                session = httpServletRequest.getSession(true);
                session.setAttribute(IDENTITY_KEY, (Object)new IdentityContainer(securityIdentity, authType));
            }
            if (authStatus == AuthStatus.SUCCESS) {
                HttpServletResponse newHttpServletResponse;
                HttpServletRequest newHttpServletRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                if (httpServletRequest != newHttpServletRequest) {
                    if (httpServletRequest instanceof JakartaAuthenticationRequest) {
                        ((JakartaAuthenticationRequest)((Object)httpServletRequest)).stopUsingCachedIdentity();
                    }
                    this.requestResponseAccessor.setHttpServletRequest(newHttpServletRequest);
                }
                if (httpServletResponse != (newHttpServletResponse = (HttpServletResponse)messageInfo.getResponseMessage())) {
                    this.requestResponseAccessor.setHttpServletResponse(newHttpServletResponse);
                }
                boolean success = false;
                if (securityIdentity != null) {
                    this.authenticationComplete(securityIdentity.getSecurityIdentity(), authType);
                    success = true;
                }
                boolean bl2 = success = success || !this.isAuthenticationRequired();
                if (success) {
                    this.setLogoutHandler(new Runnable(){
                        final /* synthetic */ HttpServletRequest val$httpServletRequest;
                        final /* synthetic */ ServerAuthContext val$serverAuthContext;
                        final /* synthetic */ MessageInfo val$messageInfo;
                        final /* synthetic */ Subject val$clientSubject;
                        {
                            this.val$httpServletRequest = httpServletRequest;
                            this.val$serverAuthContext = serverAuthContext;
                            this.val$messageInfo = messageInfo;
                            this.val$clientSubject = subject;
                        }

                        @Override
                        public void run() {
                            HttpSession session = this.val$httpServletRequest.getSession(false);
                            if (session != null) {
                                session.removeAttribute(IDENTITY_KEY);
                            }
                            try {
                                this.val$serverAuthContext.cleanSubject(this.val$messageInfo, this.val$clientSubject);
                            }
                            catch (AuthException e) {
                                log.debug((Object)"Unable to cleanSubject", (Throwable)e);
                            }
                        }
                    });
                }
                return success;
            }
        }
        return false;
    }

    private String getMechanismName(String defaultMechanimsName) {
        String mechanimsName = super.getMechanismName();
        return this.getMechanismName() != null ? mechanimsName : defaultMechanimsName;
    }

    private void registerCleanUpTask(HttpServerExchange exchange, final ServerAuthContext serverAuthContext, final MessageInfo messageInfo, final Subject serviceSubject) {
        exchange.putAttachment(CleanUpTask.ATTACHMENT_KEY, (Object)new CleanUpTask(){

            @Override
            public void cleanUp(HttpServerExchange exchange) throws Exception {
                HttpServletResponse newHttpServletResponse;
                HttpServletRequest httpServletRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                HttpServletResponse httpServletResponse = (HttpServletResponse)messageInfo.getResponseMessage();
                serverAuthContext.secureResponse(messageInfo, serviceSubject);
                HttpServletRequest newHttpServletRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                if (httpServletRequest != newHttpServletRequest) {
                    if (newHttpServletRequest instanceof JakartaAuthenticationRequest) {
                        newHttpServletRequest = ((JakartaAuthenticationRequest)newHttpServletRequest).getOriginal();
                    }
                    ServletSecurityContextImpl.this.requestResponseAccessor.setHttpServletRequest(newHttpServletRequest);
                }
                if (httpServletResponse != (newHttpServletResponse = (HttpServletResponse)messageInfo.getResponseMessage())) {
                    ServletSecurityContextImpl.this.requestResponseAccessor.setHttpServletResponse(newHttpServletResponse);
                }
            }
        });
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends SecurityContextImpl.Builder {
        private boolean enableJaspi = true;
        private boolean integratedJaspi = true;
        private String applicationContext;
        private RequestResponseAccessor requestResponseAccessor;

        Builder() {
        }

        Builder setEnableJaspi(boolean enableJaspi) {
            this.enableJaspi = enableJaspi;
            return this;
        }

        Builder setIntegratedJaspi(boolean integratedJaspi) {
            this.integratedJaspi = integratedJaspi;
            return this;
        }

        Builder setApplicationContext(String applicationContext) {
            this.applicationContext = applicationContext;
            return this;
        }

        Builder setRequestResponseAccessor(RequestResponseAccessor requestResponseAccessor) {
            this.requestResponseAccessor = requestResponseAccessor;
            return this;
        }

        public SecurityContext build() {
            return new ServletSecurityContextImpl(this);
        }
    }

    public static class IdentityContainer
    implements Serializable {
        private static final long serialVersionUID = 812605442632466511L;
        private final CachedIdentity securityIdentity;
        private final String authType;

        public IdentityContainer(CachedIdentity securityIdentity, String authType) {
            this.securityIdentity = securityIdentity;
            this.authType = authType;
        }

        public CachedIdentity getSecurityIdentity() {
            return this.securityIdentity;
        }

        public String getAuthType() {
            return this.authType;
        }
    }

    static class JakartaAuthenticationRequest
    extends HttpServletRequestWrapper {
        private final CachedIdentity cachedIdentity;
        private volatile boolean useCachedIdentity = true;
        private final HttpServletRequest originalRequest;

        JakartaAuthenticationRequest(CachedIdentity cachedIdentity, HttpServletRequest originalRequest) {
            super(originalRequest);
            this.cachedIdentity = cachedIdentity;
            this.originalRequest = originalRequest;
        }

        public Principal getUserPrincipal() {
            if (this.useCachedIdentity) {
                if (this.cachedIdentity.getSecurityIdentity() != null) {
                    return this.cachedIdentity.getSecurityIdentity().getPrincipal();
                }
                return new NamePrincipal(this.cachedIdentity.getName());
            }
            return super.getUserPrincipal();
        }

        public boolean isUserInRole(String role) {
            if (this.useCachedIdentity) {
                if (this.cachedIdentity.getSecurityIdentity() != null) {
                    return this.cachedIdentity.getSecurityIdentity().getRoles().contains(role);
                }
                return Roles.fromSet((Set)this.cachedIdentity.getRoles()).contains(role);
            }
            return super.isUserInRole(role);
        }

        void stopUsingCachedIdentity() {
            this.useCachedIdentity = false;
        }

        HttpServletRequest getOriginal() {
            return this.originalRequest;
        }
    }
}

