/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.handlers.AbstractSecurityContextAssociationHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.List;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronHttpSession;
import org.wildfly.elytron.web.undertow.server.SecurityContextImpl;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpSessionSpi;

public class ElytronContextAssociationHandler
extends AbstractSecurityContextAssociationHandler {
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;

    public ElytronContextAssociationHandler(HttpHandler next, Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
        super((HttpHandler)Assert.checkNotNullParam((String)"next", (Object)next));
        this.mechanismSupplier = (Supplier)Assert.checkNotNullParam((String)"mechanismSupplier", mechanismSupplier);
    }

    public SecurityContext createSecurityContext(HttpServerExchange exchange) {
        return new SecurityContextImpl(exchange, this.mechanismSupplier, this.createHttpSessionSpi(exchange));
    }

    protected Supplier<HttpSessionSpi> createHttpSessionSpi(HttpServerExchange exchange) {
        return () -> new ElytronHttpSession(exchange);
    }
}

