/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.handlers.AbstractSecurityContextAssociationHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.elytron.web.undertow.server.SecurityContextImpl;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

public class ElytronContextAssociationHandler
extends AbstractSecurityContextAssociationHandler {
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final Function<HttpServerExchange, ElytronHttpExchange> httpExchangeSupplier;

    private ElytronContextAssociationHandler(Builder builder) {
        super((HttpHandler)Assert.checkNotNullParam((String)"next", (Object)builder.next));
        this.mechanismSupplier = (Supplier)Assert.checkNotNullParam((String)"mechanismSupplier", builder.mechanismSupplier);
        this.httpExchangeSupplier = (Function)Assert.checkNotNullParam((String)"httpExchangeSupplier", builder.httpExchangeSupplier);
    }

    public SecurityContext createSecurityContext(HttpServerExchange exchange) {
        return SecurityContextImpl.builder().setExchange(exchange).setMechanismSupplier(this.mechanismSupplier).setHttpExchangeSupplier(this.httpExchangeSupplier.apply(exchange)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        HttpHandler next;
        Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        Function<HttpServerExchange, ElytronHttpExchange> httpExchangeSupplier = ElytronHttpExchange::new;

        private Builder() {
        }

        public Builder setNext(HttpHandler next) {
            this.next = next;
            return this;
        }

        public Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        public Builder setHttpExchangeSupplier(Function<HttpServerExchange, ElytronHttpExchange> httpExchangeSupplier) {
            this.httpExchangeSupplier = httpExchangeSupplier;
            return this;
        }

        public HttpHandler build() {
            return new ElytronContextAssociationHandler(this);
        }
    }
}

