/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLSession;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronAccount;
import org.wildfly.elytron.web.undertow.server.ScopeSessionListener;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerScopes;
import org.wildfly.security.http.Scope;

public class ElytronHttpExchange
implements HttpExchangeSpi {
    private static final AttachmentKey<HttpScope> HTTP_SCOPE_ATTACHMENT_KEY = AttachmentKey.create(HttpScope.class);
    private final HttpServerExchange httpServerExchange;
    private final Map<Scope, Function<HttpServerExchange, HttpScope>> scopeResolvers;
    private final ScopeSessionListener scopeSessionListener;
    private final FormParserFactory formParserFactory = FormParserFactory.builder().build();
    private Map<String, List<String>> requestParameters;

    protected ElytronHttpExchange(HttpServerExchange httpServerExchange, Map<Scope, Function<HttpServerExchange, HttpScope>> scopeResolvers, ScopeSessionListener scopeSessionListener) {
        this.httpServerExchange = (HttpServerExchange)Assert.checkNotNullParam((String)"httpServerExchange", (Object)httpServerExchange);
        this.scopeResolvers = scopeResolvers;
        this.scopeSessionListener = scopeSessionListener;
    }

    protected ElytronHttpExchange(HttpServerExchange httpServerExchange) {
        this(httpServerExchange, Collections.emptyMap(), null);
    }

    public List<String> getRequestHeaderValues(String headerName) {
        return this.httpServerExchange.getRequestHeaders().get(headerName);
    }

    public void addResponseHeader(String headerName, String headerValue) {
        this.httpServerExchange.getResponseHeaders().add(new HttpString(headerName), headerValue);
    }

    public SSLSession getSSLSession() {
        ServerConnection connection = this.httpServerExchange.getConnection();
        if (connection instanceof HttpServerConnection) {
            return ((HttpServerConnection)connection).getSslSession();
        }
        return null;
    }

    public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
        SecurityContext securityContext = this.httpServerExchange.getSecurityContext();
        if (securityContext != null) {
            securityContext.authenticationComplete((Account)new ElytronAccount(securityIdentity), mechanismName, false);
        }
    }

    public void authenticationFailed(String message, String mechanismName) {
        SecurityContext securityContext = this.httpServerExchange.getSecurityContext();
        if (securityContext != null) {
            securityContext.authenticationFailed(message, mechanismName);
        }
    }

    public void badRequest(HttpAuthenticationException error, String mechanismName) {
    }

    public String getRequestMethod() {
        return this.httpServerExchange.getRequestMethod().toString();
    }

    public URI getRequestURI() {
        String scheme = this.httpServerExchange.getRequestScheme();
        String host = this.httpServerExchange.getHostName();
        int port = this.httpServerExchange.getHostPort();
        String path = this.httpServerExchange.getRequestPath();
        String query = this.httpServerExchange.getQueryString();
        try {
            return new URI(scheme, null, host, "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443 ? -1 : port, path, query, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getRequestParameters() {
        if (this.requestParameters == null) {
            ElytronHttpExchange elytronHttpExchange = this;
            synchronized (elytronHttpExchange) {
                if (this.requestParameters == null) {
                    HashMap parameters = new HashMap();
                    Map queryParameters = this.httpServerExchange.getQueryParameters();
                    FormDataParser parser = this.formParserFactory.createParser(this.httpServerExchange);
                    if (parser != null) {
                        try {
                            FormData data = parser.parseBlocking();
                            for (String name2 : queryParameters.keySet()) {
                                ArrayList values2 = new ArrayList((Collection)queryParameters.get(name2));
                                if (data.contains(name2)) {
                                    Deque formValues = data.get(name2);
                                    formValues.stream().filter(fv -> !fv.isFile()).forEach(fv -> values2.add(fv.getValue()));
                                }
                                parameters.put(name2, Collections.unmodifiableList(values2));
                            }
                            StreamSupport.stream(data.spliterator(), true).filter(s -> !parameters.containsKey(s)).forEach(s -> parameters.put((String)s, Collections.unmodifiableList(data.get(s).stream().filter(v -> !v.isFile()).map(fv -> fv.getValue()).collect(Collectors.toList()))));
                        }
                        catch (IOException iOException) {}
                    } else {
                        queryParameters.forEach((name, values) -> parameters.put((String)name, Collections.unmodifiableList(new ArrayList(values))));
                    }
                    this.requestParameters = Collections.unmodifiableMap(parameters);
                }
            }
        }
        return this.requestParameters;
    }

    public List<HttpServerCookie> getCookies() {
        Map cookies = this.httpServerExchange.getRequestCookies();
        return cookies.values().stream().map(cookie -> new HttpServerCookie((Cookie)cookie){
            final /* synthetic */ Cookie val$cookie;
            {
                this.val$cookie = cookie;
            }

            public String getName() {
                return this.val$cookie.getName();
            }

            public String getValue() {
                return this.val$cookie.getValue();
            }

            public String getDomain() {
                return this.val$cookie.getDomain();
            }

            public int getMaxAge() {
                return this.val$cookie.getMaxAge();
            }

            public String getPath() {
                return this.val$cookie.getPath();
            }

            public boolean isSecure() {
                return this.val$cookie.isSecure();
            }

            public int getVersion() {
                return this.val$cookie.getVersion();
            }

            public boolean isHttpOnly() {
                return this.val$cookie.isHttpOnly();
            }
        }).collect(Collectors.toList());
    }

    public InputStream getRequestInputStream() {
        return this.httpServerExchange.getInputStream();
    }

    public InetSocketAddress getSourceAddress() {
        return this.httpServerExchange.getSourceAddress();
    }

    public void setResponseCookie(HttpServerCookie cookie) {
        CookieImpl actualCookie = new CookieImpl(cookie.getName(), cookie.getValue());
        actualCookie.setDomain(cookie.getDomain());
        actualCookie.setMaxAge(Integer.valueOf(cookie.getMaxAge()));
        actualCookie.setHttpOnly(cookie.isHttpOnly());
        actualCookie.setSecure(cookie.isSecure());
        actualCookie.setPath(cookie.getPath());
        this.httpServerExchange.setResponseCookie((Cookie)actualCookie);
    }

    public OutputStream getResponseOutputStream() {
        return this.httpServerExchange.getOutputStream();
    }

    public HttpScope getScope(Scope scope) {
        if (this.scopeResolvers.containsKey(scope)) {
            return this.scopeResolvers.get(scope).apply(this.httpServerExchange);
        }
        switch (scope) {
            case APPLICATION: {
                return null;
            }
            case CONNECTION: {
                return this.getScope((AbstractAttachable)this.httpServerExchange.getConnection());
            }
            case EXCHANGE: {
                return this.getScope((AbstractAttachable)this.httpServerExchange);
            }
            case GLOBAL: {
                return null;
            }
            case SESSION: {
                SessionManager sessionManager = this.getSessionManager();
                SessionConfig sessionConfig = this.getSessionConfig();
                Session session = sessionManager.getSession(this.httpServerExchange, sessionConfig);
                if (session == null) {
                    session = sessionManager.createSession(this.httpServerExchange, sessionConfig);
                }
                return this.toScope(session);
            }
            case SSL_SESSION: {
                return this.getScope(this.getSSLSession());
            }
        }
        return null;
    }

    public Collection<String> getScopeIds(Scope scope) {
        if (scope == Scope.SESSION) {
            SessionManager sessionManager = this.getSessionManager();
            return sessionManager.getAllSessions();
        }
        return null;
    }

    public HttpScope getScope(Scope scope, String id) {
        SessionManager sessionManager;
        Session session;
        if (scope == Scope.SESSION && (session = (sessionManager = this.getSessionManager()).getSession(id)) != null) {
            return this.toScope(session);
        }
        return null;
    }

    public void setStatusCode(int statusCode) {
        if (!this.httpServerExchange.isResponseStarted()) {
            this.httpServerExchange.setStatusCode(statusCode);
        }
    }

    protected SessionManager getSessionManager() {
        return (SessionManager)this.httpServerExchange.getAttachment(SessionManager.ATTACHMENT_KEY);
    }

    protected SessionConfig getSessionConfig() {
        return (SessionConfig)this.httpServerExchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
    }

    private HttpScope toScope(final Session session) {
        return new HttpScope(){

            public String getID() {
                return session.getId();
            }

            public boolean supportsAttachments() {
                return true;
            }

            public void setAttachment(String key, Object value) {
                session.setAttribute(key, value);
            }

            public Object getAttachment(String key) {
                return session.getAttribute(key);
            }

            public boolean supportsInvalidation() {
                return true;
            }

            public boolean invalidate() {
                session.invalidate(ElytronHttpExchange.this.httpServerExchange);
                return true;
            }

            public boolean supportsNotifications() {
                return ElytronHttpExchange.this.scopeSessionListener != null;
            }

            public void registerForNotification(Consumer<HttpServerScopes> notificationConsumer) {
                if (ElytronHttpExchange.this.scopeSessionListener != null) {
                    ElytronHttpExchange.this.scopeSessionListener.registerListener(session, notificationConsumer);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpScope getScope(AbstractAttachable attachable) {
        HttpScope httpScope = (HttpScope)attachable.getAttachment(HTTP_SCOPE_ATTACHMENT_KEY);
        if (httpScope == null) {
            AbstractAttachable abstractAttachable = attachable;
            synchronized (abstractAttachable) {
                httpScope = (HttpScope)attachable.getAttachment(HTTP_SCOPE_ATTACHMENT_KEY);
                if (httpScope == null) {
                    final HashMap storageMap = new HashMap();
                    httpScope = new HttpScope(){

                        public boolean supportsAttachments() {
                            return true;
                        }

                        public void setAttachment(String key, Object value) {
                            if (value != null) {
                                storageMap.put(key, value);
                            } else {
                                storageMap.remove(key);
                            }
                        }

                        public Object getAttachment(String key) {
                            return storageMap.get(key);
                        }
                    };
                    attachable.putAttachment(HTTP_SCOPE_ATTACHMENT_KEY, (Object)httpScope);
                }
            }
        }
        return httpScope;
    }

    private HttpScope getScope(final SSLSession sslSession) {
        if (sslSession == null) {
            return null;
        }
        return new HttpScope(){

            public boolean supportsAttachments() {
                return true;
            }

            public void setAttachment(String key, Object value) {
                sslSession.putValue(key, value);
            }

            public Object getAttachment(String key) {
                return sslSession.getValue(key);
            }
        };
    }
}

