/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.AbstractSecurityContext;
import io.undertow.server.HttpServerExchange;
import java.util.List;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpAuthenticator;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

public class SecurityContextImpl
extends AbstractSecurityContext {
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private ElytronHttpExchange httpExchange;

    private SecurityContextImpl(Builder builder) {
        super((HttpServerExchange)Assert.checkNotNullParam((String)"exchange", (Object)builder.exchange));
        this.mechanismSupplier = (Supplier)Assert.checkNotNullParam((String)"mechanismSupplier", builder.mechanismSupplier);
        this.httpExchange = (ElytronHttpExchange)Assert.checkNotNullParam((String)"httpExchange", (Object)builder.httpExchange);
    }

    public boolean authenticate() {
        HttpAuthenticator authenticator = HttpAuthenticator.builder().setMechanismSupplier(this.mechanismSupplier).setHttpExchangeSpi((HttpExchangeSpi)this.httpExchange).setRequired(this.isAuthenticationRequired()).setIgnoreOptionalFailures(false).build();
        try {
            return authenticator.authenticate();
        }
        catch (HttpAuthenticationException e) {
            this.exchange.setResponseCode(500);
            return false;
        }
    }

    public boolean login(String username, String password) {
        return false;
    }

    public void addAuthenticationMechanism(AuthenticationMechanism mechanism) {
        throw new UnsupportedOperationException();
    }

    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        throw new UnsupportedOperationException();
    }

    public IdentityManager getIdentityManager() {
        throw new UnsupportedOperationException();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        HttpServerExchange exchange;
        Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        ElytronHttpExchange httpExchange;

        private Builder() {
        }

        Builder setExchange(HttpServerExchange exchange) {
            this.exchange = exchange;
            return this;
        }

        Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        Builder setHttpExchangeSupplier(ElytronHttpExchange httpExchange) {
            this.httpExchange = httpExchange;
            return this;
        }

        SecurityContext build() {
            return new SecurityContextImpl(this);
        }
    }
}

