/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.AbstractSecurityContext;
import io.undertow.server.HttpServerExchange;
import java.security.AccessController;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronAccount;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.security.auth.server.FlexibleIdentityAssociation;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpAuthenticator;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.Scope;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityContextImpl
extends AbstractSecurityContext {
    private static final Logger log = Logger.getLogger((String)"org.wildfly.security.http");
    private static final String AUTHENTICATED_PRINCIPAL_KEY = SecurityContextImpl.class.getName() + ".authenticated-principal";
    private final String programaticMechanismName;
    private final SecurityDomain securityDomain;
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final ElytronHttpExchange httpExchange;
    private Runnable logoutHandler;
    private final FlexibleIdentityAssociation flexibleIdentityAssociation;
    private AuthenticationMode authMode;

    private SecurityContextImpl(Builder builder) {
        super((HttpServerExchange)Assert.checkNotNullParam((String)"exchange", (Object)builder.exchange));
        this.programaticMechanismName = (String)Assert.checkNotNullParam((String)"programaticMechanismName", (Object)builder.programaticMechanismName);
        this.securityDomain = builder.securityDomain;
        this.mechanismSupplier = (Supplier)Assert.checkNotNullParam((String)"mechanismSupplier", builder.mechanismSupplier);
        this.httpExchange = (ElytronHttpExchange)Assert.checkNotNullParam((String)"httpExchange", (Object)builder.httpExchange);
        this.authMode = builder.authMode;
        this.flexibleIdentityAssociation = this.securityDomain != null ? this.securityDomain.getAnonymousSecurityIdentity().createFlexibleAssociation() : null;
    }

    public boolean authenticate() {
        if (this.isAuthenticated() || this.authMode == AuthenticationMode.CONSTRAINT_DRIVEN && !this.isAuthenticationRequired()) {
            return true;
        }
        if (this.restoreIdentity()) {
            return true;
        }
        HttpAuthenticator authenticator = HttpAuthenticator.builder().setMechanismSupplier(this.mechanismSupplier).setHttpExchangeSpi((HttpExchangeSpi)this.httpExchange).setRequired(this.isAuthenticationRequired()).setIgnoreOptionalFailures(false).registerLogoutHandler(this::setLogoutHandler).build();
        try {
            return authenticator.authenticate();
        }
        catch (HttpAuthenticationException e) {
            log.trace((Object)"Authentication failed.", (Throwable)e);
            this.exchange.setStatusCode(500);
            return false;
        }
    }

    private void setLogoutHandler(Runnable runnable) {
        this.logoutHandler = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String username, String password) {
        if (this.securityDomain == null) {
            return false;
        }
        ServerAuthenticationContext authenticationContext = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(() -> this.securityDomain.createNewAuthenticationContext()) : this.securityDomain.createNewAuthenticationContext();
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(password.toCharArray());
        try {
            authenticationContext.setAuthenticationName(username);
            if (authenticationContext.verifyEvidence((Evidence)evidence)) {
                if (authenticationContext.authorize()) {
                    HttpScope sessionScope;
                    SecurityIdentity authorizedIdentity = authenticationContext.getAuthorizedIdentity();
                    if (this.flexibleIdentityAssociation != null) {
                        this.flexibleIdentityAssociation.setIdentity(authorizedIdentity);
                    }
                    if ((sessionScope = this.httpExchange.getScope(Scope.SESSION)) != null && sessionScope.supportsAttachments()) {
                        sessionScope.setAttachment(AUTHENTICATED_PRINCIPAL_KEY, (Object)username);
                    }
                    this.setupProgramaticLogout(sessionScope);
                    this.authenticationComplete(new ElytronAccount(authorizedIdentity), this.programaticMechanismName, false);
                    boolean bl = true;
                    return bl;
                }
                this.authenticationFailed("Authorization Failed", this.programaticMechanismName);
            } else {
                this.authenticationFailed("Authentication Failed", this.programaticMechanismName);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | RealmUnavailableException e) {
            this.authenticationFailed(e.getMessage(), this.programaticMechanismName);
        }
        finally {
            evidence.destroy();
        }
        return false;
    }

    public void logout() {
        super.logout();
        if (this.logoutHandler != null) {
            this.logoutHandler.run();
        }
        if (this.flexibleIdentityAssociation != null) {
            this.flexibleIdentityAssociation.setIdentity(this.securityDomain.getAnonymousSecurityIdentity());
        }
    }

    private boolean restoreIdentity() {
        String principalName;
        if (this.securityDomain == null) {
            return false;
        }
        HttpScope sessionScope = this.httpExchange.getScope(Scope.SESSION);
        if (sessionScope != null && sessionScope.supportsAttachments() && (principalName = (String)sessionScope.getAttachment(AUTHENTICATED_PRINCIPAL_KEY, String.class)) != null) {
            ServerAuthenticationContext authenticationContext = this.securityDomain.createNewAuthenticationContext();
            try {
                authenticationContext.setAuthenticationName(principalName);
                if (authenticationContext.authorize()) {
                    SecurityIdentity authorizedIdentity = authenticationContext.getAuthorizedIdentity();
                    this.authenticationComplete(new ElytronAccount(authorizedIdentity), this.programaticMechanismName, false);
                    this.setupProgramaticLogout(sessionScope);
                    return true;
                }
                sessionScope.setAttachment(AUTHENTICATED_PRINCIPAL_KEY, null);
            }
            catch (IllegalArgumentException | IllegalStateException | RealmUnavailableException e) {
                this.authenticationFailed(e.getMessage(), this.programaticMechanismName);
            }
        }
        return false;
    }

    public void addAuthenticationMechanism(AuthenticationMechanism mechanism) {
        throw new UnsupportedOperationException();
    }

    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        throw new UnsupportedOperationException();
    }

    public IdentityManager getIdentityManager() {
        throw new UnsupportedOperationException();
    }

    private void setupProgramaticLogout(HttpScope sessionScope) {
        this.logoutHandler = () -> sessionScope.setAttachment(AUTHENTICATED_PRINCIPAL_KEY, null);
    }

    FlexibleIdentityAssociation getFlexibleIdentityAssociation() {
        return this.flexibleIdentityAssociation;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        HttpServerExchange exchange;
        String programaticMechanismName;
        SecurityDomain securityDomain;
        Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        ElytronHttpExchange httpExchange;
        AuthenticationMode authMode;

        private Builder() {
        }

        Builder setExchange(HttpServerExchange exchange) {
            this.exchange = exchange;
            return this;
        }

        Builder setProgramaticMechanismName(String programaticMechanismName) {
            this.programaticMechanismName = programaticMechanismName;
            return this;
        }

        public Builder setAuthMode(AuthenticationMode authMode) {
            this.authMode = authMode;
            return this;
        }

        Builder setSecurityDomain(SecurityDomain securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        Builder setHttpExchangeSupplier(ElytronHttpExchange httpExchange) {
            this.httpExchange = httpExchange;
            return this;
        }

        SecurityContext build() {
            return new SecurityContextImpl(this);
        }
    }
}

